<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOtherEarningDeductionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_other_earning_deduction', function (Blueprint $table) {
            $table->id('earn_deduct_id');
            $table->integer('type');
            $table->string("title",200);
            $table->foreignId('item_id');
            $table->foreign('item_id')->references('item_id')->on('hr_transaction_items')->onDelete('cascade');
            $table->integer('calcualte');
            $table->string("formula",200);
            $table->boolean('epf');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('other_earning_deduction');
    }
}
