<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAtdHolidaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_atd_holidays', function (Blueprint $table) {
            $table->id();
            $table->date('holyday_date');
            $table->foreignId('holyday_type_id');
            $table->foreign('holyday_type_id')->references('holyday_type_id')->on('hr_atd_holiday_types')->onDelete('cascade');
            $table->foreignId('site_id');
            $table->foreign('site_id')->references('site_id')->on('hr_employee_sites')->onDelete('cascade');
            $table->string('remarks',250);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('atd_holidays');
    }
}
