<?php

namespace Modules\Hr\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Modules\Hr\Entities\Bank;
use Modules\Hr\Entities\BankBranch;
use Modules\Hr\Entities\Company;
use Modules\Hr\Entities\EmployeeCategory;
use Modules\Hr\Entities\EmployeeCivilstatus;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Hr\Entities\EmployeeDesignation;
use Modules\Hr\Entities\EmployeeSection;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Hr\Entities\EmployeeStatus;
use Modules\Hr\Entities\EmployeeSubsection;
use Modules\Hr\Entities\EmployeeType;
use Modules\Hr\Entities\GsDivision;
use Modules\Hr\Entities\MohDivision;
use Modules\Hr\Entities\Police;
use Modules\Hr\Entities\Town;

class SettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        //
        $this->townSeeder();
        $this->civilStatusSeeder();
        $this->designationSeeder();
        $this->typeSeeder();
        $this->employeeStatusSeeder();
        $this->employeeSiteSeeder();
        $this->departmentSeeder();
        $this->sectionSeeder();
        $this->subSectionSeeder();
        $this->bankSeeder();
        $this->bankBranchSeeder();
        $this->companySeeder();
        $this->categorySeeder();
        $this->mohDivisionSeeder();
        $this->policeSeeder();
        $this->gsDivisionSeeder();
    }



    private function townSeeder()
    {
        Town::create([
            "town" => "Unspecified",
            "status" => 1
        ]);
    }



    private function civilStatusSeeder()
    {
        EmployeeCivilstatus::create([
            "civilstatus" => "Unspecified",
            "status" => 1
        ]);
    }



    private function designationSeeder()
    {
        EmployeeDesignation::create([
            "designation" => "Unspecified",
            "status" => 1
        ]);
    }



    private function typeSeeder()
    {
        EmployeeType::create([
            "employeetype" => "Unspecified",
            "status" => 1
        ]);
    }



    private function employeeStatusSeeder()
    {
        EmployeeStatus::create([
            "employeestatus" => "Unspecified",
            "status" => 1
        ]);
    }



    private function employeeSiteSeeder()
    {
        EmployeeSite::create([
            "site" => "Unspecified",
            "status" => 1
        ]);
    }


    private function departmentSeeder()
    {
        EmployeeDepartment::create([
            "department" => "Unspecified",
            "status" => 1
        ]);
    }


    private function sectionSeeder()
    {
        EmployeeSection::create([
            "section" => "Unspecified",
            "status" => 1
        ]);
    }



    private function subSectionSeeder()
    {
        EmployeeSubsection::create([
            "subsection" => "Unspecified",
            "section_id" => 1,
            "status" => 1
        ]);
    }



    private function bankSeeder()
    {
        Bank::create([
            "bank" => "Unspecified"
        ]);
    }


    private function bankBranchSeeder()
    {
        BankBranch::create([
            "bankbranch" => "Unspecified",
            "bank_id" => 1
        ]);
    }



    private function companySeeder()
    {
        Company::create([
            "company" => "Unspecified"
        ]);
    }


    private function categorySeeder()
    {
        EmployeeCategory::create([
            "category" => "Unspecified",
            "wage_calculate" => 1,
            "wage_pay_type" => 1,
            "work_days_month" => 0.0,
            "work_hour_day" => 0.0,
            "ot_rate1" => 0.0,
            "ot_rate2" => 0.0,
            "ot_rate3" => 0.0,
            "epf_employer" => 0.0,
            "epf_employee" => 0.0,
            "etf_employee" => 0.0,
            "budget_allowance1" => 0.0,
            "budget_allowance2" => 0.0,
            "fine_rate" => 0.0,
            "status" => 1
        ]);
    }


    private function mohDivisionSeeder()
    {
        MohDivision::create([
            "moh_division" => "Unspecified",
            "moh_mobile" => "",
            "office_phone" => "",
            "contact_person" => "",
            "status" => 1
        ]);
    }

    private function policeSeeder()
    {
        Police::create([
            "police_station" => "Unspecified",
            "oic_mobile" => "",
            "office_phone" => "",
            "contact_person" => "",
            "status" => 1
        ]);
    }

    private function gsDivisionSeeder()
    {
        GsDivision::create([
            "gs_division" => "Unspecified",
            "gs_mobile" => "",
            "office_phone" => "",
            "contact_person" => "",
            "status" => 1
        ]);
    }
}
