<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class AtdHolidayType extends Model
{
    protected $table = 'hr_atd_holiday_types';
    protected $primaryKey = 'holyday_type_id';
    use HasFactory, LogsActivity;
    protected static $logAttributes = [
        'holyday_type_id',
        'holyday_type',
        'status',
        'editable',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_atd_holiday_types";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
