<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class AttEmployeeLeave extends Model
{
    protected $table = 'hr_att_employee_leaves';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'id',
        'employee_id',
        'leave_type_id',
        'count',
        'year',
        'month',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_att_employee_leaves";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
