<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class AttShift extends Model
{
    protected $table = 'hr_att_shifts';
    protected $primaryKey = 'shift_id'; 
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'schedule_id',
        'employee_id',
        'shift_id',
        'schedule_date_from',
        'in_time',
        'out_time',
        'original_in_time',
        'original_out_time',
        'edited_by',
        'remark',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_att_shifts";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
