<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class AttSpcWorkdays extends Model
{
    protected $table = 'hr_att_spc_workdays';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'id',
        'sp_work_date',
        'sp_work_type_id',
        'day_type',
        'remarks',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_att_spc_workdays";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
