<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class BankBranch extends Model
{
    protected $table = 'hr_bank_branches';
    protected $primaryKey = 'bankbranch_id';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'bankbranch_id',
        'bankbranch',
        'bank_id',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_bank_branches";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
