<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class Company extends Model
{
    protected $table = 'hr_companies';
    protected $primaryKey = 'company_id';
    use HasFactory, LogsActivity;
    protected static $logAttributes = [
        'company_id',
        'company',
        'address',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_companies";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
