<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class LeaveType extends Model
{
    protected $table = 'hr_att_leave_types';
    protected $primaryKey = 'leave_type_id'; 
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'leave_type_id',
        'leave_type',
        'days_per_year',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_att_leave_types";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }

}
