<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class Police extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'hr_police';
    protected $primaryKey = 'police_station_id';

    protected $fillable = [];
    protected static $logAttributes = [
        'earn_deduct_id',
        'type',
        'title',
        'item_id',
        'calcualte',
        'formula',
        'epf',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_police";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    /*protected static function newFactory()
    {
        return \Modules\Hr\Database\factories\PoliceFactory::new();
    }*/
}
