<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class SalaryAdvance extends Model
{
    protected $table = 'hr_salary_advances';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'id',
        'employee_id',
        'amount',
        'tran_date',
        'deduct_year',
        'deduct_month',
        'requested_by',
        'approved_by',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_salary_advances";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
