<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class Town extends Model
{
    protected $table = 'hr_towns';
    protected $primaryKey = 'town_id'; 
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'town_id',
        'town',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_towns";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
