<?php

namespace Modules\Hr\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Http;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\GlobalSettings;
use Illuminate\Support\Facades\Auth;

class AttendanceProcessController extends Controller
{

    protected $url = 'https://hrcontract.riococo.live/script'; 
    //protected $url = 'http://localhost/riococo_script';

    public function allEmployees()
    {
        try {
            $employees = [];
            $user = Auth::user();
            if ($user && ($user->can('post_payroll') || $user->can('process_raw_data') || $user->can('process_calculation'))) {
                //$employees = Employee::where('category_id', '!=', 2)->get();
                $employees = Employee::whereNotIn('category_id', [2, 3, 10, 11, 12])->get();
            } elseif ($user && ($user->can('post_payroll_staff') || $user->can('process_raw_data_staff') || $user->can('process_calculation_staff'))) {
                //$employees = Employee::where('category_id', 2)->get();
		$employees = Employee::whereIn('category_id', [2, 3, 10, 11, 12])->get();
            }

            $collection = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($collection, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['employee_id']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $collection);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function allEmployeesSite()
    {
        try {
            $sites = EmployeeSite::all();
            $responseBody = $this->responseBody(true, "Employee", "all", $sites);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function getProcessEmployees()
    {
        try {
            $employees = Employee::where('employeestatus_id', '!=', 4)->get();
            $responseBody = $this->responseBody(true, "getProcessEmployees", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "getProcessEmployees", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }







    public function attendanceRawDataProcessAll($id, $fromDate, $toDate)
    {
        ini_set('max_execution_time', '0'); // for infinite time of execution 

        $user = Auth::user();
        $employee = Employee::find($id);
        $emp_id = "";
        $emp_name = "";
        if ($user && ($user->can('post_payroll') || $user->can('process_raw_data') || $user->can('process_calculation'))) {

            if ($employee && $employee->category_id != 2) {
                $emp_id = $employee->employee_id;
                $emp_name = $employee->name_withinitial . "xxxx";
                Http::get($this->url . '/riococo_rawdata_script2/index.php', ['process' => 'Employee', 'fromDate' => $fromDate, 'toDate' => $toDate, 'id' => $id]);
            }
            //return response()->json(["status" => 100, "employee" => ["id" => $emp_id, "name" => $emp_name]]);
        } else if ($user && ($user->can('post_payroll_staff') || $user->can('process_raw_data_staff') || $user->can('process_calculation_staff'))) {

            if ($employee && $employee->category_id == 2) {
                $emp_id = $employee->employee_id;
                $emp_name = $employee->name_withinitial;
                Http::get($this->url . '/riococo_rawdata_script2/index.php', ['process' => 'Employee', 'fromDate' => $fromDate, 'toDate' => $toDate, 'id' => $id]);
            }
            //return response()->json(["status" => 100, "employee" => ["id" => $emp_id, "name" => $emp_name]]);
        } else {
            if ($employee) {
                $emp_id = $employee->employee_id;
                $emp_name = $employee->name_withinitial;
                Http::get($this->url . '/riococo_rawdata_script2/index.php', ['process' => 'Employee', 'fromDate' => $fromDate, 'toDate' => $toDate, 'id' => $id]);
            }
        }



        return response()->json(["status" => 100, "employee" => ["id" => $emp_id, "name" => $emp_name]]);
    }


    public function attendanceRawDataProcessAllSite($id, $fromDate, $toDate, $site)
    {
        ini_set('max_execution_time', '0'); // for infinite time of execution 
        $employee = Employee::where([['employee_id', '=', $id], ['site_id', '=', $site]])->first();
        $emp_id = "";
        $emp_name = "";
        if ($employee) {
            Http::get($this->url . '/riococo_rawdata_script2/index.php', ['process' => 'Employee', 'fromDate' => $fromDate, 'toDate' => $toDate, 'id' => $id]);
            $emp_id = $employee->employee_id;
            $emp_name = $employee->name_withinitial;
        }
        return response()->json(["status" => 100, "employee" => ["id" => $emp_id, "name" => $emp_name]]);
    }




    public function attendanceRawDataProcessEmployee($id, $fromDate, $toDate)
    {
        ini_set('max_execution_time', '0'); // for infinite time of execution 
        Http::get($this->url . '/riococo_rawdata_script2/index.php', ['process' => 'Employee', 'fromDate' => $fromDate, 'toDate' => $toDate, 'id' => $id]);
        $employee = Employee::find($id);
        $emp_id = "";
        $emp_name = "";
        if ($employee) {
            $emp_id = $employee->employee_id;
            $emp_name = $employee->name_withinitial;
        }
        return response()->json(["status" => 100, "employee" => ["id" => $emp_id, "name" => $emp_name]]);
    }











    public function attendanceCalculationProcessEmployee($id, $fromDate, $toDate)
    {
        ini_set('max_execution_time', '0'); // for infinite time of execution 
        Http::get($this->url . '/riococo_employee_attendance_process/index.php',  ['process' => 'Employee', 'fromDate' => $fromDate, 'toDate' => $toDate, 'id' => $id]);
        $employee = Employee::find($id);
        $emp_id = "";
        $emp_name = "";
        if ($employee) {
            $emp_id = $employee->employee_id;
            $emp_name = $employee->name_withinitial;
        }
        return response()->json(["status" => 100, "employee" => ["id" => $emp_id, "name" => $emp_name]]);
    }

    public function attendanceCalculationProcessAll($id, $fromDate, $toDate)
    {
        ini_set('max_execution_time', '0'); // for infinite time of execution 
        $employee = Employee::find($id);
        $emp_id = "";
        $emp_name = "";
        if ($employee->employeestatus_id != "4") {
            Http::get($this->url . '/riococo_employee_attendance_process/index.php', ['process' => 'Employee', 'fromDate' => $fromDate, 'toDate' => $toDate, 'id' => $id]);
            if ($employee) {
                $emp_id = $employee->employee_id;
                $emp_name = $employee->name_withinitial;
            }
        }
        return response()->json(["status" => 100, "employee" => ["id" => $emp_id, "name" => $emp_name]]);
    }








    public function attendancePostPayrollProcessEmployee($id, $fromDate, $toDate)
    {
        ini_set('max_execution_time', '0'); // for infinite time of execution 
        return Http::get($this->url . '/riococo_employee_salary_script/index.php', ['id' => $id, 'fromDate' => $fromDate, 'toDate' => $toDate]);
    }

    public function attendancePostPayrollProcessAll($fromDate, $toDate)
    {
        ini_set('max_execution_time', '0'); // for infinite time of execution 
        //$employees = Employee::all();
        $employees = [];
        $user = Auth::user();
        if ($user && ($user->can('post_payroll') || $user->can('process_raw_data') || $user->can('process_calculation'))) {
            $employees = Employee::where('category_id', '!=', 2)->get();
        } elseif ($user && ($user->can('post_payroll_staff') || $user->can('process_raw_data_staff') || $user->can('process_calculation_staff'))) {
            $employees = Employee::where('category_id', 2)->get();
        }


        foreach ($employees as $employee) {
            if ($employee) {

                if ($employee->employeestatus_id != "4") {
                    try {
                        Http::get($this->url . '/riococo_employee_salary_script/index.php', ['id' => $employee->employee_id, 'fromDate' => $fromDate, 'toDate' => $toDate]);
                    } catch (\Exception $ex) {
                        return $ex;
                    }
                }
            }
        }
    }







    public function attendanceMontendProcess($year, $month)
    {
        try {
            $global_settings = GlobalSettings::find('1');
            if ($global_settings) {
                $global_settings->current_payroll_year = $year;
                $global_settings->current_payroll_month = $month;
                $isUpdate = $global_settings->update();
            }
            $responseBody = $this->responseBody(true, "Month End Process", "Global Settings", $isUpdate);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Month End Process", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
