<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\EmployeeCategory;

class CategoryController extends Controller
{
    //
    public function save(Request $request)
    {
        try {
            $category = new EmployeeCategory();
            $category->category = $request->get('txtCategory');
            $category->wage_calculate = $request->get('selcCalculate');
            $category->wage_pay_type = $request->get('selcPayment');
            $category->work_days_month = $request->get('txtWorkMonth');
            $category->work_hour_day = $request->get('txtWorkDay');
            $category->ot_rate1 = $request->get('txtOvertime1');
            $category->ot_rate2 = $request->get('txtOvertime2');
            $category->ot_rate3 = $request->get('txtOvertime3');
            $category->fixed_ot_rate1 = $request->get('txtFixedOtRate1');
            $category->fixed_ot_rate2 = $request->get('txtFixedOtRate2');
            $category->fixed_ot_rate3 = $request->get('txtFixedOtRate3');
            $category->epf_employer = $request->get('txtEpfEmployer');
            $category->epf_employee = $request->get('txtEpfEmployee');
            $category->etf_employee = $request->get('txtEtfEmployee');
            $category->budget_allowance1 = $request->get('txtAllowance1');
            $category->budget_allowance2 = $request->get('txtAllowance2');
            $category->fine_rate = $request->get('txtFineRate');
            $category->status = true;
            $save = $category->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "Category", "saved", null);
            } else {
                $responseBody = $this->responseBody(false, "Category", "saved", $save);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Category", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function update(Request $request, $id)
    {
        try {
            $category = EmployeeCategory::find($id);
            $category->category = $request->get('txtCategory');
            $category->wage_calculate = $request->get('selcCalculate');
            $category->wage_pay_type = $request->get('selcPayment');
            $category->work_days_month = $request->get('txtWorkMonth');
            $category->work_hour_day = $request->get('txtWorkDay');
            $category->ot_rate1 = $request->get('txtOvertime1');
            $category->ot_rate2 = $request->get('txtOvertime2');
            $category->ot_rate3 = $request->get('txtOvertime3');
            $category->fixed_ot_rate1 = $request->get('txtFixedOtRate1');
            $category->fixed_ot_rate2 = $request->get('txtFixedOtRate2');
            $category->fixed_ot_rate3 = $request->get('txtFixedOtRate3');
            $category->epf_employer = $request->get('txtEpfEmployer');
            $category->epf_employee = $request->get('txtEpfEmployee');
            $category->etf_employee = $request->get('txtEtfEmployee');
            $category->budget_allowance1 = $request->get('txtAllowance1');
            $category->budget_allowance2 = $request->get('txtAllowance2');
            $category->fine_rate = $request->get('txtFineRate');
            $update = $category->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Category", "updated", null);
            } else {
                $responseBody = $this->responseBody(false, "Category", "updated", $update);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Category", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function delete($id){
        try {

            $assigned = $this->isAssigned($id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Category", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $employee_category = EmployeeCategory::find($id);
            $delete = $employee_category->delete();

            if ($delete) {
                $responseBody = $this->responseBody(true, "Category", "deleted",null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Category", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function disable(Request $request, $id)
    {

        try {
            $assigned = $this->isAssigned($id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Category", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $category = EmployeeCategory::find($id);
            $category->status = $request->get('status');
            $disable = $category->save();
            if ($disable) {
                $responseBody = $this->responseBody(true, "Category", "updated", null);
            } else {
                $responseBody = $this->responseBody(false, "Category", "updated", $disable);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Category", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function allCategories()
    {
        try {
            $categories = EmployeeCategory::all();
            $responseBody = $this->responseBody(true, "Category", "all", $categories);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Category", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function category($id)
    {
        try {
            $category = EmployeeCategory::find($id);
            $responseBody = $this->responseBody(true, "Category", "all", $category);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Category", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function isAssigned($id)
    {

        $setting = DB::table('hr_employees')->where('category_id', $id)->first();
        if ($setting) {
            return true;
        }
        return false;
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
