<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Company;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeTeam;
use Modules\Hr\Entities\MohDivision;
use Modules\St\Entities\ApprovalRollback;
use Modules\St\Entities\Bank;
use Modules\St\Entities\BankBranch;
use Modules\St\Http\Controllers\UserApprovalRequestController;

class EmployeeController extends Controller
{


    /**
     * save
     * This function is used to save new employee to database.
     * @param request This is the paramter to save function
     * @return Json This returns as response.
     */
    public function save(Request $request)
    {

        try {

            $employeeID = $request->get('txtEmployeeID');
            if ($this->isDuplicateEmployee($employeeID)) {
                $responseBody = $this->responseBody(true, "duplicate", "Duplicate Employee ID " . $employeeID, $employeeID);

                return response()->json(["data" => $responseBody]);
            }

            $attendanceID = $request->get('txtAttendanceID');
            if ($this->isDuplicateAttendance($attendanceID)) {
                $responseBody = $this->responseBody(true, "duplicate", "Duplicate Attendance ID " . $attendanceID, $attendanceID);

                return response()->json(["data" => $responseBody]);
            }

            $file = $request->file('imgFile');

            $employee = new Employee();
            $employee->employee_id = $employeeID;
            $employee->name_withinitial = $request->get('txtName');
            $employee->name_sinhala = $request->get('txtNameSinhala');
            $employee->name_full = $request->get('txtFullName');
            $employee->callin_name = $request->get('txtCallinName');
            $employee->address = $request->get('txtEmployeeAddress');
            $employee->town_id = 1; //$request->get('selcTown');

            $employee->nic = $request->get('txtNic');
            $employee->passport = $request->get('txtParport');
            /*if ($employee->passport == null) {
                $employee->passport = "";
            }*/
            $employee->drvl = $request->get('txtLicen');
            /*if ($employee->drvl == null) {
                $employee->drvl = "";
            }*/
            $employee->birthday = $request->get('dteDateOfBorth');
            $employee->date_join = $request->get('dteDateOfJoined');
            $employee->pension_date = $request->get('txtPensionDate');
            $employee->etf_epf_date = $request->get('txtEpfEtfDate');
            /*if ($employee->date_join == null) {
                $employee->date_join = date('Y-m-d');
            }*/

            $employee->resign_date = $request->get('dteResign');
            /*if ($employee->resign_date == null) {
                $employee->resign_date = date('Y-m-d');
            }*/

            //not set true values
            $employee->id_issue_date = $request->get('dteDateOfJoined');
            /*if ($employee->id_issue_date == null) {
                $employee->id_issue_date = date('Y-m-d');
            }*/
            $employee->id_expire_date = $request->get('dteDateOfJoined');
            /*if ($employee->id_expire_date == null) {
                $employee->id_expire_date = date('Y-m-d');
            }*/
            /////

            $employee->gender_id = $request->get('selecGender');
            $employee->civilstatus_id = $request->get('selcCivilStatus');
            $employee->designation_id = $request->get('selcDesignation');
            $employee->bank_account = $request->get('txtBankAC');
            /*if ($employee->bank_account == null) {
                $employee->bank_account = '';
            }*/
            $employee->bank_id = $request->get('selcBank');

            $employee->bankbranch_id = $request->get('selcBankBranch');
            if ($file != null) {
                $employee->photo_parth = $this->fileUpload($file);
            } else {
                $employee->photo_parth = '\images\employee.jpg';
            }

            $employee->email = $request->get('txtEmail');
            /*if ($employee->email == null) {
                $employee->email = '';
            }*/
            $employee->mobile = $request->get('txtMobile');
            /*if ($employee->mobile == null) {
                $employee->mobile = '';
            }*/

            $employee->fixed = $request->get('txtFixed');
            /*if ($employee->fixed == null) {
                $employee->fixed = '';
            }*/

            $employee->gmap = $request->get('txtGmap');
            /*if ($employee->gmap == null) {
                $employee->gmap = '';
            }*/
            $employee->emegency_contact = $request->get('txtEmegencyContact');
            /*if ($employee->emegency_contact == null) {
                $employee->emegency_contact = '';
            }*/

            $employee->emegency_contactno1 = $request->get('txtEmegencyContactno1');
            /*if ($employee->emegency_contactno1 == null) {
                $employee->emegency_contactno1 = '';
            }*/

            $employee->emegency_contact2 = $request->get('txtEmegencyContact2');
            /*if ($employee->emegency_contact2 == null) {
                $employee->emegency_contact2 = '';
            }*/

            $employee->emegency_contactno2 = $request->get('txtEmegencyContactno2');
            /*if ($employee->emegency_contactno2 == null) {
                $employee->emegency_contactno2 = '';
            }*/

            $employee->attendance_id = $request->get('txtAttendanceID');

            $employee->epf_no = $request->get('txtEpfNo');
            /*if ($employee->epf_no == null) {
                $employee->epf_no = '';
            }*/

            $employee->employeetype_id = $request->get('selcEmployeeType');
            $employee->employeestatus_id = $request->get('selcEmployeeStatus');
            $employee->category_id = $request->get('selcCategory');
            $employee->site_id = $request->get('selcSite');

            $employee->department_id = $request->get('selcDepartment');
            $employee->section_id = $request->get('selcSection');
            $employee->subsection_id = $request->get('selcSubSection');
            $employee->moh_division_id = $request->get('selcMohDivision');
            $employee->police_station_id = $request->get('selcPolice');
            $employee->gs_division_id = $request->get('selcGsDivision');
            $employee->company_id = $request->get('selcCompany');
            $employee->supervisor_id = $request->get('supervisor_id');
            $employee->subcontractor = "Unspecifide"; //not set true value
            $employee->notes = $request->get('txtNotes');
            /*if ($employee->notes == null) {
                $employee->notes = '';
            }*/
            $employee->contract_expire = $request->get('dteContractExpire');
            /*if ($employee->contract_expire == null) {
                $employee->contract_expire = date('Y-m-d');
            }*/

            $employee->print_status = false;

            if ($request->get('checkSmsAlert') == 'on') {
                $employee->sms_alert = true;
            } else {
                $employee->sms_alert = false;
            }

            if ($request->get('checkEmailAlert') == 'on') {
                $employee->email_alert = true;
            } else {
                $employee->email_alert = false;
            }

            if ($request->get('checkContract') == 'on') {
                $employee->contract = true;
            } else {
                $employee->contract = false;
            }
            $employee->pay_method =  $request->get('payMethod');

            $slug = 'employee_create';

            $is_approval = UserApprovalRequestController::isApproval($slug);
            if (!$is_approval) {
                $employee->save();
            } else {
                UserApprovalRequestController::send($slug, $employee);
            }





            $responseBody = $this->responseBody(true, "Employee", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allEmployee
     * This function is used to search all employee records from the database.
     * @return Json This returns as response.
     */
    public function allEmployee()
    {

        $query = "SELECT
        hr_employee_designations.`designation` AS designation,
        hr_employees.`employee_id` AS employee_id,
        hr_employees.`name_withinitial` AS name_withinitial,
        hr_employees.`nic` AS nic
   FROM
        `hr_employee_designations` hr_employee_designations INNER JOIN `hr_employees` hr_employees ON hr_employee_designations.`designation_id` = hr_employees.`designation_id` ORDER BY convert(hr_employees.employee_id, decimal) ASC";
        try {
            $employee =  DB::select($query);
            $responseBody = $this->responseBody(true, "Employee", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function getEmployeeFromID($id)
    {

        $query = "SELECT
        hr_employee_designations.`designation` AS designation,
        hr_employees.`employee_id` AS employee_id,
        hr_employees.`name_withinitial` AS name_withinitial,
        hr_employees.`nic` AS nic
   FROM
        `hr_employee_designations` hr_employee_designations INNER JOIN `hr_employees` hr_employees ON hr_employee_designations.`designation_id` = hr_employees.`designation_id` WHERE hr_employees.employee_id = '" . $id . "'";
        try {
            $employee =  DB::select($query);
            $responseBody = $this->responseBody(true, "Employee", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * settings
     * This function is used to search settings records from the database.
     * @return Json This returns as response.
     */
    public function settings()
    {

        try {
            $town = SettingsController::allEnableSettings("Town");
            $employeeType = SettingsController::allEnableSettings("EmployeeType");
            $employeeStatus = SettingsController::allEnableSettings("EmployeeStatus");
            $category = SettingsController::allEnableSettings("Category");
            $site = SettingsController::allEnableSettings("Site");
            $department = SettingsController::allEnableSettings("Department");
            $section = SettingsController::allEnableSettings("Section");
            $subSection = SettingsController::allEnableSettings("SubSection");
            $civilStatus = SettingsController::allEnableSettings("CivilStatus");
            $designation = SettingsController::allEnableSettings("Designation");
            $team = SettingsController::allEnableSettings("Team");
            $supervisor = Employee::all(['employee_id', 'name_withinitial', 'photo_parth']);
            $mohDivision = SettingsController::allEnableSettings("MohDivision");
            $police = SettingsController::allEnableSettings("Police");
            $gsDivision = SettingsController::allEnableSettings("GsDivision");


            //$bankbranch = DB::table('bank_branches')->where('bank_id','=','1')->get();
            $bank = bank::where('status', '=', 1)->get();
            $bankbranch = BankBranch::where('status', '=', 1)->get();
            $company = Company::all();


            $result = [
                "Town" => $town,
                "EmployeeType" => $employeeType,
                "EmployeeStatus" => $employeeStatus,
                "Category" => $category,
                "Site" => $site,
                "Department" => $department,
                "Section" => $section,
                "SubSection" => $subSection,
                "CivilStatus" => $civilStatus,
                "Designation" => $designation,
                "Team" => $team,
                "Bank" => $bank,
                "BankBranch" => $bankbranch,
                "Supervisor" => $supervisor,
                "Company" => $company,
                "MohDivision" => $mohDivision,
                "Police" => $police,
                "GsDivision" => $gsDivision,
            ];
            $responseBody = $this->responseBody(true, "Settings", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Settings", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }


    /**
     * fileUpload
     * This function is used to upload image.
     * @return String This returns as return value.
     */
    private function fileUpload($image)
    {

        $image_name = rand() . '.' . $image->getClientOriginalExtension();
        $image->move(public_path('images'), $image_name);

        return "\\images\\" . $image_name;
    }



    /**
     * isDuplicateEmployee
     * This function is used to check is duplocate employee id.
     * @return boolean This returns as return value.
     */
    private function isDuplicateEmployee($employeeID)
    {

        $duplicate = Employee::find($employeeID);
        if ($duplicate) {
            return true;
        }
        return false;
    }


    /**
     * isDuplicateAttendance
     * This function is used to check is duplocate employee id.
     * @return boolean This returns as return value.
     */
    private function isDuplicateAttendance($attendanceID)
    {

        $duplicate = Employee::where('attendance_id', '=', $attendanceID)->get();
        if ($duplicate->isEmpty()) {
            return false;
        }
        return true;
    }



    /**
     * employee
     * This function is used to search employe from employee id.
     * @return Json This returns as response.
     */
    public function employee($id)
    {

        try {
            $employee = Employee::find($id);
            if ($employee->supervisor_id == 'Unspecified') {
                $employee->supervisor = 'Unspecified';
            } else {
                $supervisor = Employee::find($employee->supervisor_id);
                if ($supervisor) {
                    $employee->supervisor = $supervisor->name_withinitial;
                }
            }
            $employee->team_id = $this->getEmployeeTeam($id);
            $responseBody = $this->responseBody(true, "Employee", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /*
    public function update(Request $request, $id)
    {
        try {

            $file = $request->file('imgFile');

            $employee = Employee::find($id);
            $employee->employee_id = $request->get('txtEmployeeID');
            $employee->name_withinitial = $request->get('txtName');
            $employee->name_full = $request->get('txtFullName');
            $employee->address = $request->get('txtEmployeeAddress');
            $employee->town_id = $request->get('selcTown');

            $employee->nic = $request->get('txtNic');
            $employee->passport = $request->get('txtParport');
            $employee->drvl = $request->get('txtLicen');
            $employee->birthday = $request->get('dteDateOfBorth');
            $employee->date_join = $request->get('dteDateOfJoined');

            $employee->gender_id = $request->get('selecGender');
            $employee->civilstatus_id = $request->get('selcCivilStatus');
            $employee->designation_id = $request->get('selcDesignation');
            $employee->bank_account = $request->get('txtBankAC');
            $employee->bank_id = $request->get('selcBank');
            $employee->bankbranch_id = $request->get('selcBankBranch');

            $employee->bankbranch_id = $request->get('selcBankBranch');
            if ($file) {
                $employee->photo_parth = $this->fileUpload($file);
            }

            $employee->email = $request->get('txtEmail');
            $employee->mobile = $request->get('txtMobile');
            $employee->fixed = $request->get('txtFixed');

            $employee->gmap = $request->get('txtGmap');
            $employee->emegency_contact = $request->get('txtEmegencyContact');
            $employee->emegency_contactno1 = $request->get('txtEmegencyContactno1');
            $employee->emegency_contactno2 = $request->get('txtEmegencyContactno2');
            $employee->attendance_id = $request->get('txtAttendanceID');

            $employee->epf_no = $request->get('txtEpfNo');
            $employee->employeetype_id = $request->get('selcEmployeeType');
            $employee->employeestatus_id = $request->get('selcEmployeeStatus');
            $employee->category_id = $request->get('selcCategory');
            $employee->site_id = $request->get('selcSite');

            $employee->department_id = $request->get('selcDepartment');
            $employee->section_id = $request->get('selcSection');
            $employee->subsection_id = $request->get('selcSubSection');
            $employee->company_id = $request->get('selcCompany');
            $employee->supervisor_id = $request->get('selcSupervisor');
            $employee->notes = $request->get('txtNotes');
            $save = $employee->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Employee", "updated", $file);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

*/



    /**
     * delete
     * This function is used to delete employe from employee id.
     * @return Json This returns as response.
     */
    public function delete($id)
    {
        try {
            $employee = Employee::find($id);
            $slug = 'employee_delete';

            $is_approval = UserApprovalRequestController::isApproval($slug);
            if (!$is_approval) {
                $employee->delete();
            } else {
                UserApprovalRequestController::send($slug, $employee);
            }

            $responseBody = $this->responseBody(true, "Employee", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * bankBranch
     * This function is used to search bank branch from bank id.
     * @return Json This returns as response.
     */
    public function bankBranch($id)
    {
        try {
            $bankbranch =  DB::select("SELECT * from hr_bank_branches WHERE bank_id = " . $id . " or bank_id = '1'");
            $responseBody = $this->responseBody(true, "BankBranch", "collection", $bankbranch);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "BankBranch", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * subSection
     * This function is used to search sub section from section id.
     * @return Json This returns as response.
     */
    public function subSection($id)
    {
        try {
            $subSection = DB::select("SELECT * from hr_employee_subsections WHERE section_id = " . $id . " or section_id = '1'");
            $responseBody = $this->responseBody(true, "BankBranch", "collection", $subSection);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "BankBranch", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * update
     * This function is used to update employee.
     * @param request This is the paramter to update function
     * @return Json This returns as response.
     */
    public function update(Request $request)
    {

        try {

            $file = $request->file('imgFile');
            $id = $request->get('hidEmployeeID');


            $employee = Employee::find($id);
            $employee->employee_id = $request->get('txtEmployeeID');
            $employee->name_withinitial = $request->get('txtName');
            $employee->name_sinhala = $request->get('txtNameSinhala');
            $employee->name_full = $request->get('txtFullName');
            $employee->callin_name = $request->get('txtCallinName');
            $employee->address = $request->get('txtEmployeeAddress');
            $employee->town_id = 1; //$request->get('selcTown');

            $employee->nic = $request->get('txtNic');
            $employee->passport = $request->get('txtParport');
            /*if ($employee->passport == null) {
                $employee->passport = "";
            }*/
            $employee->drvl = $request->get('txtLicen');
            /*if ($employee->drvl == null) {
                $employee->drvl = "";
            }*/

            $employee->birthday = $request->get('dteDateOfBorth');
            $employee->date_join = $request->get('dteDateOfJoined');
            $employee->resign_date = $request->get('dteResign');
            $employee->pension_date = $request->get('txtPensionDate');
            $employee->etf_epf_date = $request->get('txtEpfEtfDate');

            $employee->gender_id = $request->get('selecGender');
            $employee->civilstatus_id = $request->get('selcCivilStatus');
            $employee->designation_id = $request->get('selcDesignation');
            $employee->bank_account = $request->get('txtBankAC');
            /*if ($employee->bank_account == null) {
                $employee->bank_account = '';
            }*/
            $employee->bank_id = $request->get('selcBank');
            $employee->bankbranch_id = $request->get('selcBankBranch');

            $employee->bankbranch_id = $request->get('selcBankBranch');
            /*if ($file) {
                $employee->photo_parth = $this->fileUpload($file);
            }*/

            $employee->email = $request->get('txtEmail');
            /*if ($employee->email == null) {
                $employee->email = '';
            }*/

            $employee->mobile = $request->get('txtMobile');
            /*if ($employee->mobile == null) {
                $employee->mobile = '';
            }*/

            $employee->fixed = $request->get('txtFixed');
            /*if ($employee->fixed == null) {
                $employee->fixed = '';
            }*/

            $employee->gmap = $request->get('txtGmap');
            /*if ($employee->gmap == null) {
                $employee->gmap = '';
            }*/

            $employee->emegency_contact = $request->get('txtEmegencyContact');
            /*if ($employee->emegency_contact == null) {
                $employee->emegency_contact = '';
            }*/

            $employee->emegency_contactno1 = $request->get('txtEmegencyContactno1');
            /*if ($employee->emegency_contactno1 == null) {
                $employee->emegency_contactno1 = '';
            }*/

            $employee->emegency_contact2 = $request->get('txtEmegencyContact2');
            /*if ($employee->emegency_contact2 == null) {
                $employee->emegency_contact2 = '';
            }*/

            $employee->emegency_contactno2 = $request->get('txtEmegencyContactno2');
            /*if ($employee->emegency_contactno2 == null) {
                $employee->emegency_contactno2 = '';
            }*/

            $employee->attendance_id = $request->get('txtAttendanceID');

            $employee->epf_no = $request->get('txtEpfNo');
            /*if ($employee->epf_no == null) {
                $employee->epf_no = '';
            }*/

            $employee->employeetype_id = $request->get('selcEmployeeType');
            $employee->employeestatus_id = $request->get('selcEmployeeStatus');
            $employee->category_id = $request->get('selcCategory');
            $employee->site_id = $request->get('selcSite');

            $employee->department_id = $request->get('selcDepartment');
            $employee->section_id = $request->get('selcSection');
            $employee->subsection_id = $request->get('selcSubSection');
            $employee->moh_division_id = $request->get('selcMohDivision');
            $employee->police_station_id = $request->get('selcPolice');
            $employee->gs_division_id = $request->get('selcGsDivision');
            $employee->company_id = $request->get('selcCompany');
            $employee->supervisor_id = $request->get('supervisor_id');
            $employee->notes = $request->get('txtNotes');
            /*if ($employee->notes == null) {
                $employee->notes = '';
            }*/
            $employee->contract_expire = $request->get('dteContractExpire');

            if ($request->get('checkSmsAlert') == 'on') {
                $employee->sms_alert = true;
            } else {
                $employee->sms_alert = false;
            }

            if ($request->get('checkEmailAlert') == 'on') {
                $employee->email_alert = true;
            } else {
                $employee->email_alert = false;
            }

            if ($request->get('checkContract') == 'on') {
                $employee->contract = true;
            } else {
                $employee->contract = false;
            }
            $employee->pay_method =  $request->get('payMethod');

            $slug = 'employee_edit';

            $log_activity_employee = new LogActivityEmployeeController();
            $islog_activity = $log_activity_employee->recordHistory($id, $employee);

            $is_approval = UserApprovalRequestController::isApproval($slug);
            if (!$is_approval && $islog_activity) {
                $employee->save();
            } else {
                UserApprovalRequestController::send($slug, $employee);
            }

            $responseBody = $this->responseBody(true, "Employee", "updated", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function pensionDate($date, $gender)
    {
        $y = explode("-", $date)[0];
        $m = explode("-", $date)[1];
        $d = explode("-", $date)[2];
        $jd = 0;
        if ($gender == 0) {
            $jd = juliantojd($m, $d, $y) + (50 * 365.2425);
        } else if ($gender == 1) {
            $jd = juliantojd($m, $d, $y) + (55 * 365.2425) + 1;
        }

        $pension_date = jdtojulian($jd);
        $y = explode("/", $pension_date)[2];
        $d = explode("/", $pension_date)[1];
        $m = explode("/", $pension_date)[0];
        if (strlen($m) == 1) {
            $m = '0' . $m;
        }
        if (strlen($d) == 1) {
            $d = '0' . $d;
        }
        return $y . "-" . $m . "-" . $d;
    }



    /**
     * allEmployeeSearchData
     * This function is used to get all employee's data for select2.
     */
    public function allEmployeeSearchData()
    {

        try {
            $employees = Employee::all();
            $responseBody = $this->responseBody(true, "Employee", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function getEmployeeTeam($employee_id)
    {

        $team =  EmployeeTeam::where('employee_id', '=', $employee_id)->first();
        if ($team) {
            return $team->team_id;
        }
        return 0;
    }
}
