<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\SalaryAdvance;

class SalaryAdavnceController extends Controller
{
    //
    public function allEmployeeId()
    {

        try {
            $employees = Employee::all();

            $employee_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['employee_id']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employee_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    public function allEmployeeName()
    {

        try {
            $employees = Employee::all();

            $employee_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['name_withinitial']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employee_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function getEmployeeByID($id)
    {
        try {
            $employee = Employee::find($id);
            $responseBody = $this->responseBody(true, "Employee", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function save(Request $request)
    {
        try {
            $employee_id = $request->get('employee_id');
            $amount = $request->get('txtAmount');
            $tran_date = $request->get('txtTranDate');
            $year = $request->get('selcDeductYear');
            $month = $request->get('selcDeductMonth');

            $advance = new SalaryAdvance();
            $advance->employee_id = $employee_id;
            $advance->amount = $amount;
            $advance->tran_date = $tran_date;
            $advance->deduct_year = $year;
            $advance->deduct_month = $month;
            $advance->requested_by = 0;
            $advance->approved_by = 0;
            $advance->status = 0;
            $save = $advance->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "SalaryAdvance", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function update(Request $request, $id)
    {
        try {
            $employee_id = $request->get('employee_id');
            $amount = $request->get('txtAmount');
            $tran_date = $request->get('txtTranDate');
            $year = $request->get('selcDeductYear');
            $month = $request->get('selcDeductMonth');

            $advance = SalaryAdvance::find($id);
            $advance->employee_id = $employee_id;
            $advance->amount = $amount;
            $advance->tran_date = $tran_date;
            $advance->deduct_year = $year;
            $advance->deduct_month = $month;
            $advance->requested_by = 0;
            $advance->approved_by = 0;
            $advance->status = 0;
            $save = $advance->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "SalaryAdvance", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function delete($id)
    {
        try {
            $advance = SalaryAdvance::find($id);
            $delete = $advance->delete();
            if ($delete) {
                $responseBody = $this->responseBody(true, "SalaryAdvance", "deleted", null);
            } else {
                $responseBody = $this->responseBody(false, "SalaryAdvance", "not deleted", $delete);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SalaryAdvance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function allSalaryAdvance()
    {
        try {
            $query = "SELECT `salary_advances`.id AS id, `salary_advances`.tran_date AS date, `salary_advances`.employee_id AS employee_id, `salary_advances`.status AS status, `employees`.name_withinitial AS name, `salary_advances`.amount AS amount FROM `hr_employees` employees INNER JOIN `hr_salary_advances` salary_advances ON employees.employee_id = salary_advances.employee_id";
            $salary_advance = DB::select($query);
            $responseBody = $this->responseBody(true, "SalaryAdvance", "all", $salary_advance);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SalaryAdvance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function employeeFromList($id)
    {

        try {
            $salary_advance = SalaryAdvance::find($id);
            $employee = Employee::find($salary_advance->employee_id);
            $salary_advance->employee = $employee;
            $responseBody = $this->responseBody(true, "SalaryAdvance", "all", $salary_advance);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SalaryAdvance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
