<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hr\Entities\TransactionItem;
use Modules\Hr\Entities\TransactionItemSetup;
use PHPUnit\Util\Json;


class TransactionItemSetupController extends Controller
{

    public function allTransactionItemEarnings()
    {
        try {
            //$transaction_items = TransactionItem::where('type', '=', 0)->get();
            $transaction_items = TransactionItem::where('type', '=', 0)->where('status', '=', 1)->get();

            $collection = [];
            for ($i = 0; $i < count($transaction_items); $i++) {
                //$value = $transaction_items[$i]->narration . '#' . $transaction_items[$i]->item_id;
                array_push($collection, ["img"=>"/images/earning.png","id"=>$transaction_items[$i]->item_id,"value"=>$transaction_items[$i]->narration ]);
            }
            $responseBody = $this->responseBody(true, "TransactionItem", "all", $collection);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TransactionItem", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allTransactionItemDeducations()
    {
        try {
            //$transaction_items = TransactionItem::where('type', '=', 1)->get();
            $transaction_items = TransactionItem::where('type', '=', 1)->where('status', '=', 1)->get();
            $collection = [];
            for ($i = 0; $i < count($transaction_items); $i++) {
                //$value = $transaction_items[$i]->narration . '#' . $transaction_items[$i]->item_id;
                array_push($collection, ["img"=>"/images/diduction.png","id"=>$transaction_items[$i]->item_id,"value"=>$transaction_items[$i]->narration ]);
            }
            $responseBody = $this->responseBody(true, "TransactionItem", "all", $collection);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TransactionItem", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function save(Request $request)
    {

        try {
            for ($i = 0; $i <= 19; $i++) {
                $name = 'setup' . $i;
                $setup_arr = json_decode($request->get($name), true);
                
                $setup = TransactionItemSetup::find($setup_arr['setup_id']);
                if ($setup) {

                    $setup->item_id = $setup_arr['item_id'];
                    $setup->narration = $setup_arr['narration'];
                    $setup->status = $setup_arr['status'];
                    $setup->save();

                } else {

                    $setup = new TransactionItemSetup();
                    $setup->setup_id = $setup_arr['setup_id'];
                    $setup->item_id = $setup_arr['item_id'];
                    $setup->narration = $setup_arr['narration'];
                    $setup->status = $setup_arr['status'];
                    $setup->save();
                }
            }
            $responseBody = $this->responseBody(true, "TransactionItemSetup", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TransactionItemSetup", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    function allTransactionItemSetup()
    {

        try {
            $transaction_item_setup = TransactionItemSetup::all();
            $responseBody = $this->responseBody(true, "TransactionItemSetup", "all", $transaction_item_setup);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TransactionItemSetup", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
