var setting_name = null;

$(document).ready(function () {


    $('#cmbEmployeeID').select2();

    $('#cmbEmployeeID').on('change', function () {
        setting_name = "Employee";
        var title = "Shift : " + $('#cmbShift option:selected').text() + ", Filterd by employee"
        $('.card-header').text(title);
        loadExistingSchedules();
    });

    var select_option = {
        'category': false,
        'site': false,
        'department': false,
        'section': false,
        'sub_section': false,
        'company': false,
        'team': false,
        'employee': false,
    };



    $('#tblEmployeeSchedule').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "employee_id" },
            { "data": "name" },
            { "data": "shift" },
            { "data": "date" },
            { "data": "intime" },
            { "data": "outtime" },
            { "data": "remove", className: "remove" },
        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 30, targets: 6 },
        ],
    });



    var datepicker = $('input[name="date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });


    $('.clockpicker-example').clockpicker({
        autoclose: true,
        use24hours: true,
    });

    $('#txtFromDate').data('daterangepicker').setStartDate(serverDate());
    $('#txtToDate').data('daterangepicker').setStartDate(serverDate());


    datepicker.bind("change", function () {
        loadExistingSchedules();
    });


    loadAllSettings();
    loadEmployeeFromSite(0);




    $('#cmbShift').on('change', function () {

        intime_outtime($(this).val());
        loadExistingSchedules();
    });


    $('#selcSite_setting').on('change', function () {

        loadEmployeeFromSite($(this).val());
        loadExistingSchedules();

    });



    $('#selcCategory').on('change', function () {
        setting_name = 'selcCategory';
        var title = "Shift : " + $('#cmbShift option:selected').text() + ", Filterd by category"
        $('.card-header').text(title);
        loadExistingSchedules();
    });

    $('#selcSite').on('change', function () {
        setting_name = 'selcSite';
        var title = "Shift : " + $('#cmbShift option:selected').text() + ", Filterd by site"
        $('.card-header').text(title);
        loadExistingSchedules();
    });

    $('#selcDepartment').on('change', function () {
        setting_name = 'selcDepartment';
        var title = "Shift : " + $('#cmbShift option:selected').text() + ", Filterd by department"
        $('.card-header').text(title);
        loadExistingSchedules();

    });

    $('#selcSection').on('change', function () {
        setting_name = 'selcSection';
        var title = "Shift : " + $('#cmbShift option:selected').text() + ", Filterd by section"
        $('.card-header').text(title);
        loadExistingSchedules();
        subsection($(this).val());
    });

    $('#selcSubsection').on('change', function () {
        setting_name = 'selcSubsection';
        var title = "Shift : " + $('#cmbShift option:selected').text() + ", Filterd by subsection"
        $('.card-header').text(title);
        loadScheduleSubsection();
    });

    $('#selcCompany').on('change', function () {
        setting_name = 'selcCompany';
        var title = "Shift : " + $('#cmbShift option:selected').text() + ", Filterd by company"
        $('.card-header').text(title);
        loadExistingSchedules();
    });

    $('#selcTeam').on('change', function () {
        setting_name = 'selcTeam';
        var title = "Shift : " + $('#cmbShift option:selected').text() + ", Filterd by team"
        $('.card-header').text(title);
        loadExistingSchedules();
    });








    $('#selcCategory').attr('disabled', 'disabled');
    $('#selcSite').attr('disabled', 'disabled');
    $('#selcDepartment').attr('disabled', 'disabled');
    $('#selcSection').attr('disabled', 'disabled');
    $('#selcSubsection').attr('disabled', 'disabled');
    $('#selcCompany').attr('disabled', 'disabled');
    $('#selcTeam').attr('disabled', 'disabled');
    $('#cmbEmployeeID').attr('disabled', 'disabled');





    $('#switchCategory').on('click', function () {
        disable_element($('#selcCategory'), $(this).is(":checked"));
        loadExistingSchedules();
        $('#switchEmployee').prop('checked', false);
        disable_element($('#cmbEmployeeID'), false);
    });

    $('#switchSite').on('click', function () {
        disable_element($('#selcSite'), $(this).is(":checked"));
        loadExistingSchedules();
        $('#switchEmployee').prop('checked', false);
        disable_element($('#cmbEmployeeID'), false);
    });

    $('#switchDepartment').on('click', function () {
        disable_element($('#selcDepartment'), $(this).is(":checked"));
        loadExistingSchedules();
        $('#switchEmployee').prop('checked', false);
        disable_element($('#cmbEmployeeID'), false);
    });

    $('#switchSection').on('click', function () {
        disable_element($('#selcSection'), $(this).is(":checked"));
        loadExistingSchedules();
        $('#switchEmployee').prop('checked', false);
        disable_element($('#cmbEmployeeID'), false);
    });

    $('#switchSubSection').on('click', function () {
        disable_element($('#selcSubsection'), $(this).is(":checked"));
        loadExistingSchedules();
        $('#switchEmployee').prop('checked', false);
        disable_element($('#cmbEmployeeID'), false);
    });

    $('#switchCompany').on('click', function () {
        disable_element($('#selcCompany'), $(this).is(":checked"));
        loadExistingSchedules();
        $('#switchEmployee').prop('checked', false);
        disable_element($('#cmbEmployeeID'), false);
    });

    $('#switchTeam').on('click', function () {
        disable_element($('#selcTeam'), $(this).is(":checked"));
        loadExistingSchedules();
        $('#switchEmployee').prop('checked', false);
        disable_element($('#cmbEmployeeID'), false);
    });

    $('#switchEmployee').on('click', function () {
        disable_element($('#cmbEmployeeID'), $(this).is(":checked"));
        loadExistingSchedules();
        $('#switchCategory').prop('checked', false);
        disable_element($('#selcCategory'), false);
        $('#switchSite').prop('checked', false);
        disable_element($('#selcSite'), false);
        $('#switchDepartment').prop('checked', false);
        disable_element($('#selcDepartment'), false);
        $('#switchSection').prop('checked', false);
        disable_element($('#selcSection'), false);
        $('#switchSubSection').prop('checked', false);
        disable_element($('#selcSubsection'), false);
        $('#switchCompany').prop('checked', false);
        disable_element($('#selcCompany'), false);
        $('#switchTeam').prop('checked', false);
        disable_element($('#selcTeam'), false);
        $('#switchCompany').prop('checked', false);
        disable_element($('#selcCompany'), false);
    });








    $('#btnApply').on('click', function () {

        var setting_array = {
            'category': $('#selcCategory').val(),
            'site': $('#selcSite').val(),
            'department': $('#selcDepartment').val(),
            'section': $('#selcSection').val(),
            'sub_section': $('#selcSubsection').val(),
            'company': $('#selcCompany').val(),
            'team': $('#selcTeam').val(),
            'employee': $('#cmbEmployeeID').val(),
        };

        select_option.category = $('#switchCategory').is(":checked");
        select_option.site = $('#switchSite').is(":checked");
        select_option.department = $('#switchDepartment').is(":checked");
        select_option.section = $('#switchSection').is(":checked");
        select_option.sub_section = $('#switchSubSection').is(":checked");
        select_option.company = $('#switchCompany').is(":checked");
        select_option.team = $('#switchTeam').is(":checked");
        select_option.employee = $('#switchEmployee').is(":checked");


        var shift_id = $('#cmbShift').val();
        var holiday = $('#cmbHoliday').val();
        var site = $('#selcSite_setting').val();
        var department_id = $('#selcDepartment').val();
        var start_date = new Date($('#txtFromDate').val()).toISOString().slice(0, 10);
        var end_date = new Date($('#txtToDate').val()).toISOString().slice(0, 10);
        var remark = $('#txtRemark').val();
        var _token = $("input[name='_token']").val();

        var data = new FormData();
        data.append("shift_id", shift_id);
        data.append("holiday", holiday);
        data.append("site", site);
        data.append("setting_id", department_id);
        data.append("start_date", start_date);
        data.append("end_date", end_date);
        data.append("remark", remark);
        data.append('setting_array', JSON.stringify(setting_array));
        data.append('select_option', JSON.stringify(select_option));
        data.append("_token", _token);

        $.ajax({
            type: "POST",
            url: '/hr/attendanceEmployeeSchedule/applySchedule',
            data: data,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                progress(true);
            },
            success: function (response) {
                console.log(response);

                if (response.data.success) {

                    showSuccessMessage("Schedule has been applied successfully...");
                    loadExistingSchedules();
                    //loadScheduleFromSettings($('#cmbShift').val(), $('#selcSite_setting').val(), JSON.stringify(setting_array), JSON.stringify(select_option), $('#txtFromDate').val(), $('#txtToDate').val());
                } else {
                    showErrorMessage();
                }


            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                progress(false);
            }

        });
    });




    $('#btnRemove').on('click', function () {

        var setting_array = {
            'category': $('#selcCategory').val(),
            'site': $('#selcSite').val(),
            'department': $('#selcDepartment').val(),
            'section': $('#selcSection').val(),
            'sub_section': $('#selcSubsection').val(),
            'company': $('#selcCompany').val(),
            'team': $('#selcTeam').val(),
            'employee': $('#cmbEmployeeID').val(),
        };

        select_option.category = $('#switchCategory').is(":checked");
        select_option.site = $('#switchSite').is(":checked");
        select_option.department = $('#switchDepartment').is(":checked");
        select_option.section = $('#switchSection').is(":checked");
        select_option.sub_section = $('#switchSubSection').is(":checked");
        select_option.company = $('#switchCompany').is(":checked");
        select_option.team = $('#switchTeam').is(":checked");
        select_option.employee = $('#switchEmployee').is(":checked");


        var shift_id = $('#cmbShift').val();
        var _token = $("input[name='_token']").val();
        var data = new FormData();
        data.append("shift_id", shift_id);
        data.append('start_date', $('#txtFromDate').val());
        data.append('end_date', $('#txtToDate').val());
        data.append('setting_array', JSON.stringify(setting_array));
        data.append('select_option', JSON.stringify(select_option));
        data.append("_token", _token);

        $.ajax({
            type: "POST",
            url: '/hr/attendanceEmployeeSchedule/removeAllSchedule',
            data: data,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                progress(true);
            },
            beforeSend: function () {
                progress(true);
            },
            success: function (response) {
                console.log(response);
                if (response.data.success) {
                    progress(false);
                    showSuccessMessage("Shift has been deleted successfully...");
                    loadScheduleFromSettings($('#cmbShift').val(), $('#selcSite_setting').val(), JSON.stringify(setting_array), JSON.stringify(select_option), $('#txtFromDate').val(), $('#txtToDate').val());
                } else {
                    showErrorMessage();
                }

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();
                progress(false);
            },
            complete: function () {
                progress(false);

            }
        });
    });


});






function loadAllSettings() {
    $.ajax({
        type: "GET",
        url: "/hr/attendanceEmployeeScheduleSetting/allSettings",
        processData: false,
        contentType: false,
        async: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var settings = response.data.result;
                appendShift(settings.shifts);
                appendCategory(settings.categories);
                appendSite(settings.sites);
                appendDepartment(settings.departments);
                appendSection(settings.sections);
                appendCompany(settings.companies);
                appendTeam(settings.teams);
                //appendEmployee(settings.employees);
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            progress(false);
        }

    });
}




function subsection(section_id) {
    $.ajax({
        type: "GET",
        url: "/hr/attendanceEmployeeScheduleSetting/subsection/" + section_id,
        processData: false,
        contentType: false,
        async: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var subsection = response.data.result;
                appendSubsection(subsection);
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            progress(false);
        }

    });
}





function appendShift(result) {

    $('#cmbShift').empty();
    $('#cmbShift').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#cmbShift').append('<option value="' + result[i].shift_id + '">' + result[i].shift_name + '</option>');
    }
}



function appendCategory(result) {

    $('#selcCategory').empty();
    $('#selcCategory').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#selcCategory').append('<option value="' + result[i].category_id + '">' + result[i].category + '</option>');
    }
}



function appendSite(result) {

    $('#selcSite').empty();
    $('#selcSite_setting').empty();
    $('#selcSite').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#selcSite').append('<option value="' + result[i].site_id + '">' + result[i].site + '</option>');
        $('#selcSite_setting').append('<option value="' + result[i].site_id + '">' + result[i].site + '</option>');
    }
}



function appendDepartment(result) {

    $('#selcDepartment').empty();
    $('#selcDepartment').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#selcDepartment').append('<option value="' + result[i].department_id + '">' + result[i].department + '</option>');
    }
}




function appendSection(result) {

    $('#selcSection').empty();
    $('#selcSection').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#selcSection').append('<option value="' + result[i].section_id + '">' + result[i].section + '</option>');
    }
}



function appendSubsection(result) {

    $('#selcSubsection').empty();
    $('#selcSubsection').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#selcSubsection').append('<option value="' + result[i].subsection_id + '">' + result[i].subsection + '</option>');
    }
}



function appendCompany(result) {

    $('#selcCompany').empty();
    $('#selcCompany').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#selcCompany').append('<option value="' + result[i].company_id + '">' + result[i].company + '</option>');
    }
}



function appendTeam(result) {

    $('#selcTeam').empty();
    $('#selcTeam').append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#selcTeam').append('<option value="' + result[i].team_id + '">' + result[i].team_name + '</option>');
    }
}


function appendEmployee(result) {

    $('#cmbEmployeeID').empty();
    $('#cmbEmployeeID').append('<option selected="true" disabled="disabled">Select Here</option>');
    for (var i = 0; i < result.length; i++) {
        $('#cmbEmployeeID').append('<option value="' + result[i].id + '">' + result[i].value + '</option>');
    }
}




function appendTableRow(result) {

    var data = [];
    for (i = 0; i < result.length; i++) {
        var id = result[i]['schedule_id'];
        var employee_id = result[i]['employee_id'];
        var name = result[i]['name_withinitial'];
        var shift = result[i]['shift_name'];
        var date = result[i]['schedule_date_from'];
        var intime = result[i]['in_time'];
        var outtime = result[i]['out_time'];

        var disabled = "";
        if (status == 1) {
            disabled = "disabled";
        }
        data.push({
            "employee_id": employee_id,
            "name": name,
            "shift": shift,
            "date": date,
            "intime": intime,
            "outtime": outtime,
            "remove": '<button id="' + id + '" class="btn btn-danger" onclick="removeSchedule(' + id + ')">Remove</button>',
        });
    }


    var table = $('#tblEmployeeSchedule').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.remove').visible(false);

    if (remove_permission == 1) {
        table.columns('.remove').visible(true);
    }
}




function intime_outtime(shift_id) {
    $.ajax({
        type: "GET",
        url: "/hr/attendanceEmployeeSchedule/shiftIntimeOutTime/" + shift_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var shift = response.data.result;
                $('#txtIntime').val(shift.intime);
                $('#txtOuttime').val(shift.outtime);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}






function removeSchedule(id) {

    $.ajax({
        type: 'DELETE',
        url: '/hr/attendanceEmployeeSchedule/removeSchedule/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                progress(false);
                showSuccessMessage("Shift has been deleted successfully...");
                loadExistingSchedules();
                /*if (setting_name == 'selcCategory') {
                    loadScheduleCategory();
                } else if (setting_name == 'selcTeam') {
                    loadScheduleTeam();
                } else if (setting_name == 'selcSite') {
                    loadScheduleSite();
                } else if (setting_name == 'selcDepartment') {
                    loadScheduleDepartment();
                } else if (setting_name == 'selcSection') {
                    loadScheduleSection();
                } else if (setting_name == 'selcCompany') {
                    loadScheduleCompany();
                } else if (setting_name == 'selcSubsection') {
                    loadScheduleSubsection();
                } else if (setting_name == 'Employee') {
                    loadScheduleEmployee();
                }*/

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }
    });
}




function loadExistingSchedules() {
    var setting_array = {
        'category': $('#selcCategory').val(),
        'site': $('#selcSite').val(),
        'department': $('#selcDepartment').val(),
        'section': $('#selcSection').val(),
        'sub_section': $('#selcSubsection').val(),
        'company': $('#selcCompany').val(),
        'team': $('#selcTeam').val(),
        'employee': $('#cmbEmployeeID').val(),
    };

    var select_option = {
        'category': false,
        'site': false,
        'department': false,
        'section': false,
        'sub_section': false,
        'company': false,
        'team': false,
        'employee': false,
    };

    select_option.category = $('#switchCategory').is(":checked");
    select_option.site = $('#switchSite').is(":checked");
    select_option.department = $('#switchDepartment').is(":checked");
    select_option.section = $('#switchSection').is(":checked");
    select_option.sub_section = $('#switchSubSection').is(":checked");
    select_option.company = $('#switchCompany').is(":checked");
    select_option.team = $('#switchTeam').is(":checked");
    select_option.employee = $('#switchEmployee').is(":checked");
    loadScheduleFromSettings($('#cmbShift').val(), $('#selcSite_setting').val(), JSON.stringify(setting_array), JSON.stringify(select_option), $('#txtFromDate').val(), $('#txtToDate').val());
}





































///////////////////////////////////////////////////////////////////////////////////////////





function disable_element(element, bool) {
    if (bool) {
        element.removeAttr('disabled');
    } else {
        element.attr('disabled', 'disabled');
    }
}



function loadEmployeeFromSite(site_id) {
    $.ajax({
        type: "GET",
        url: "/hr/attendanceEmployeeSchedule/loadEmployeeFromSite/" + site_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var employees = response.data.result;
                appendEmployee(employees);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}





function loadScheduleFromSettings(shift_id, site_id, setting_array, select_option, start_date, end_date) {
    $.ajax({
        type: "GET",
        url: "/hr/attendanceEmployeeScheduleSetting/scheduleCategory/" + shift_id + "/" + site_id + "/" + setting_array + "/" + select_option + "/" + start_date + "/" + end_date,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            appendTableRow(response.data.result);
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
