
var arr_obj = [];


$(document).ready(function () {
    $('#tblSalaryData').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "employee_id" },
            { "data": "value", "className": "text-right", },
            { "data": "employee" },
            { "data": "narration" },
            { "data": "salary" },
        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 50, targets: 2 },
            { width: 50, targets: 3 },
            { width: 50, targets: 4 },
        ],
    });

    $('#cmbType').on('change', function () {
        loadNaration($(this).val());
    });


    $('#cmbType').trigger('change');

    $('#btnSave').on('click', function () {
        save();

    });

    $('#fileUpload').on('change', function () {
        UploadProcess();
    });

    $('#cmbNaration').on('change', function () {
        validate();
    });

    $('#btnReset').on('click',function(){
        $('#fileUpload').val('');
    });

});





function loadNaration(type) {


    $.ajax({
        type: "GET",
        url: '/hr/importSalaryData/allNaration/' + type,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                appendOption('cmbNaration', response.data.result);
            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}



function appendOption(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].item_id + '">' + result[i].narration + '</option>');
    }
}




function UploadProcess() {
    //Reference the FileUpload element.
    var fileUpload = document.getElementById("fileUpload");

    //Validate whether File is valid Excel file.
    var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.xls|.xlsx)$/;
    if (regex.test(fileUpload.value.toLowerCase())) {
        if (typeof (FileReader) != "undefined") {
            var reader = new FileReader();

            //For Browsers other than IE.
            if (reader.readAsBinaryString) {
                reader.onload = function (e) {
                    GetTableFromExcel(e.target.result);
                };
                reader.readAsBinaryString(fileUpload.files[0]);
            } else {
                //For IE Browser.
                reader.onload = function (e) {
                    var data = "";
                    var bytes = new Uint8Array(e.target.result);
                    for (var i = 0; i < bytes.byteLength; i++) {
                        data += String.fromCharCode(bytes[i]);
                    }
                    GetTableFromExcel(data);
                };
                reader.readAsArrayBuffer(fileUpload.files[0]);
            }
        } else {
            alert("This browser does not support HTML5.");
        }
    } else {
        showWarningMessage("Invalied file name..!");
    }
};
function GetTableFromExcel(data) {
    //Read the Excel File data in binary
    var workbook = XLSX.read(data, {
        type: 'binary'
    });

    //get the name of First Sheet.
    var Sheet = workbook.SheetNames[0];

    //Read all rows from First Sheet into an JSON array.
    var excelRows = XLSX.utils.sheet_to_row_object_array(workbook.Sheets[Sheet]);



    //Add the data rows from Excel file.
    for (var i = 0; i < excelRows.length; i++) {



        var key1 = Object. keys(excelRows[i])[0];
        var key2 = Object. keys(excelRows[i])[1];
        if (excelRows[i][key1]== undefined || excelRows[i][key2] == undefined) {
            showWarningMessage('Invalied file format');
            break;
        }
        arr_obj[i] = [excelRows[i][key1], excelRows[i][key2]];


    }


    console.log(arr_obj);
    validate();
};




function save() {


    var form = new FormData();
    form.append("type", $('#cmbType').val());
    form.append("narration_id", $('#cmbNaration').val());
    form.append("salary_month",$('#cmbMonth').val());
    form.append("salary_year",$('#cmbYear').val());
    form.append("data", JSON.stringify(arr_obj));
    $.ajax({
        type: "POST",
        url: '/hr/importSalaryData/save',
        data: form,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Salary Data Saved...!');
            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}






function validate() {

    var form = new FormData();
    form.append("type", $('#cmbType').val());
    form.append("narration_id", $('#cmbNaration').val());
    form.append("data", JSON.stringify(arr_obj));

    $.ajax({
        type: "POST",
        url: '/hr/importSalaryData/validate',
        data: form,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var data = [];
                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['id'];
                    var value = parseFloat(response.data.result[i]['value']).toFixed(2);
                    var employee = response.data.result[i]['employee'];
                    var narration = response.data.result[i]['narration'];
                    var salary = response.data.result[i]['salary'];
                    data.push({
                        "employee_id": id,
                        "value": value,
                        "employee": employee,
                        "narration": narration,
                        "salary": salary,
                    });
                }

                var table = $('#tblSalaryData').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}




/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}