
var setting_array = {
    "category": null,
    "site": null,
    "department": null,
    "section": null,
    "subsection": null,
    "company": null,
    "team": null,
    "employee": null,
    "year": null,
    "month": null,
};

var MONTH_NAME = {
    1: 'ckjdß', //january
    2: 'fmnrjdß',//February
    3: 'ud¾;=',//March
    4: 'wfma%,a',//April
    5: 'uehs',//May
    6: 'cqks',//June
    7: 'cQ,s',//July
    8: 'wf.daia;=',//August
    9: 'ima;eïn¾',//September
    10: 'Tlaf;daïn¾',//October
    11: 'fkdjeïn¾',//November
    12: 'foieïn¾',//December
}

var REPORT_ID = 0;

$(document).ready(function () {
    $('#dateYearMonth').hide();
    allSettings();
    appendSalaryYear();
    $('#selcCategory').prop("disabled", true);
    $('#selcSite').prop("disabled", true);
    $('#selcDepartment').prop("disabled", true);
    $('#selcSection').prop("disabled", true);
    $('#selcSubsection').prop("disabled", true);
    $('#selcCompany').prop("disabled", true);
    $('#selcTeam').prop("disabled", true);
    $('#employee-autocomplete').prop("disabled", true);

    $('input[name="startDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    $('input[name="startDate"]').on('apply.daterangepicker', function (ev, picker) {
        setDateRangeToDatePicker('endDate', picker.startDate.format('YYYY MM D'));

    });

    $('input[name="endDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    setDateRangeToDatePicker('endDate', $('input[name="startDate"]').val());

    $('#checkCategorySearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcCategory').prop("disabled", false);
            setting_array.category = $('#selcCategory').val();
        } else {
            $('#selcCategory').prop("disabled", true);
            setting_array.category = null;
        }
        //switch_settings('checkCategorySearch');
        console.log(setting_array);
    });



    $('#checkSiteSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcSite').prop("disabled", false);
            setting_array.site = $('#selcSite').val();
        } else {
            $('#selcSite').prop("disabled", true);
            setting_array.site = null;
        }
        //switch_settings('checkSiteSearch');
    });


    $('#checkDepartmentSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcDepartment').prop("disabled", false);
            setting_array.department = $('#selcDepartment').val();
        } else {
            $('#selcDepartment').prop("disabled", true);
            setting_array.department = null;
        }
        //switch_settings('checkDepartmentSearch');
    });


    $('#checkSectionSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcSection').prop("disabled", false);
            var value = $('#selcSection').val();
            setting_array.section = $('#selcSection').val();
            allSubsection(value);
        } else {
            $('#selcSection').prop("disabled", true);
            setting_array.section = null;
            setting_array.subsection = null;
            $('#selcSubsection').empty();
            $('#checkSubsectionSearch').prop('checked', false);
        }
        //switch_settings('checkSectionSearch');
    });


    $('#checkSubsectionSearch').change(function () {
        var sectionbool = $('#checkSectionSearch').is(":checked");
        if (!sectionbool) {
            $('#checkSubsectionSearch').prop('checked', false);
            showWarningMessage('Please select section');
            return;
        }
        var subsectionbool = $(this).is(":checked");
        if (subsectionbool) {
            $('#selcSubsection').prop("disabled", false);
            setting_array.subsection = $('#selcSubsection').val();
        } else {
            $('#selcSubsection').prop("disabled", true);
            setting_array.subsection = null;
        }
        //switch_settings('checkSubsectionSearch');
    });


    $('#checkCompanySearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcCompany').prop("disabled", false);
            setting_array.company = $('#selcCompany').val();
        } else {
            $('#selcCompany').prop("disabled", true);
            setting_array.company = null;
        }
        //switch_settings('checkCompanySearch');
    });


    $('#checkTeamSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcTeam').prop("disabled", false);
            setting_array.team = $('#selcTeam').val();
        } else {
            $('#selcTeam').prop("disabled", true);
            setting_array.team = null;
        }
        //switch_settings('checkTeamSearch');

    });


    $('#checkEmployeeSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#employee-autocomplete').prop("disabled", false);
            setting_array.employee = $('#employee-autocomplete').optionID();
        } else {
            $('#employee-autocomplete').prop("disabled", true);
            setting_array.employee = null;
        }
        //switch_settings('checkEmployeeSearch');
    });

    $('#selcCategory').change(function () {
        setting_array.category = $('#selcCategory').val();
    });

    $('#selcSite').change(function () {
        setting_array.site = $('#selcSite').val();
    });

    $('#selcDepartment').change(function () {
        setting_array.department = $('#selcDepartment').val();
    });

    $('#selcSection').change(function () {
        var value = $('#selcSection').val();
        setting_array.section = value;
        allSubsection(value);
    });

    $('#selcSubsection').change(function () {
        setting_array.subsection = $('#selcSubsection').val();
    });

    $('#selcCompany').change(function () {
        setting_array.company = $('#selcCompany').val();
    });

    $('#selcTeam').change(function () {
        setting_array.team = $('#selcTeam').val();
    });

    $('#employee-autocomplete').change(function () {
        setting_array.employee = $('#employee-autocomplete').optionID();
    });

    $('#cmbReport').change(function () {
        REPORT_ID = $(this).val();
        $('#btnExport').show();
        if (REPORT_ID == 1) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 2) {
            showDate('COUPLE_DATE');
        } else if (REPORT_ID == 3) {
            showDate('COUPLE_DATE');
        } else if (REPORT_ID == 4) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 5) {
            showDate('COUPLE_DATE');
        } else if (REPORT_ID == 6) {
            showDate('SINGLE_DATE');
        } else if (REPORT_ID == 7) {
            showDate('YEAR_MONTH');
        } else if (REPORT_ID == 8) {
            showDate('YEAR_MONTH');
        } else if (REPORT_ID == 9) {
            showDate('YEAR_MONTH');
        } else if (REPORT_ID == 10) {
            showDate('YEAR_MONTH');
        }
    });

});





function allSettings() {

    $.ajax({
        type: "GET",
        url: "/hr/employeeReport/allSettings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var settings = response.data.result.settings;
                appendOption("selcCategory", settings.category);
                appendOption("selcSite", settings.site);
                appendOption("selcDepartment", settings.department);
                appendOption("selcSection", settings.section);
                appendOption("selcCompany", settings.company);
                appendOption("selcTeam", settings.team);
                $('#employee-autocomplete').setData(settings.employee);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}





function appendOption(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].id + '">' + result[i].value + '</option>');
    }
}







function allSubsection(section_id) {


    $.ajax({
        type: "GET",
        url: "/hr/employeeReport/subSection/" + section_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                appendOption("selcSubsection", response.data.result);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function settings() {

    return "category=" + setting_array.category + "&"
        + "site=" + setting_array.site + "&"
        + "department=" + setting_array.department + "&"
        + "section=" + setting_array.section + "&"
        + "subsection=" + setting_array.subsection + "&"
        + "company=" + setting_array.company + "&"
        + "employee=" + setting_array.employee;
}


function createReport(flag) {

    if (setting_array.category == null && setting_array.site == null && setting_array.department == null && setting_array.section == null && setting_array.subsection == null && setting_array.company == null && setting_array.team == null && setting_array.employee == null) {
        showWarningMessage("Please select setting");
        return;
    }

    var employee_id = $('#employee-autocomplete').optionID();
    if (setting_array.employee != null && employee_id == "") {
        showWarningMessage("Please select employee");
        return;
    }

    var company = $('#selcCompany').val();
    if (setting_array.company == null || company == "disabled" || !$('#checkCompanySearch').is(':checked')) {
        showWarningMessage("Please select company");
        return;
    }


    if (REPORT_ID == 0) {
        showWarningMessage("Please select Report title");
        return;
    }


    var year = $('#cmbSalaryYear').val();
    var month = $('#cmbSalaryMonth').val();

    setting_array.year = year;
    setting_array.month = month;

    if (REPORT_ID == 1) {
        $.ajax({
            type: "GET",
            url: "/hr/payrollReport/dailyOTReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                if (flag == 'PRINT') {
                    document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                } else if (flag == 'EXPORT') {
                    document.getElementById('btnExport').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                }

            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                dailyOTReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('#btnExport').text('Export');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 2) {
        $.ajax({
            type: "GET",
            url: "/hr/payrollReport/highOTReopt/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                if (flag == 'PRINT') {
                    document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                } else if (flag == 'EXPORT') {
                    document.getElementById('btnExport').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                }
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                highOTReopt(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('#btnExport').text('Export');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 3) {
        $.ajax({
            type: "GET",
            url: "/hr/payrollReport/monthlyOTSummaryReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                if (flag == 'PRINT') {
                    document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                } else if (flag == 'EXPORT') {
                    document.getElementById('btnExport').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                }
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                monthlyOTSummaryReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('#btnExport').text('Export');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 4) {
        $.ajax({
            type: "GET",
            url: "/hr/payrollReport/epf_etfReports/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                if (flag == 'PRINT') {
                    document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                } else if (flag == 'EXPORT') {
                    document.getElementById('btnExport').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                }
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                epf_etfReports(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('#btnExport').text('Export');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 5) {
        $.ajax({
            type: "GET",
            url: "/hr/payrollReport/nightAllowanceReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                if (flag == 'PRINT') {
                    document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                } else if (flag == 'EXPORT') {
                    document.getElementById('btnExport').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                }
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                nightAllowanceReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('#btnExport').text('Export');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 6) {
        $.ajax({
            type: "GET",
            url: "/hr/payrollReport/attendanceAllowanceReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                if (flag == 'PRINT') {
                    document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                } else if (flag == 'EXPORT') {
                    document.getElementById('btnExport').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                }
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                attendanceAllowanceReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('#btnExport').text('Export');
                $('.btn').prop("disabled", false);
            }

        });
    } else if (REPORT_ID == 7) {

        $.ajax({
            type: "GET",
            url: "/hr/payrollReport/payAdviceReport/" + JSON.stringify(setting_array),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                if (flag == 'PRINT') {
                    document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                } else if (flag == 'EXPORT') {
                    document.getElementById('btnExport').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                }
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                //console.log(result);
                showPayAdviceReport(result, 'portrait', flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('#btnExport').text('Export');
                $('.btn').prop("disabled", false);
            }

        });

    } else if (REPORT_ID == 8) {

        $.ajax({
            type: "GET",
            url: "/hr/payrollReport/salaryReport/" + JSON.stringify(setting_array),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                if (flag == 'PRINT') {
                    document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                } else if (flag == 'EXPORT') {
                    document.getElementById('btnExport').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                }
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                var all_data = result.result;
                var earning_narration = result.earning_narration;
                var deduction_narration = result.deduction_narration;
                showSalaryReport(all_data, earning_narration, deduction_narration, flag);
            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('#btnExport').text('Export');
                $('.btn').prop("disabled", false);
            }

        });


    } else if (REPORT_ID == 9) {

        $.ajax({
            type: "GET",
            url: "/hr/payrollReport/employeeDailyOTReport/" + JSON.stringify(setting_array) + "/" + $('#cmbSalaryYear').val() + "/" + $('#cmbSalaryMonth').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                if (flag == 'PRINT') {
                    document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                } else if (flag == 'EXPORT') {
                    document.getElementById('btnExport').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                }
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                showEmployeeDailyOTReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('#btnExport').text('Export');
                $('.btn').prop("disabled", false);
            }

        });


    } else if (REPORT_ID == 10) {

        $.ajax({
            type: "GET",
            url: "/hr/payrollReport/salaryReport/" + JSON.stringify(setting_array),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                if (flag == 'PRINT') {
                    document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                } else if (flag == 'EXPORT') {
                    document.getElementById('btnExport').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                }
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                var all_data = result.result;
                var earning_narration = result.earning_narration;
                var deduction_narration = result.deduction_narration;
                showSalaryReport2(all_data, earning_narration, deduction_narration, flag);
            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('#btnExport').text('Export');
                $('.btn').prop("disabled", false);
            }

        });


    } /*else if (REPORT_ID == 10) {

        $.ajax({
            type: "GET",
            url: "/hr/payrollReport/salary_details_report/" + JSON.stringify(setting_array) + "/" + $('#cmbSalaryYear').val() + "/" + $('#cmbSalaryMonth').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                if (flag == 'PRINT') {
                    document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                } else if (flag == 'EXPORT') {
                    document.getElementById('btnExport').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                }
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                showSalaryDetailsReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('#btnExport').text('Export');
                $('.btn').prop("disabled", false);
            }

        });


    }*/



}











function allEmployeeDetailsReport(result, flag) {

    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            /*logo: {
                path: '/images/logo.png',
                width: 200,
                height: 30,
                alignment: 'left',
            },*/
            content: [

                {
                    table: {
                        widths: ['*', '*', '*'],
                        headerRows: 1,
                        body: [
                            [{ text: '', border: [false, false, false, false] }, { text: 'Riococo Lanka Pvt Ltd', fontSize: 5, bold: false, alignment: 'center', border: [false, false, false, false] }, { text: '', fontSize: 5, bold: true, alignment: 'right', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 6, border: [false, false, false, false] }, { text: "\n", fontSize: 6, bold: true, alignment: 'center', border: [false, false, false, false] }, { text: '\n', fontSize: 4, bold: true, alignment: 'right', border: [false, false, false, false] }],

                            [{ text: 'June 2021', fontSize: 4, border: [false, false, false, false] }, { text: "EMPLOYEE'S DETAIL REPORT", fontSize: 6, bold: false, alignment: 'center', border: [false, false, false, false] }, { text: '', fontSize: 4, bold: true, alignment: 'right', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                }
            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, 30, 80, 80, 30, 40, 30, 30, 50, '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*'],
                headerRows: 1,
                body: allEmployeeDetailsReportBody(result),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A3');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }


}




function allEmployeeDetailsReportBody(result) {

    var font_size = 3;
    var body = [];
    body.push([
        { text: 'Employee ID', fontSize: font_size, border: [true, true, true, true] },
        { text: 'EPF No', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Name', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Address', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Date Of Birth', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Gender', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Designation', fontSize: font_size, border: [true, true, true, true] },
        { text: 'NIC', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Date Of Joined', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Civil Status', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Fixed Phone NO', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Attendance ID', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Employee Status', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Category', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Site', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Department', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Team', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Supervisior', fontSize: font_size, border: [true, true, true, true] },
        { text: 'GS Division', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Police Divition', fontSize: font_size, border: [true, true, true, true] },
        { text: 'MOH', fontSize: font_size, border: [true, true, true, true] },

    ]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].epf_no, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].address, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].birthday, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].gender, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].designation, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].nic, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].date_join, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].civilstatus, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].fixed_mobile, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].attendance_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employeestatus, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].category, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].site, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].department, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].team_name, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].supervisor, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].division, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].police, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].moh, fontSize: font_size, border: [false, false, false, true] },

        ]);
    }
    return body;
}











function dailyAbsentReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Daily Absent Report for ' + result.report_date, fontSize: 12, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, '*', 60, '*', '*', '*', 60, 60, 30],
                headerRows: 1,
                body: dailyAbsentReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function dailyAbsentReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Date Of Joined', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Category', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Department', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Team', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Service', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Last Present Date', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Absent', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].date_join, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].category, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].department, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].team_name, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].service, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].last_present_date, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].absent, fontSize: font_size, border: [false, false, false, true], alignment: 'right' },

        ]);
    }
    return body;
}






function dailyPresentReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Daily Present Report for ' + result.report_date, fontSize: 12, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],
                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, '*', '*', '*', 60, 50, 50, 30, 30, 30],
                headerRows: 1,
                body: dailyPresentReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function dailyPresentReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Team', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Shift', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'In Time', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Out Time', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Out Date', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Late', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'OT', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    for (i = 0; i < result.length; i++) {


        var late_arriver = result[i].late_arriver;
        if (!late_arriver) {
            late_arriver = 0;
        }

        var n_ot = result[i].n_ot;
        if (!n_ot) {
            n_ot = 0;
        }

        var d_ot = result[i].d_ot;
        if (!d_ot) {
            d_ot = 0;
        }

        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [false, false, false, true], alignment: "center" },
            { text: result[i].team_name, fontSize: font_size, border: [false, false, false, true], alignment: "center" },
            { text: result[i].shift, fontSize: font_size, border: [false, false, false, true], alignment: "center" },
            { text: result[i].in_time, fontSize: font_size, border: [false, false, false, true], alignment: "center" },
            { text: result[i].out_time, fontSize: font_size, border: [false, false, false, true], alignment: "center" },
            { text: result[i].out_date, fontSize: font_size, border: [false, false, false, true], alignment: "center" },
            { text: parseFloat(late_arriver).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: "right" },
            { text: parseFloat(n_ot).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: "right" },
            { text: parseFloat(d_ot).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: "right" },


        ]);
    }
    return body;
}







function attendanceRegisterReport(result, flag) {

    var dayCount = daysInMonth(1, 2021);


    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Employee Attendance Register for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, 80, 5, 5, 5, 5, 5, 5, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 30, 30, 30, 30],
                headerRows: 1,
                body: attendanceRegisterReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function attendanceRegisterReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([
        { text: 'ID', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Employee Name', fontSize: font_size, border: [true, true, true, true] },
        { text: '1', fontSize: font_size, border: [true, true, true, true] },
        { text: '2', fontSize: font_size, border: [true, true, true, true] },
        { text: '3', fontSize: font_size, border: [true, true, true, true] },
        { text: '4', fontSize: font_size, border: [true, true, true, true] },
        { text: '5', fontSize: font_size, border: [true, true, true, true] },
        { text: '6', fontSize: font_size, border: [true, true, true, true] },
        { text: '7', fontSize: font_size, border: [true, true, true, true] },
        { text: '8', fontSize: font_size, border: [true, true, true, true] },
        { text: '9', fontSize: font_size, border: [true, true, true, true] },
        { text: '10', fontSize: font_size, border: [true, true, true, true], padding: 0 },
        { text: '11', fontSize: font_size, border: [true, true, true, true] },
        { text: '12', fontSize: font_size, border: [true, true, true, true] },
        { text: '13', fontSize: font_size, border: [true, true, true, true] },
        { text: '14', fontSize: font_size, border: [true, true, true, true] },
        { text: '15', fontSize: font_size, border: [true, true, true, true] },

        { text: '16', fontSize: font_size, border: [true, true, true, true] },
        { text: '17', fontSize: font_size, border: [true, true, true, true] },
        { text: '18', fontSize: font_size, border: [true, true, true, true] },
        { text: '19', fontSize: font_size, border: [true, true, true, true] },
        { text: '20', fontSize: font_size, border: [true, true, true, true] },
        { text: '21', fontSize: font_size, border: [true, true, true, true] },
        { text: '22', fontSize: font_size, border: [true, true, true, true] },
        { text: '23', fontSize: font_size, border: [true, true, true, true] },
        { text: '24', fontSize: font_size, border: [true, true, true, true] },
        { text: '25', fontSize: font_size, border: [true, true, true, true] },
        { text: '26', fontSize: font_size, border: [true, true, true, true] },
        { text: '27', fontSize: font_size, border: [true, true, true, true] },
        { text: '28', fontSize: font_size, border: [true, true, true, true] },
        { text: '29', fontSize: font_size, border: [true, true, true, true] },
        { text: '30', fontSize: font_size, border: [true, true, true, true] },
        { text: '31', fontSize: font_size, border: [true, true, true, true] },

        { text: 'Present Days', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Absent Days', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Leave Days', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Total', fontSize: font_size, border: [true, true, true, true] },


    ]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day1, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day2, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day3, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day4, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day5, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day6, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day7, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day8, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day9, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day10, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day11, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day12, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day13, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day14, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day15, fontSize: font_size, border: [true, true, true, true] },

            { text: result[i].day16, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day17, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day18, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day19, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day20, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day21, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day22, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day23, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day24, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day25, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day26, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day27, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day28, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day29, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day30, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day31, fontSize: font_size, border: [true, true, true, true] },

            { text: result[i].present_day, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].absent_day, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].leave_day, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].total_day, fontSize: font_size, border: [true, true, true, true] },


        ]);
    }
    return body;
}






function dailyMarkingSheetReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'DAILY MARKING SHEET for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, 130, 90, '*', '*', '*', '*', '*'],
                headerRows: 1,
                body: dailyMarkingSheetReportBody(result.body),

            },
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function dailyMarkingSheetReportBody(result) {
    var font_size = 6;
    var body = [];

    body.push([
        { text: 'ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Shift', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'InTime', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'OutTime', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Late', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'DOT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    ]);
    for (i = 0; i < result.length; i++) {
        var late_arriver = result[i].late_arriver;
        if (!late_arriver) {
            late_arriver = 0;
        }

        var n_ot = result[i].n_ot;
        if (!n_ot) {
            n_ot = 0;
        }

        var d_ot = result[i].d_ot;
        if (!d_ot) {
            d_ot = 0;
        }

        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].shift, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].in_time, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].out_time, fontSize: font_size, border: [false, false, false, true] },
            { text: late_arriver.toFixed(2), fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
            { text: n_ot.toFixed(2), fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
            { text: d_ot.toFixed(2), fontSize: font_size, alignment: 'right', border: [false, false, false, true] },


        ]);
    }
    return body;
}








function dailyHeadCountReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Daily Head count Report for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [140, 135, '*', '*', '*', '*'],
                headerRows: 1,
                body: dailyHeadCountReportBody(result.body),

            },
        },
        {
            table: {
                widths: [140, 135, '*', '*', '*', '*'],
                headerRows: 1,
                body: [
                    [
                        { text: '', fontSize: 6, bold: true, alignment: 'right', border: [true, false, false, true] },
                        { text: 'Total', fontSize: 6, bold: true, alignment: 'right', border: [false, false, true, true] },
                        { text: result.grand_total_carder, fontSize: 6, bold: true, alignment: 'right', border: [true, false, true, true] },
                        { text: result.grand_present_carder, fontSize: 6, bold: true, alignment: 'right', border: [true, false, true, true] },
                        { text: result.grand_absent_carder, fontSize: 6, bold: true, alignment: 'right', border: [true, false, true, true] },
                        { text: result.grand_presentage.toFixed(2) + '%', fontSize: 6, bold: true, alignment: 'right', border: [true, false, true, true] },
                    ],

                ],

            },
            margin: [0, 0],
        }
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function dailyHeadCountReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([
        { text: 'Department', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Designation', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Total Carder', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Present Carder', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Absent', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: 'Absent Presentage', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    ]);
    for (i = 0; i < result.length; i++) {
        var presentage = result[i].presentage;
        if (!presentage) {
            presentage = 0;
        }

        body.push([
            { text: result[i].department, fontSize: font_size, alignment: 'left', border: [true, true, true, true] },
            { text: result[i].designation, fontSize: font_size, alignment: 'left', border: [true, true, true, true] },
            { text: result[i].total_carder, fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: result[i].present_carder, fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: result[i].absent_carder, fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: presentage.toFixed(2) + '%', fontSize: font_size, alignment: 'right', border: [true, true, true, true] },


        ]);
    }
    return body;
}



function basicSalaryReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Basicsalary report', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

                {
                    table: {
                        widths: [30, 100, 98, 35, 35, 35, 35, 35, 30],
                        headerRows: 1,
                        body: [
                            [
                                { rowSpan: 2, text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { rowSpan: 2, text: 'Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { rowSpan: 2, text: 'Designation', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { colSpan: 3, text: 'Basic', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }, '', '',
                                { colSpan: 2, text: 'Allowance', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }, '',
                                { rowSpan: 2, text: 'Total Day Salary', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }
                            ],
                            [
                                '',
                                '',
                                '',
                                { text: 'Basicsalary', fontSize: 6, rowspan: 2, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'BR1', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'BR2', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'Travalling Allowance', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'Production Incentive', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
                                { text: 'Total Day Salary', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }
                            ],



                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [

        {
            table: {
                widths: [30, 100, 98, 35, 35, 35, 35, 35, 30],
                headerRows: 0,
                body: basicSalaryReportBody(result.body),

            },
            /*layout: {
                hLineStyle: function (i, node) {
                    return { dash: { length: 1, space: 2 } };
                },
                hLineWidth: function (i, node) {
                    return 0.2;
                },



            },*/
            margin: [0, 0],
        },

    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function basicSalaryReportBody(result) {
    var font_size = 6;
    var body = [];
    for (i = 0; i < result.length; i++) {
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].designation, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].salary, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].br1, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].br2, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].travalling_allowance, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].production_incentive, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].total_day_salary, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }

    return body;
}



function resignEmployeeDetailsReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Resign Employee Report', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [40, 30, 110, 140, 40, 110, 110, 110, 40, 40, 40, 40, 40, 40, '*'],
                headerRows: 1,
                body:
                    resignEmployeeDetailsReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A3');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function resignEmployeeDetailsReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'EPF No', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Address', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Mobile No', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Designation', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Department', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Section', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'DOB', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Gender', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'NIC', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Register Date', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Resign Date', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Service', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Basicsalary', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].epf_no, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].address, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].mobile, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].designation, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].department, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].section, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].dob, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].gender, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].nic, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].date_join, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].resign_date, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].service, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].salary, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }

    return body;
}







function attendanceSummryReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Attendance Data - Summary ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [40, 130, 50, 50, 50, 50, '*'],
                headerRows: 1,
                body: attendanceSummryReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function attendanceSummryReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Working Days', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'N.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Poya OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Signature', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].worked_day, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].n_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].d_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].poya_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: '', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }

    return body;
}



function timeCardsReport2(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Employee Time Card', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                        ],

                    },
                    margin: [0, 0],
                },
            ]
        }
    ];

    var Body = timeCardsReportBody2(result.body, result.title);



    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];




    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }



}



function timeCardsReportBody2(body, title) {
    var Body = [];
    for (i = 0; i < body.length; i++) {
        var pageBreak = 'after';
        if (i == (body.length) - 1) {
            pageBreak = '';
        }
        var t_body = [];
        t_body.push([
            { text: 'Date', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Actual In', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Actual Out', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Shift', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Nopay', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Late Arriver', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'N.Overtime', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'D.Overtime', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Earlydeparture', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: 'Remark', fontSize: 8, bold: true, alignment: 'center', border: [true, true, true, true] },
        ]);


        Body.push([{
            stack: [
                { text: 'Employee ID : ' + body[i].employee_id, fontSize: 6 },
                { text: 'Employee Name : ' + body[i].employee_name, fontSize: 6 },
                { text: title, fontSize: 6 },
                {
                    table: {
                        widths: ['auto', 'auto', 'auto', 'auto', 'auto', 'auto', 'auto', 'auto', 'auto', '*'],
                        headerRows: 1,
                        body: t_body,
                    },
                    margin: [0, 0],
                },
                { text: '\n', pageBreak: pageBreak },
            ]
        }]);

        for (i2 = 0; i2 < body[i].result.length; i2++) {

            var late_arriver = body[i].result[i2].late_arriver;
            if (!late_arriver) {
                late_arriver = 0;
            }

            var n_ot = body[i].result[i2].n_ot;
            if (!n_ot) {
                n_ot = 0;
            }

            var d_ot = body[i].result[i2].d_ot;
            if (!d_ot) {
                d_ot = 0;
            }

            var early_departure = body[i].result[i2].early_departure;
            if (!early_departure) {
                early_departure = 0;
            }

            t_body.push([
                { text: body[i].result[i2].Date, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: body[i].result[i2].InTime, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: body[i].result[i2].OutTime, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: body[i].result[i2].shift_name, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: body[i].result[i2].NoPay, fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
                { text: late_arriver.toFixed(2), fontSize: 8, bold: false, alignment: 'right', border: [true, true, true, true] },
                { text: n_ot.toFixed(2), fontSize: 8, bold: false, alignment: 'right', border: [true, true, true, true] },
                { text: d_ot.toFixed(2), fontSize: 8, bold: false, alignment: 'right', border: [true, true, true, true] },
                { text: early_departure.toFixed(2), fontSize: 8, bold: false, alignment: 'right', border: [true, true, true, true] },
                { text: '', fontSize: 8, bold: false, alignment: 'center', border: [true, true, true, true] },
            ]);
        }


    }
    return Body;

}





function dailyOTReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Daily OT Report for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, '*', '*', 20, 70, 70, 20, 20, 30],
                headerRows: 1,
                body: dailyOTReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function dailyOTReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Team', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Shift', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'In Time', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Out Time', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Pay OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);



    for (i = 0; i < result.length; i++) {

        var n_ot = result[i].n_ot;
        if (!n_ot) {
            n_ot = 0;
        }

        var d_ot = result[i].d_ot;
        if (!d_ot) {
            d_ot = 0;
        }

        var ot_amount = result[i].ot_amount;
        if (!ot_amount) {
            ot_amount = 0;
        }

        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].team_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].shift, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].in_time, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].out_time, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: n_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: d_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: ot_amount.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }

    return body;
}



function highOTReopt(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Highest OT Report From ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, '*', 100, 100, 25, 30, 25, 30],
                headerRows: 1,
                body: highOTReoptBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function highOTReoptBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Designation', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Team', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'N.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'N.OT Cost', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT Cost', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);



    for (i = 0; i < result.length; i++) {
        var n_ot = result[i].n_ot;
        if (!n_ot) {
            n_ot = 0;
        }

        var n_ot_cost = result[i].n_ot_cost;
        if (!n_ot_cost) {
            n_ot_cost = 0;
        }

        var d_ot = result[i].d_ot;
        if (!d_ot) {
            d_ot = 0;
        }

        var d_ot_cost = result[i].d_ot_cost;
        if (!d_ot_cost) {
            d_ot_cost = 0;
        }

        var n_ot_cost =
            body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: result[i].designation, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: result[i].team_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
            { text: n_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
            { text: n_ot_cost.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
            { text: d_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
            { text: d_ot_cost.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }

    return body;
}



function monthlyOTSummaryReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Monthly OT Summary From ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, '*', 125, 125, 30, 30, 30, 30, 30, 30, 30, 30],
                headerRows: 1,
                body: monthlyOTSummaryReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function monthlyOTSummaryReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Designation', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Team', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'N.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'N.OT Cost', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'D.OT Cost', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'P.OT', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'P.OT Cost', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total OT Hours', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total OT Cost', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {

        var n_ot = result[i].n_ot;
        if (!n_ot) {
            n_ot = 0;
        }

        var n_ot_cost = result[i].n_ot_cost;
        if (!n_ot_cost) {
            n_ot_cost = 0;
        }

        var d_ot = result[i].d_ot;
        if (!d_ot) {
            d_ot = 0;
        }

        var d_ot_cost = result[i].d_ot_cost;
        if (!d_ot_cost) {
            d_ot_cost = 0;
        }

        var p_ot = result[i].p_ot;
        if (!p_ot) {
            p_ot = 0;
        }

        var p_ot_cost = result[i].p_ot_cost;
        if (!p_ot_cost) {
            p_ot_cost = 0;
        }

        var total_ot_hours = result[i].total_ot_hours;
        if (!total_ot_hours) {
            total_ot_hours = 0;
        }

        var total_ot_amount = result[i].total_ot_amount;
        if (!total_ot_amount) {
            total_ot_amount = 0;
        }

        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].designation, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].team_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: n_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: n_ot_cost.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: d_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: d_ot_cost.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: p_ot.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: p_ot_cost.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: total_ot_hours.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: total_ot_amount.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }

    return body;
}


function dailyInvalidReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Daily Invalied Report for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [40, '*', '*', 'auto', 70, 70],
                headerRows: 1,
                body: dailyInvalidReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function dailyInvalidReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Team', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Shift', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'In Time', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Out Time', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {
        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].team_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].shift, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].in_time, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].out_time, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }

    return body;
}


function epf_etfReports(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],

                            [
                                {
                                    table: {
                                        widths: ['*', 150, 150],
                                        headerRows: 1,
                                        body: [
                                            [{ text: '', fontSize: 10, border: [false, false, false, false] }, { text: 'C Form EPF Act NO. 15 OF 1985', bold: true, fontSize: 10, border: [true, true, false, true] }, { text: '', fontSize: 10, border: [false, true, true, true] }],
                                            [{ text: '', fontSize: 10, border: [false, false, false, false] }, { text: 'E.P.F Registration No', fontSize: 10 }, { text: 'Y16965', fontSize: 10 }],
                                            [{ text: '', fontSize: 10, border: [false, false, false, false] }, { text: 'Contributions for', fontSize: 10 }, { text: result.report_date, fontSize: 10 }],
                                            [{ text: '', fontSize: 10, border: [false, false, false, false] }, { text: 'Total Remittance', fontSize: 10 }, { text: '', fontSize: 10 }],
                                        ]
                                    }, border: [false, false, false, false]
                                }
                            ]

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, 60, '*', 30, 60, 60, 60, 60, 60, 30],
                headerRows: 1,
                body: epf_etfReportsBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function epf_etfReportsBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'NIC', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'EPF No', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total Contribution Rs.', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Employer Contribution Rs.', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Employee Contribution Rs.', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total Earnings Rs.', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'ETF Contribution Rs.', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Days', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    var total_contribution_amount = 0;
    var total_employer_epf = 0;
    var total_employee_epf = 0;
    var grand_total_earnings = 0;
    var total_employee_etf = 0;
    var total_days = 0;

    for (i = 0; i < result.length; i++) {
        total_contribution_amount += result[i].total_contribution;
        total_employer_epf += result[i].employer_contribution;
        total_employee_epf += result[i].employee_contribution;
        grand_total_earnings += (parseFloat(result[i].employee_contribution) / 8) * 100;
        total_employee_etf += result[i].employee_etf;
        total_days += result[i].work_day;

        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].nic, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].epf_no, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].total_contribution.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].employer_contribution.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].employee_contribution.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: ((parseFloat(result[i].employee_contribution) / 8) * 100).toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].employee_etf.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].work_day, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }
    body.push([{ text: '', fontSize: 6, bold: true, alignment: 'center', border: [true, true, false, true] },
    { text: '', fontSize: 6, bold: true, alignment: 'center', border: [false, true, false, true] },
    { text: '', fontSize: 6, bold: true, alignment: 'center', border: [false, true, false, true] },
    { text: '', fontSize: 6, bold: true, alignment: 'center', border: [false, true, false, true] },
    { text: total_contribution_amount.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_employer_epf.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_employee_epf.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: grand_total_earnings.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_employee_etf.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_days, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    return body;
}



function allDeductionsReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'All Deductions from ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, 130, '*', '*', '*', '*', '*', '*'],
                headerRows: 1,
                body: allDeductionsReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function allDeductionsReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Salary Advance', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Loan', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Welfare Shop Deduction', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Welfare Fund', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Other Deduction', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total Deduction', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    var total_advance = 0;
    var total_loan = 0;
    var total_welfare_shop_deduction = 0;
    var total_welfare_fund = 0;
    var total_other_deduction = 0;
    var grand_total_deductions = 0;

    for (i = 0; i < result.length; i++) {
        total_advance += result[i].advance;
        total_loan += result[i].loan;
        total_welfare_shop_deduction += result[i].welfare_shop_deduction;
        total_welfare_fund += result[i].welfare_fund;
        total_other_deduction += result[i].other_deduction;
        grand_total_deductions = result[i].total_deductions

        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].advance.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].loan.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].welfare_shop_deduction.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].welfare_fund.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].other_deduction.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].total_deductions.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }
    body.push([{ text: '', fontSize: 6, bold: true, alignment: 'center', border: [true, true, false, true] },
    { text: '', fontSize: 6, bold: true, alignment: 'center', border: [false, true, true, true] },
    { text: total_advance.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_loan.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_welfare_shop_deduction.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_welfare_fund.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_other_deduction.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: grand_total_deductions.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);

    return body;
}





function leaveReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Leave Report from ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, 130, '*', 40, 40, 40, '*', 30, '*'],
                headerRows: 1,
                body: leaveReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function leaveReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Leave Type', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Starting', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Ending', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Req Date', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Leave Approved By', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Days', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Section', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);



    for (i = 0; i < result.length; i++) {


        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].type, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].starting_date, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].ending_date, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].req_date, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].approved_by, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].days, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: result[i].section, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    }


    return body;
}





function nightAllowanceReport(result, flag) {

    var day_count = 0;
    var amount = 0;

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Night Allowance Report for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [
                                {
                                    table: {
                                        widths: ['*', 150, 150],
                                        headerRows: 1,
                                        body: [
                                            [{ text: '', fontSize: 10, border: [false, false, false, false] }, { text: 'TOTAL WORK DAYS', fontSize: 10 }, { text: day_count, fontSize: 10, alignment: 'right' }],
                                            [{ text: '', fontSize: 10, border: [false, false, false, false] }, { text: 'TOTAL AMOUNT', fontSize: 10 }, { text: amount.toFixed(2), fontSize: 10, alignment: 'right' }],
                                        ]
                                    }, border: [false, false, false, false]
                                }
                            ],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [30, 130, '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', 30, 30],
                headerRows: 1,
                body: nightAllowanceReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function nightAllowanceReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '1', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '2', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '3', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '4', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '5', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '6', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '7', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '8', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '9', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '10', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '11', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '12', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '13', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '14', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '15', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '16', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '17', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '18', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '19', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '20', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '21', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '22', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '23', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '24', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '25', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '26', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '27', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '28', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '29', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '30', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: '31', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total Days', fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: 'Amount', fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }


    ]);



    var dayCount = 0;
    var amount = 0.0;
    for (i = 0; i < result.length; i++) {
        dayCount += parseInt(result[i].Day1);
        dayCount += parseInt(result[i].Day2);
        dayCount += parseInt(result[i].Day3);
        dayCount += parseInt(result[i].Day4);
        dayCount += parseInt(result[i].Day5);
        dayCount += parseInt(result[i].Day6);
        dayCount += parseInt(result[i].Day7);
        dayCount += parseInt(result[i].Day8);
        dayCount += parseInt(result[i].Day9);
        dayCount += parseInt(result[i].Day10);
        dayCount += parseInt(result[i].Day11);
        dayCount += parseInt(result[i].Day12);
        dayCount += parseInt(result[i].Day13);
        dayCount += parseInt(result[i].Day14);
        dayCount += parseInt(result[i].Day15);
        dayCount += parseInt(result[i].Day16);
        dayCount += parseInt(result[i].Day17);
        dayCount += parseInt(result[i].Day18);
        dayCount += parseInt(result[i].Day19);
        dayCount += parseInt(result[i].Day20);
        dayCount += parseInt(result[i].Day21);
        dayCount += parseInt(result[i].Day22);
        dayCount += parseInt(result[i].Day23);
        dayCount += parseInt(result[i].Day24);
        dayCount += parseInt(result[i].Day25);
        dayCount += parseInt(result[i].Day26);
        dayCount += parseInt(result[i].Day27);
        dayCount += parseInt(result[i].Day28);
        dayCount += parseInt(result[i].Day29);
        dayCount += parseInt(result[i].Day30);
        dayCount += parseInt(result[i].Day31);

        amount = (dayCount * 20.0);


        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day1, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day2, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day3, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day4, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day5, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day6, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day7, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day8, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day9, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day10, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day11, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day12, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day13, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day14, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day15, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day16, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day17, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day18, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day19, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day20, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day21, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day22, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day23, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day24, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day25, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day26, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day27, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day28, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day29, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day30, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].Day31, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: dayCount, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: amount, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },

        ]);
        dayCount = 0;
        amount = 0.0;
    }


    return body;
}





function attendanceAllowanceReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Attendance Allowance for ' + result.report_date, fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, true] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, '*', '*', 40, 40],
                headerRows: 1,
                body: attendanceAllowanceReportBody(result.body),

            },
            margin: [0, 0],
        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function attendanceAllowanceReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([{ text: 'Employee ID', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Emaployee Name', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Category', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Present Days', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Amount', fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] }]);




    for (i = 0; i < result.length; i++) {

        var amount = result[i].attendance_allowance;
        if (!amount) {
            amount = 0;
        }

        body.push([{ text: result[i].employee_id, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].employee_name, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].category, fontSize: 6, bold: true, alignment: 'center', border: [true, true, true, true] },
        { text: result[i].worked_days, fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: amount.toFixed(2), fontSize: 6, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    }


    return body;
}




function showPayAdviceReport(result, PageOrientation, flag) {

    var Body = [];



    var Title = [
        {

        }
    ];



    var column1 = [];
    var column2 = [];
    for (i = 0; i < result.length; i++) {

        var employee_data = result[i].employee;
        var salary_data = result[i].current_salary;

        if (salary_data != null) {
            if (column1.length == column2.length) {
                column1.push(payAdviceBody(employee_data, salary_data));
            } else {
                column2.push(payAdviceBody(employee_data, salary_data));
            }


        }

    }

    var path = 'https://erp.rbs.lk/assets/media/image/single_logo.PNG';
    var logo_width = 265;
    if (column2.length != 0) {
        path = 'https://erp.rbs.lk/assets/media/image/couple_logo.png';
        logo_width = 515;
    }

    var Header = [
        {
            logo: {
                path: path,
                width: logo_width,
                height: 20,
                alignment: 'left',
            },
            content: [
            ]
        }
    ]

    for (i = 0; i < column1.length; i++) {
        var pageBreak = 'after';
        if (i == (column1.length) - 1) {
            pageBreak = '';
        }
        Body.push([

            {
                alignment: 'justify',
                columns: [
                    column1[i],
                    {
                        text: '',
                        width: 20,
                    },
                    {
                        text: '|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|\n|',
                        width: 1,
                    },

                    {
                        text: '',
                        width: 20,
                    },
                    column2[i],



                ]
            },


            { text: '', pageBreak: pageBreak },



        ]);
    }

    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];




    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation(PageOrientation);
    page.setPageMargin([5, 5, 5, 5]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function payAdviceBody(employee_data, salary_data) {

    var real_work_day = parseFloat(salary_data.real_work_day);
    if (isNaN(real_work_day)) {
        real_work_day = 0;
    }

    var additional_worked_days = parseFloat(salary_data.additional_worked_days);
    if (isNaN(additional_worked_days)) {
        additional_worked_days = 0;
    }



    var earn_trans_01 = "";
    var earn_01 = "";
    if (salary_data.earn_trans_id_01 != 0 && parseFloat(salary_data.earn_trans_id_01[2]) != 0) {
        earn_trans_01 = salary_data.earn_trans_id_01[3];
        earn_01 = parseFloat(salary_data.earn_trans_id_01[2]).toFixed(2);
    }

    var earn_trans_02 = "";
    var earn_02 = "";
    if (salary_data.earn_trans_id_02 != 0 && parseFloat(salary_data.earn_trans_id_02[2]) != 0) {
        earn_trans_02 = salary_data.earn_trans_id_02[3];
        earn_02 = parseFloat(salary_data.earn_trans_id_02[2]).toFixed(2);
    }

    var earn_trans_03 = "";
    var earn_03 = "";
    if (salary_data.earn_trans_id_03 != 0 && parseFloat(salary_data.earn_trans_id_03[2]) != 0) {
        earn_trans_03 = salary_data.earn_trans_id_03[3];
        earn_03 = parseFloat(salary_data.earn_trans_id_03[2]).toFixed(2);
    }

    var earn_trans_04 = "";
    var earn_04 = "";
    if (salary_data.earn_trans_id_04 != 0 && parseFloat(salary_data.earn_trans_id_04[2]) != 0) {
        earn_trans_04 = salary_data.earn_trans_id_04[3];
        earn_04 = parseFloat(salary_data.earn_trans_id_04[2]).toFixed(2);
    }

    var earn_trans_05 = "";
    var earn_05 = "";
    if (salary_data.earn_trans_id_05 != 0 && parseFloat(salary_data.earn_trans_id_05[2]) != 0) {
        earn_trans_05 = salary_data.earn_trans_id_05[3];
        earn_05 = parseFloat(salary_data.earn_trans_id_05[2]).toFixed(2);
    }

    var earn_trans_06 = "";
    var earn_06 = "";
    if (salary_data.earn_trans_id_06 != 0 && parseFloat(salary_data.earn_trans_id_06[2]) != 0) {
        earn_trans_06 = salary_data.earn_trans_id_06[3];
        earn_06 = parseFloat(salary_data.earn_trans_id_06[2]).toFixed(2);
    }

    var earn_trans_07 = "";
    var earn_07 = "";
    if (salary_data.earn_trans_id_07 != 0 && parseFloat(salary_data.earn_trans_id_07[2]) != 0) {
        earn_trans_07 = salary_data.earn_trans_id_07[3];
        earn_07 = parseFloat(salary_data.earn_trans_id_07[2]).toFixed(2);
    }

    var earn_trans_08 = "";
    var earn_08 = "";
    if (salary_data.earn_trans_id_08 != 0 && parseFloat(salary_data.earn_trans_id_08[2]) != 0) {
        earn_trans_08 = salary_data.earn_trans_id_08[3];
        earn_08 = parseFloat(salary_data.earn_trans_id_08[2]).toFixed(2);
    }

    var earn_trans_09 = "";
    var earn_09 = "";
    if (salary_data.earn_trans_id_09 != 0 && parseFloat(salary_data.earn_trans_id_09[2]) != 0) {
        earn_trans_09 = salary_data.earn_trans_id_09[3];
        earn_09 = parseFloat(salary_data.earn_trans_id_09[2]).toFixed(2);
    }

    var earn_trans_10 = "";
    var earn_10 = "";
    if (salary_data.earn_trans_id_10 != 0 && parseFloat(salary_data.earn_trans_id_10[2]) != 0) {
        earn_trans_10 = salary_data.earn_trans_id_10[3];
        earn_10 = parseFloat(salary_data.earn_trans_id_10[2]).toFixed(2);
    }


    //deduction
    var deduct_trans_01 = "";
    var deduct_01 = "";
    if (salary_data.deduct_trans_id_01 != 0 && parseFloat(salary_data.deduct_trans_id_01[2]) != 0) {
        deduct_trans_01 = salary_data.deduct_trans_id_01[3];
        deduct_01 = parseFloat(salary_data.deduct_trans_id_01[2]).toFixed(2);
    }

    var deduct_trans_02 = "";
    var deduct_02 = "";
    if (salary_data.deduct_trans_id_02 != 0 && parseFloat(salary_data.deduct_trans_id_02[2]) != 0) {
        deduct_trans_02 = salary_data.deduct_trans_id_02[3];
        deduct_02 = parseFloat(salary_data.deduct_trans_id_02[2]).toFixed(2);
    }

    var deduct_trans_03 = "";
    var deduct_03 = "";
    if (salary_data.deduct_trans_id_03 != 0 && parseFloat(salary_data.deduct_trans_id_03[2]) != 0) {
        deduct_trans_03 = salary_data.deduct_trans_id_03[3];
        deduct_03 = parseFloat(salary_data.deduct_trans_id_03[2]).toFixed(2);
    }

    var deduct_trans_04 = "";
    var deduct_04 = "";
    if (salary_data.deduct_trans_id_04 != 0 && parseFloat(salary_data.deduct_trans_id_04[2]) != 0) {
        deduct_trans_04 = salary_data.deduct_trans_id_04[3];
        deduct_04 = parseFloat(salary_data.deduct_trans_id_04[2]).toFixed(2);
    }

    var deduct_trans_05 = "";
    var deduct_05 = "";
    if (salary_data.deduct_trans_id_05 != 0 && parseFloat(salary_data.deduct_trans_id_05[2]) != 0) {
        deduct_trans_05 = salary_data.deduct_trans_id_05[3];
        deduct_05 = parseFloat(salary_data.deduct_trans_id_05[2]).toFixed(2);
    }

    var deduct_trans_06 = "";
    var deduct_06 = "";
    if (salary_data.deduct_trans_id_06 != 0 && parseFloat(salary_data.deduct_trans_id_06[2]) != 0) {
        deduct_trans_06 = salary_data.deduct_trans_id_06[3];
        deduct_06 = parseFloat(salary_data.deduct_trans_id_06[2]).toFixed(2);
    }

    var deduct_trans_07 = "";
    var deduct_07 = "";
    if (salary_data.deduct_trans_id_07 != 0 && parseFloat(salary_data.deduct_trans_id_07[2]) != 0) {
        deduct_trans_07 = salary_data.deduct_trans_id_07[3];
        deduct_07 = parseFloat(salary_data.deduct_trans_id_07[2]).toFixed(2);
    }

    var deduct_trans_08 = "";
    var deduct_08 = "";
    if (salary_data.deduct_trans_id_08 != 0 && parseFloat(salary_data.deduct_trans_id_08[2]) != 0) {
        deduct_trans_08 = salary_data.deduct_trans_id_08[3];
        deduct_08 = parseFloat(salary_data.deduct_trans_id_08[2]).toFixed(2);
    }

    var deduct_trans_09 = "";
    var deduct_09 = "";
    if (salary_data.deduct_trans_id_09 != 0 && parseFloat(salary_data.deduct_trans_id_09[2]) != 0) {
        deduct_trans_09 = salary_data.deduct_trans_id_09[3];
        deduct_09 = parseFloat(salary_data.deduct_trans_id_09[2]).toFixed(2);
    }

    var deduct_trans_10 = "";
    var deduct_10 = "";
    if (salary_data.deduct_trans_id_10 != 0 && parseFloat(salary_data.deduct_trans_id_10[2]) != 0) {
        deduct_trans_10 = salary_data.deduct_trans_id_10[3];
        deduct_10 = parseFloat(salary_data.deduct_trans_id_10[2]).toFixed(2);
    }


    var WIDTH = 240;

    var designation = employee_data.designation_sinhala;
    var designation_font = 'FM_Abhaya';
    if (!designation) {
        designation = employee_data.designation;
        designation_font = 'English_font';
    }
    var employee_name = employee_data.name_sinhala;
    var employee_name_font = 'FM_Abhaya';
    if (!employee_name) {
        employee_name = employee_data.name_withinitial;
        employee_name_font = 'English_font';
    }

    return {
        stack: [
            {
                table: {
                    widths: ['*'],
                    headerRows: 1,
                    body: [
                        [{ text: 'ßfhdafldflda ,xld ^mqoa& iud.u', font: 'FM_Abhaya', fontSize: 14, alignment: 'center', border: [false, false, false, false] }],
                    ],

                },
                margin: [0, 0],
            },
            {
                table: {
                    widths: ['*', 100],
                    headerRows: 1,
                    body: [
                        [{ text: 'jegqma m;%sldj', font: 'FM_Abhaya', fontSize: 12, alignment: 'left', border: [false, false, false, false] }, { text: MONTH_NAME[salary_data.salary_month] + " " + salary_data.salary_year, font: 'FM_Abhaya', fontSize: 10, alignment: 'right', border: [false, false, false, false] }],
                    ],

                },
                margin: [0, 0],
            },
            {
                table: {
                    widths: [53, 1, '*'],
                    headerRows: 1,
                    body: [
                        [{ text: ';k;=r ', font: 'FM_Abhaya', fontSize: 12, alignment: 'left', border: [false, false, false, false] }, { text: ':', fontSize: 10, border: [false, false, false, false] }, { text: designation, font: designation_font, fontSize: 11, alignment: 'left', border: [false, false, false, false] }],
                        [{ text: 'ku', font: 'FM_Abhaya', fontSize: 12, alignment: 'left', border: [false, false, false, false] }, { text: ':', fontSize: 10, border: [false, false, false, false] }, { text: employee_name, font: employee_name_font, fontSize: 11, alignment: 'left', border: [false, false, false, false] }],
                        [{ text: "fia' wxl", font: 'FM_Abhaya', fontSize: 12, alignment: 'left', border: [false, false, false, false] }, { text: ':', fontSize: 10, border: [false, false, false, false] }, { text: employee_data.employee_id, fontSize: 11, alignment: 'left', border: [false, false, false, false] }],
                    ],

                },
                layout: {
                    paddingTop: function (i) {
                        return i === 0 ? 0 : 0;
                    },
                    paddingBottom: function (i, node) {
                        return (i === node.table.widths.length - 1) ? 0 : 0;
                    }
                },
                margin: [0, 0],
            },
            {
                table: {
                    widths: [18, 26, 1, '*'],
                    headerRows: 1,
                    body: [
                        [{ text: "EPF", fontSize: 10, alignment: 'left', border: [false, false, false, false] }, { text: "wxl", font: 'FM_Abhaya', fontSize: 12, alignment: 'left', border: [false, false, false, false] }, { text: ':', fontSize: 10, border: [false, false, false, false] }, { text: employee_data.epf_no, fontSize: 10, alignment: 'left', border: [false, false, false, false] }],
                    ],

                },
                layout: {
                    paddingTop: function (i) {
                        return i === 0 ? 0 : 0;
                    },
                    paddingBottom: function (i, node) {
                        return (i === node.table.widths.length - 1) ? 0 : 0;
                    }
                },
                margin: [0, 0],
            },
            {
                canvas:
                    [
                        {
                            type: 'line',
                            x1: 0, y1: 0,
                            x2: WIDTH, y2: 0,
                            lineWidth: 1
                        }
                    ]
            },
            {
                table: {
                    widths: ['*', 20],
                    headerRows: 1,
                    body: [
                        [{ text: "fiajhg meñ‚ Èk .Kk", font: 'FM_Abhaya', fontSize: 12, alignment: 'left', border: [false, false, false, false] }, { text: (real_work_day + additional_worked_days).toFixed(1), fontSize: 10, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: "fiajhg fkdmeñ‚ Èk .Kk", font: 'FM_Abhaya', fontSize: 12, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(getNopayDays(real_work_day, employee_data.category.work_days_month) - additional_worked_days).toFixed(1), fontSize: 10, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: "uq¿ jev Èk .Kk", font: 'FM_Abhaya', fontSize: 12, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(parseFloat(getNopayDays(salary_data.real_work_day, employee_data.category.work_days_month) - additional_worked_days) + (real_work_day + additional_worked_days)).toFixed(1), fontSize: 10, alignment: 'right', border: [false, false, false, false] }],],

                },
                layout: {
                    paddingTop: function (i) {
                        return i === 0 ? 0 : 0;
                    },
                    paddingBottom: function (i, node) {
                        return (i === node.table.widths.length - 1) ? 0 : 0;
                    }
                },
                margin: [0, 0],
            },
            {
                canvas:
                    [
                        {
                            type: 'line',
                            x1: 0, y1: 0,
                            x2: WIDTH, y2: 0,
                            lineWidth: 1
                        }
                    ]
            },
            {
                table: {
                    widths: ['*'],
                    headerRows: 1,
                    body: [
                        [{ text: 'bmehsï', font: 'FM_Abhaya', fontSize: 12, bold: true, alignment: 'left', border: [false, false, false, false] }],
                    ],

                },
                margin: [0, 0],
            },
            {
                table: {
                    widths: ['*', 45],
                    headerRows: 1,
                    body: [
                        [{ text: 'uQ,sl jegqm', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.employee_basic_salary - salary_data.nopay_amount).toFixed(2), fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: 'wh jeh iyk §ukdj 1', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.budget1).toFixed(2), fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: 'wh jeh iyk §ukdj 2', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.budget2).toFixed(2), fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, true] }],
                        [{ text: '', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.employee_basic_salary - salary_data.nopay_amount + salary_data.budget1 + salary_data.budget2).toFixed(2), fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: '\n', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: '\n', fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                    ],

                },
                layout: {
                    paddingTop: function (i) {
                        return i === 0 ? 0 : 0;
                    },
                    paddingBottom: function (i, node) {
                        return (i === node.table.widths.length - 1) ? 0 : 0;
                    }
                },
                margin: [0, 0],
            },
            {
                table: {
                    widths: ['*', 55, 45],
                    headerRows: 1,
                    body: [
                        [{ text: 'idudkH w;Sld, §ukd', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: '(' + salary_data.ot_hours1 + ' X ' + parseFloat(salary_data.ot_rate1_amount).toFixed(2) + ')', fontSize: 8, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: salary_data.ot_amount1.toFixed(2), fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: 'oaú;aj w;sld, §ukd', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: '(' + salary_data.ot_hours2 + ' X ' + parseFloat(salary_data.ot_rate2_amount).toFixed(2) + ')', fontSize: 8, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: salary_data.ot_amount2.toFixed(2), fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                    ],

                },
                layout: {
                    paddingTop: function (i) {
                        return i === 0 ? 0 : 0;
                    },
                    paddingBottom: function (i, node) {
                        return (i === node.table.widths.length - 1) ? 0 : 0;
                    }
                },
                margin: [0, 0],
            },
            {
                table: {
                    widths: ['*', 45],
                    headerRows: 1,
                    body: [
                        [{ text: earn_trans_01, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: earn_01, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: earn_trans_02, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: earn_02, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: earn_trans_03, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: earn_03, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: earn_trans_04, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: earn_04, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: earn_trans_05, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: earn_05, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: earn_trans_06, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: earn_06, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: earn_trans_07, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: earn_07, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: earn_trans_08, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: earn_08, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: earn_trans_09, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: earn_09, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: earn_trans_10, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: earn_10, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],

                    ],

                },
                layout: {
                    paddingTop: function (i) {
                        return i === 0 ? 0 : 0;
                    },
                    paddingBottom: function (i, node) {
                        return (i === node.table.widths.length - 1) ? 0 : 0;
                    }
                },
                margin: [0, 0],
            },
            {
                canvas:
                    [
                        {
                            type: 'line',
                            x1: 0, y1: 0,
                            x2: WIDTH, y2: 0,
                            lineWidth: 1
                        }
                    ]
            },
            {
                table: {
                    widths: ['*', 60],
                    headerRows: 1,
                    body: [
                        [{ text: 'o< jegqm', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.gross_salary).toFixed(2), fontSize: 11, bold: false, alignment: 'right', border: [false, false, false, false] }],

                    ],

                },
                margin: [0, 0],
            },
            {
                canvas:
                    [
                        {
                            type: 'line',
                            x1: 0, y1: 0,
                            x2: WIDTH, y2: 0,
                            lineWidth: 1
                        }
                    ]
            },
            {
                canvas:
                    [
                        {
                            type: 'line',
                            x1: 0, y1: 0,
                            x2: WIDTH, y2: 0,
                            lineWidth: 1
                        }
                    ]
            },
            {
                table: {
                    widths: ['*'],
                    headerRows: 1,
                    body: [
                        [{ text: 'wvq lsßï', font: 'FM_Abhaya', fontSize: 12, bold: true, alignment: 'left', border: [false, false, false, false] }],
                    ],

                },
                margin: [0, 0],
            },
            {
                table: {
                    widths: ['*', 60],
                    headerRows: 1,
                    body: [

                        [{ text: 'jegqma w;a;sldrï', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.advance).toFixed(2), fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: 'm%udo ù meñŒu i|yd wvq lsßï', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.fine_amount).toFixed(2), fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: "fia'w' wruqo, 8]", font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.employee_epf).toFixed(2), fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: 'Kh uqo,a', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.loan).toFixed(2), fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],


                        [{ text: deduct_trans_01, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: deduct_01, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: deduct_trans_02, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: deduct_02, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: deduct_trans_03, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: deduct_03, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: deduct_trans_04, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: deduct_04, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: deduct_trans_05, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: deduct_05, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: deduct_trans_06, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: deduct_06, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: deduct_trans_07, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: deduct_07, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: deduct_trans_08, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: deduct_08, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: deduct_trans_09, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: deduct_09, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: deduct_trans_10, font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: deduct_10, fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],


                    ],

                },
                layout: {
                    paddingTop: function (i) {
                        return i === 0 ? 0 : 0;
                    },
                    paddingBottom: function (i, node) {
                        return (i === node.table.widths.length - 1) ? 0 : 0;
                    }
                },
                margin: [0, 0],
            },
            {
                canvas:
                    [
                        {
                            type: 'line',
                            x1: 0, y1: 0,
                            x2: WIDTH, y2: 0,
                            lineWidth: 1
                        }
                    ]
            },
            {
                table: {
                    widths: ['*', 60],
                    headerRows: 1,
                    body: [
                        [{ text: 'uq¿ wvq lsÍï', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.total_deduction).toFixed(2), fontSize: 11, bold: false, alignment: 'right', border: [false, false, false, false] }],

                    ],

                },
                layout: {
                    paddingTop: function (i) {
                        return i === 0 ? 0 : 0;
                    },
                    paddingBottom: function (i, node) {
                        return (i === node.table.widths.length - 1) ? 0 : 0;
                    }
                },
                margin: [0, 0],
            },
            {
                canvas:
                    [
                        {
                            type: 'line',
                            x1: 0, y1: 0,
                            x2: WIDTH, y2: 0,
                            lineWidth: 1
                        }
                    ]
            },
            {
                table: {
                    widths: ['*', 60],
                    headerRows: 1,
                    body: [
                        [{ text: 'Y=oaO jegqm', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.net_salary).toFixed(2), fontSize: 11, bold: false, alignment: 'right', border: [false, false, false, false] }],
                    ],

                },
                layout: {
                    paddingTop: function (i) {
                        return i === 0 ? 0 : 0;
                    },
                    paddingBottom: function (i, node) {
                        return (i === node.table.widths.length - 1) ? 0 : 0;
                    }
                },
                margin: [0, 0],
            },
            {
                canvas:
                    [
                        {
                            type: 'line',
                            x1: 0, y1: 0,
                            x2: WIDTH, y2: 0,
                            lineWidth: 1
                        }
                    ]
            },
            {
                table: {
                    widths: ['*', 60],
                    headerRows: 1,
                    body: [
                        [{ text: 'fiajHdf.a odhl;ajh', font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: '', fontSize: 11, bold: false, alignment: 'right', border: [false, false, false, false] }],

                    ],

                },
                layout: {
                    paddingTop: function (i) {
                        return i === 0 ? 0 : 0;
                    },
                    paddingBottom: function (i, node) {
                        return (i === node.table.widths.length - 1) ? 0 : 0;
                    }
                },
                margin: [0, 0],
            },
            {
                table: {
                    widths: ['*', 45],
                    headerRows: 1,
                    body: [
                        [{ text: "fia'w' wruqo, 12]", font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.employer_epf).toFixed(2), fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],
                        [{ text: "fia'Nd'wruqo, 3]", font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.employee_etf).toFixed(2), fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, true] }],

                    ],

                },
                layout: {
                    paddingTop: function (i) {
                        return i === 0 ? 0 : 0;
                    },
                    paddingBottom: function (i, node) {
                        return (i === node.table.widths.length - 1) ? 0 : 0;
                    }
                },
                margin: [0, 0],
            },
            {
                table: {
                    widths: ['*', 40],
                    headerRows: 1,
                    body: [
                        [{ text: "uq¿ odhl;ajh", font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: parseFloat(salary_data.employer_epf + salary_data.employee_etf).toFixed(2), fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, true] }],
                        //[{ text: "\n", font: 'FM_Abhaya', fontSize: 12, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: '\n', fontSize: 10, bold: false, alignment: 'right', border: [false, false, false, false] }],

                    ],

                },
                layout: {
                    paddingTop: function (i) {
                        return i === 0 ? 0 : 0;
                    },
                    paddingBottom: function (i, node) {
                        return (i === node.table.widths.length - 1) ? 0 : 0;
                    }
                },
                margin: [0, 0],
            },
            /*{
                canvas:
                    [
                        {
                            type: 'line',
                            x1: 0, y1: 0,
                            x2: WIDTH, y2: 0,
                            lineWidth: 1
                        }
                    ]
            },*/
        ]
    }

}








function showSalaryReport(result, earning_narration, deduction_narration, flag) {

    var Title = [
        { text: '' }
    ];




    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*', '*', '*'],
                        headerRows: 1,
                        body: [
                            [{ text: '', border: [false, false, false, false] }, { text: Page.getReportName($('#selcCompany').val()), fontSize: 5, bold: false, alignment: 'center', border: [false, false, false, false] }, { text: '', fontSize: 5, bold: true, alignment: 'right', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 6, border: [false, false, false, false] }, { text: "\n", fontSize: 6, bold: true, alignment: 'center', border: [false, false, false, false] }, { text: '\n', fontSize: 4, bold: true, alignment: 'right', border: [false, false, false, false] }],

                            [{ text: $('#cmbSalaryMonth option:selected').text() + " " + $('#cmbSalaryYear option:selected').text(), fontSize: 4, border: [false, false, false, false] }, { text: "EMPLOYEE'S PAY RECORD", fontSize: 6, bold: false, alignment: 'center', border: [false, false, false, false] }, { text: '', fontSize: 4, bold: true, alignment: 'right', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];

    var Body = [
        {
            table: {
                widths: ['*', 100, '*', '*', '*', '*', '*', '*', '*', '*','*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*'],
                body: salaryReportBody(result, earning_narration, deduction_narration),

            },

        },
    ];
    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];

    var page = new Page();
    page.setPageSize('A3');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}




function salaryReportBody(result, earning_narration, deduction_narration) {

    var font_size = 3;
    var body = [];

    var earning1 = "";
    if (earning_narration[0].narration) {
        earning1 = earning_narration[0].narration;
    }
    var earning2 = "";
    if (earning_narration[1].narration) {
        earning2 = earning_narration[1].narration;
    }
    var earning3 = "";
    if (earning_narration[2].narration) {
        earning3 = earning_narration[2].narration;
    }
    var earning4 = "";
    if (earning_narration[3].narration) {
        earning4 = earning_narration[3].narration;
    }
    var earning5 = "";
    if (earning_narration[4].narration) {
        earning5 = earning_narration[4].narration;
    }
    var earning6 = "";
    if (earning_narration[5].narration) {
        earning6 = earning_narration[5].narration;
    }
    var earning7 = "";
    if (earning_narration[6].narration) {
        earning7 = earning_narration[6].narration;
    }
    var earning8 = "";
    if (earning_narration[7].narration) {
        earning8 = earning_narration[7].narration;
    }
    var earning9 = "";
    if (earning_narration[8].narration) {
        earning9 = earning_narration[8].narration;
    }
    var earning10 = "";
    if (earning_narration[9].narration) {
        earning10 = earning_narration[9].narration;
    }




    var deduction1 = "";
    if (deduction_narration[0].narration) {
        deduction1 = deduction_narration[0].narration;
    }
    var deduction2 = "";
    if (deduction_narration[1].narration) {
        deduction2 = deduction_narration[1].narration;
    }
    var deduction3 = "";
    if (deduction_narration[2].narration) {
        deduction3 = deduction_narration[2].narration;
    }
    var deduction4 = "";
    if (deduction_narration[3].narration) {
        deduction4 = deduction_narration[3].narration;
    }
    var deduction5 = "";
    if (deduction_narration[4].narration) {
        deduction5 = deduction_narration[4].narration;
    }
    var deduction6 = "";
    if (deduction_narration[5].narration) {
        deduction6 = deduction_narration[5].narration;
    }
    var deduction7 = "";
    if (deduction_narration[6].narration) {
        deduction7 = deduction_narration[6].narration;
    }
    var deduction8 = "";
    if (deduction_narration[7].narration) {
        deduction8 = deduction_narration[7].narration;
    }
    var deduction9 = "";
    if (deduction_narration[8].narration) {
        deduction9 = deduction_narration[8].narration;
    }
    var deduction10 = "";
    if (deduction_narration[9].narration) {
        deduction10 = deduction_narration[9].narration;
    }


    body.push([{ text: 'Employee ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Employee Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Epf No', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Basic Salary', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Budget Allowance1', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Budget Allowance2', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Worked Days', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Nopay Days', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Basic Earning', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Overtime Hours1', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Overtime Amount1', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Overtime Hours2', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Overtime Amount2', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Overtime Amount 2 (Additional Payment)', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Overtime Hours3', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Overtime Amount3', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total O.T Hours', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning1, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning2, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning3, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning4, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning5, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning6, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning7, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning8, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning9, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning10, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction1, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction2, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction3, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction4, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction5, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction6, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction7, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction8, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction9, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction10, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },

    { text: 'Gross Salary', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Epf 8%', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Salary Advance', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Loan', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Debtor Loan', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Late Arriver\n(hour)', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Early Departure(hour)', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Late Arriver & Early Departure  Amount', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Total Deduction', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Net Salary', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].epf_no, fontSize: font_size, border: [false, false, false, true] },
            { text: parseFloat(result[i].basic_salary).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].budget1).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].budget2).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: result[i].worked_days, fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: result[i].nopay_days, fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat((result[i].basic_salary + result[i].budget1 + result[i].budget2)).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },

            { text: result[i].ot_hours1, fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].ot_amount1).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: result[i].ot_hours2, fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].ot_amount2).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].overtime2_additional_payment).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: result[i].ot_hours3, fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].ot_amount3).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].ot_hours1 + result[i].ot_hours2 + result[i].ot_hours3).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },

            { text: parseFloat(result[i].earn_01).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_02).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_03).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_04).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_05).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_06).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_07).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_08).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_09).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_10).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },

            { text: parseFloat(result[i].deduct_01).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_02).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_03).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_04).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_05).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_06).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_07).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_08).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_09).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_10).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },

            { text: parseFloat(result[i].gross_salary).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].employer_epf).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].advance).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].loan).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].debtor_loan).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].late_arriver).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].early_departure).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].fine_amount).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].total_deduction).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].net_salary).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },

        ]);
    }

    return body;
}




function showEmployeeDailyOTReport(result, flag) {

    var dayCount = daysInMonth(1, 2021);


    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Daily OT Report ' + result.report_date[0]['year'] + " " + result.report_date[0]['month'], fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [15, 50, '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', 50],
                headerRows: 1,
                body: employeeDailyOTReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function employeeDailyOTReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([
        { text: 'ID', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Employee Name', fontSize: font_size, border: [true, true, true, true] },
        { text: '1', fontSize: font_size, border: [true, true, true, true] },
        { text: '2', fontSize: font_size, border: [true, true, true, true] },
        { text: '3', fontSize: font_size, border: [true, true, true, true] },
        { text: '4', fontSize: font_size, border: [true, true, true, true] },
        { text: '5', fontSize: font_size, border: [true, true, true, true] },
        { text: '6', fontSize: font_size, border: [true, true, true, true] },
        { text: '7', fontSize: font_size, border: [true, true, true, true] },
        { text: '8', fontSize: font_size, border: [true, true, true, true] },
        { text: '9', fontSize: font_size, border: [true, true, true, true] },
        { text: '10', fontSize: font_size, border: [true, true, true, true], padding: 0 },
        { text: '11', fontSize: font_size, border: [true, true, true, true] },
        { text: '12', fontSize: font_size, border: [true, true, true, true] },
        { text: '13', fontSize: font_size, border: [true, true, true, true] },
        { text: '14', fontSize: font_size, border: [true, true, true, true] },
        { text: '15', fontSize: font_size, border: [true, true, true, true] },

        { text: '16', fontSize: font_size, border: [true, true, true, true] },
        { text: '17', fontSize: font_size, border: [true, true, true, true] },
        { text: '18', fontSize: font_size, border: [true, true, true, true] },
        { text: '19', fontSize: font_size, border: [true, true, true, true] },
        { text: '20', fontSize: font_size, border: [true, true, true, true] },
        { text: '21', fontSize: font_size, border: [true, true, true, true] },
        { text: '22', fontSize: font_size, border: [true, true, true, true] },
        { text: '23', fontSize: font_size, border: [true, true, true, true] },
        { text: '24', fontSize: font_size, border: [true, true, true, true] },
        { text: '25', fontSize: font_size, border: [true, true, true, true] },
        { text: '26', fontSize: font_size, border: [true, true, true, true] },
        { text: '27', fontSize: font_size, border: [true, true, true, true] },
        { text: '28', fontSize: font_size, border: [true, true, true, true] },
        { text: '29', fontSize: font_size, border: [true, true, true, true] },
        { text: '30', fontSize: font_size, border: [true, true, true, true] },
        { text: '31', fontSize: font_size, border: [true, true, true, true] },

        /*{ text: 'Present Days', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Absent Days', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Leave Days', fontSize: font_size, border: [true, true, true, true] },*/
        { text: 'Total OT Hours', fontSize: font_size, border: [true, true, true, true] },


    ]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day1, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day2, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day3, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day4, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day5, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day6, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day7, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day8, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day9, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day10, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day11, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day12, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day13, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day14, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day15, fontSize: font_size, border: [true, true, true, true] },

            { text: result[i].day16, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day17, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day18, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day19, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day20, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day21, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day22, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day23, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day24, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day25, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day26, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day27, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day28, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day29, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day30, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].day31, fontSize: font_size, border: [true, true, true, true] },

            /*{ text: result[i].present_day, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].absent_day, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].leave_day, fontSize: font_size, border: [true, true, true, true] },*/
            { text: result[i].TotalOTHours, fontSize: font_size, border: [true, true, true, true], alignment: 'right' },


        ]);
    }
    return body;
}


//// Salary Detail Report

function showSalaryDetailsReport(result, flag) {

    var dayCount = daysInMonth(1, 2021);


    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName($('#selcCompany').val()), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Salary Details Report ' + result.report_date[0]['year'] + " " + result.report_date[0]['month'], fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result.title, fontSize: 8, bold: true, alignment: 'left', border: [true, true, true, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [15, '*', '*', '*', 50, 50],
                headerRows: 1,
                body: employeeSalaryDetailsReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function employeeSalaryDetailsReportBody(result) {
    var font_size = 6;
    var body = [];
    body.push([
        { text: 'ID', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Employee Name', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Earning', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Deduction', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Basic Salary', fontSize: font_size, border: [true, true, true, true] },
        { text: 'Total Salary', fontSize: font_size, border: [true, true, true, true] },
    ]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].earning, fontSize: font_size, border: [true, true, true, true] },
            { text: result[i].deduction, fontSize: font_size, border: [true, true, true, true] },
            { text: parseFloat(result[i].basic_salary).toLocaleString('en-US', { minimumFractionDigits: 2 }), fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
            { text: parseFloat(result[i].total_salary).toLocaleString('en-US', { minimumFractionDigits: 2 }), fontSize: font_size, alignment: 'right', border: [true, true, true, true] },
        ]);
    }
    return body;
}

/// End of Salary Detail Report





function showSalaryReport2(result, earning_narration, deduction_narration, flag) {

    var Title = [
        { text: '' }
    ];




    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*', '*', '*'],
                        headerRows: 1,
                        body: [
                            [{ text: '', border: [false, false, false, false] }, { text: Page.getReportName($('#selcCompany').val()), fontSize: 5, bold: false, alignment: 'center', border: [false, false, false, false] }, { text: '', fontSize: 5, bold: true, alignment: 'right', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 6, border: [false, false, false, false] }, { text: "\n", fontSize: 6, bold: true, alignment: 'center', border: [false, false, false, false] }, { text: '\n', fontSize: 4, bold: true, alignment: 'right', border: [false, false, false, false] }],

                            [{ text: $('#cmbSalaryMonth option:selected').text() + " " + $('#cmbSalaryYear option:selected').text(), fontSize: 4, border: [false, false, false, false] }, { text: "Salary Details Report", fontSize: 6, bold: false, alignment: 'center', border: [false, false, false, false] }, { text: '', fontSize: 4, bold: true, alignment: 'right', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];

    var Body = [
        {
            table: {
                widths: ['*', 100, '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*', '*'],
                body: salaryReportBody2(result, earning_narration, deduction_narration),

            },

        },
    ];
    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];

    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}




function salaryReportBody2(result, earning_narration, deduction_narration) {

    var font_size = 3;
    var body = [];

    var earning1 = "";
    if (earning_narration[0].narration) {
        earning1 = earning_narration[0].narration;
    }
    var earning2 = "";
    if (earning_narration[1].narration) {
        earning2 = earning_narration[1].narration;
    }
    var earning3 = "";
    if (earning_narration[2].narration) {
        earning3 = earning_narration[2].narration;
    }
    var earning4 = "";
    if (earning_narration[3].narration) {
        earning4 = earning_narration[3].narration;
    }
    var earning5 = "";
    if (earning_narration[4].narration) {
        earning5 = earning_narration[4].narration;
    }
    var earning6 = "";
    if (earning_narration[5].narration) {
        earning6 = earning_narration[5].narration;
    }
    var earning7 = "";
    if (earning_narration[6].narration) {
        earning7 = earning_narration[6].narration;
    }
    var earning8 = "";
    if (earning_narration[7].narration) {
        earning8 = earning_narration[7].narration;
    }
    var earning9 = "";
    if (earning_narration[8].narration) {
        earning9 = earning_narration[8].narration;
    }
    var earning10 = "";
    if (earning_narration[9].narration) {
        earning10 = earning_narration[9].narration;
    }




    var deduction1 = "";
    if (deduction_narration[0].narration) {
        deduction1 = deduction_narration[0].narration;
    }
    var deduction2 = "";
    if (deduction_narration[1].narration) {
        deduction2 = deduction_narration[1].narration;
    }
    var deduction3 = "";
    if (deduction_narration[2].narration) {
        deduction3 = deduction_narration[2].narration;
    }
    var deduction4 = "";
    if (deduction_narration[3].narration) {
        deduction4 = deduction_narration[3].narration;
    }
    var deduction5 = "";
    if (deduction_narration[4].narration) {
        deduction5 = deduction_narration[4].narration;
    }
    var deduction6 = "";
    if (deduction_narration[5].narration) {
        deduction6 = deduction_narration[5].narration;
    }
    var deduction7 = "";
    if (deduction_narration[6].narration) {
        deduction7 = deduction_narration[6].narration;
    }
    var deduction8 = "";
    if (deduction_narration[7].narration) {
        deduction8 = deduction_narration[7].narration;
    }
    var deduction9 = "";
    if (deduction_narration[8].narration) {
        deduction9 = deduction_narration[8].narration;
    }
    var deduction10 = "";
    if (deduction_narration[9].narration) {
        deduction10 = deduction_narration[9].narration;
    }


    body.push([{ text: 'Employee ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Employee Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning1, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning2, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning3, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning4, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning5, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning6, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning7, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning8, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning9, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: earning10, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction1, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction2, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction3, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction4, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction5, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction6, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction7, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction8, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction9, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: deduction10, fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Gross Salary', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Net Salary', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].employee_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].employee_name, fontSize: font_size, border: [false, false, false, true] },

            { text: parseFloat(result[i].earn_01).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_02).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_03).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_04).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_05).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_06).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_07).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_08).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_09).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].earn_10).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },

            { text: parseFloat(result[i].deduct_01).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_02).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_03).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_04).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_05).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_06).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_07).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_08).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_09).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].deduct_10).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },

            { text: parseFloat(result[i].gross_salary).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },
            { text: parseFloat(result[i].net_salary).toFixed(2), fontSize: font_size, border: [false, false, false, true], alignment: 'right' },

        ]);
    }

    return body;
}



function daysInMonth(month, year) {
    return new Date(year, month, 0).getDate();
}

function switch_settings(setting) {

    if (setting != 'checkCategorySearch') {
        $('#checkCategorySearch').prop('checked', false);
        $('#selcCategory').prop("disabled", true);
        setting_array.category = null;
    }
    if (setting != 'checkSiteSearch') {
        $('#checkSiteSearch').prop('checked', false);
        $('#selcSite').prop("disabled", true);
        setting_array.site = null;
    }
    if (setting != 'checkDepartmentSearch') {
        $('#checkDepartmentSearch').prop('checked', false);
        $('#selcDepartment').prop("disabled", true);
        setting_array.department = null;
    }
    if (setting != 'checkSectionSearch') {
        $('#checkSectionSearch').prop('checked', false);
        $('#selcSection').prop("disabled", true);
        setting_array.section = null;
    }
    if (setting != 'checkSubsectionSearch') {
        $('#checkSubsectionSearch').prop('checked', false);
        $('#selcSubsection').prop("disabled", true);
        setting_array.subsection = null;
    }
    if (setting != 'checkCompanySearch') {
        $('#checkCompanySearch').prop('checked', false);
        $('#selcCompany').prop("disabled", true);
        setting_array.company = null;
    }
    if (setting != 'checkTeamSearch') {
        $('#checkTeamSearch').prop('checked', false);
        $('#selcTeam').prop("disabled", true);
        setting_array.team = null;
    }
    if (setting != 'checkEmployeeSearch') {
        $('#checkEmployeeSearch').prop('checked', false);
        $('#selcEmployee').prop("disabled", true);
        setting_array.employee = null;
    }
}


function showDate(args) {

    if (args == 'SINGLE_DATE') {
        $('#endDate').hide();
        $('#dateYearMonth').hide();
    } else if (args == 'COUPLE_DATE') {
        $('#startDate').show();
        $('#endDate').show();
        $('#dateYearMonth').hide();
    } else if (args == 'NON_DATE') {
        $('#startDate').hide();
        $('#endDate').hide();
        $('#dateYearMonth').hide();
    } else if (args == 'YEAR_MONTH') {
        $('#startDate').hide();
        $('#endDate').hide();
        $('#dateYearMonth').show();
    }
}



function _export() {
    createReport('EXPORT');
}


function appendSalaryYear() {

    var date = serverDate();
    var current_year = parseInt(date.split("/")[0]);
    for (i = 2020; i <= current_year; i++) {
        $('#cmbSalaryYear').append('<option value="' + i + '">' + i + '</option>')
    }
}


function getNopayDays(workdays, cat_work_days) {

    var nopay = 0;
    workdays = parseFloat(workdays);
    cat_days = parseFloat(cat_work_days)
    if (workdays >= cat_days) {
        nopay = 0;
    } else {
        nopay = (cat_days - workdays);
    }

    return parseFloat(nopay).toFixed(1);
}



function getTotalDayCount(workdays, nopaydays) {

    workdays = parseFloat(workdays);
    nopaydays = parseFloat(nopaydays)
    if (workdays >= 25) {
        nopaydays = parseFloat(0).toFixed(2);
    } else {
        nopaydays = parseFloat(nopaydays).toFixed(2);
    }

    return parseFloat(nopaydays + workdays).toFixed(2);
}


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
