allTransactionItemEarnings();
allTransactionItemDeducations();
allTransactionItemSetup();


const MAP_ID =
{
    "E_row_0_col_1": "E01",
    "E_row_1_col_1": "E02",
    "E_row_2_col_1": "E03",
    "E_row_3_col_1": "E04",
    "E_row_4_col_1": "E05",
    "E_row_5_col_1": "E06",
    "E_row_6_col_1": "E07",
    "E_row_7_col_1": "E08",
    "E_row_8_col_1": "E09",
    "E_row_9_col_1": "E10",

    "D_row_0_col_1": "D01",
    "D_row_1_col_1": "D02",
    "D_row_2_col_1": "D03",
    "D_row_3_col_1": "D04",
    "D_row_4_col_1": "D05",
    "D_row_5_col_1": "D06",
    "D_row_6_col_1": "D07",
    "D_row_7_col_1": "D08",
    "D_row_8_col_1": "D09",
    "D_row_9_col_1": "D10",

};


const MAP_ID2 =
{
    "E01": "Earning",
    "E02": "Earning",
    "E03": "Earning",
    "E04": "Earning",
    "E05": "Earning",
    "E06": "Earning",
    "E07": "Earning",
    "E08": "Earning",
    "E09": "Earning",
    "E10": "Earning",

    "D01": "Deducation",
    "D02": "Deducation",
    "D03": "Deducation",
    "D04": "Deducation",
    "D05": "Deducation",
    "D06": "Deducation",
    "D07": "Deducation",
    "D08": "Deducation",
    "D09": "Deducation",
    "D10": "Deducation",

};

function allTransactionItemEarnings() {
    $.ajax({
        type: "GET",
        url: '/hr/transactionItemSetup/allTransactionItemEarnings',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                $('#E_row_0_col_1').setData(response.data.result);

                $('#E_row_1_col_1').setData(response.data.result);

                $('#E_row_2_col_1').setData(response.data.result);

                $('#E_row_3_col_1').setData(response.data.result);

                $('#E_row_4_col_1').setData(response.data.result);

                $('#E_row_5_col_1').setData(response.data.result);

                $('#E_row_6_col_1').setData(response.data.result);

                $('#E_row_7_col_1').setData(response.data.result);

                $('#E_row_8_col_1').setData(response.data.result);

                $('#E_row_9_col_1').setData(response.data.result);
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}





function allTransactionItemDeducations() {
    $.ajax({
        type: "GET",
        url: '/hr/transactionItemSetup/allTransactionItemDeducations',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                $('#D_row_0_col_1').setData(response.data.result);

                $('#D_row_1_col_1').setData(response.data.result);

                $('#D_row_2_col_1').setData(response.data.result);

                $('#D_row_3_col_1').setData(response.data.result);

                $('#D_row_4_col_1').setData(response.data.result);

                $('#D_row_5_col_1').setData(response.data.result);

                $('#D_row_6_col_1').setData(response.data.result);

                $('#D_row_7_col_1').setData(response.data.result);

                $('#D_row_8_col_1').setData(response.data.result);

                $('#D_row_9_col_1').setData(response.data.result);
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}


function save() {

    var form = new FormData();
    var _token = $("input[name='_token']").val();
    form.append("_token", _token);

    for (i = 0; i < 10; i++) {
        var name = 'setup' + i;
        var setup = {
            "setup_id": MAP_ID[$('#E_row_' + i + '_col_1').attr('id')],
            "item_id": $('#E_row_' + i + '_col_1').optionID(),
            "narration": $('#E_row_' + i + '_col_1').val(),
            "status": document.getElementById('E_row_' + i + '_col_2').checked,
        };

        form.append(name, JSON.stringify(setup));
    }


    for (i = 0; i < 10; i++) {

        var name = 'setup' + (10 + i);
        var setup = {
            "setup_id": MAP_ID[$('#D_row_' + i + '_col_1').attr('id')],
            "item_id": $('#D_row_' + i + '_col_1').optionID(),
            "narration": $('#D_row_' + i + '_col_1').val(),
            "status": document.getElementById('D_row_' + i + '_col_2').checked,
        };

        form.append(name, JSON.stringify(setup));
    }



    $.ajax({
        type: "POST",
        url: '/hr/transactionItemSetup/save',
        data: form,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Settings has been saved successfully...");

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });

}


function allTransactionItemSetup() {

    $.ajax({
        type: "GET",
        url: '/hr/transactionItemSetup/allTransactionItemSetup',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var setup_arr = response.data.result;

                var earning_setup = Array();
                var deducation_setup = Array();
                for (i = 0; i <= 19; i++) {
                    var setup_name = MAP_ID2[setup_arr[i]['setup_id']];

                    if (setup_name == "Earning") {
                        earning_setup.push(setup_arr[i]);
                    }

                    if (setup_name == "Deducation") {
                        deducation_setup.push(setup_arr[i]);
                    }
                }
                setEarningItemSetup(earning_setup);
                setDeducationItemSetup(deducation_setup);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}


function setEarningItemSetup(setup_arr) {

    for (i = 0; i < setup_arr.length; i++) {
        var setup = setup_arr[i];
        $('#E_row_' + i + '_col_0').val(generateID(setup.item_id));
        $('#E_row_' + i + '_col_1').val(setup.narration);
        $('#E_row_' + i + '_col_1').attr('data-id', setup.item_id);
        if (setup.status == 0) {
            $('#E_row_' + i + '_col_2').prop('checked', false);
        } else {
            $('#E_row_' + i + '_col_2').prop('checked', true);
        }
    }

}


function setDeducationItemSetup(setup_arr) {

    for (i = 0; i < setup_arr.length; i++) {
        var setup = setup_arr[i];
        $('#D_row_' + i + '_col_0').val(generateID(setup.item_id));
        $('#D_row_' + i + '_col_1').val(setup.narration);
        $('#D_row_' + i + '_col_1').attr('data-id', setup.item_id);
        if (setup.status == 0) {
            $('#D_row_' + i + '_col_2').prop('checked', false);
        } else {
            $('#D_row_' + i + '_col_2').prop('checked', true);
        }

    }

}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {

    toastr.success(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


/**
* showWarrningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {

    toastr.warning(message);
}


/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "000",
        2: "00",
        3: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}


function autoCompleteSelectedOption(parent,args) {

   

}


function setId_onChangeEarningOption(event,id){
    $('#'+id).val(generateID($('#'+event.target.id).optionID()));
}

function setId_onChangeDeductionOption(event,id){
    $('#'+id).val(generateID($('#'+event.target.id).optionID()));
}

