@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/category.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<script>
    var edit_permission = "{{Auth::user()->can('employee_category_edit')}}";
    var view_permission = "{{Auth::user()->can('employee_category_view')}}";
    var delete_permission = "{{Auth::user()->can('employee_category_delete')}}";
    var disable_permission = "{{Auth::user()->can('employee_category_enable_disable')}}";
</script>
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Category</h6>
                <div class="row">
                    <div class="col-md-12 mb-3">
                        @if(Auth::user()->can('employee_category_create'))
                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal()">
                            <i class="fa fa-plus" aria-hidden="true"></i>
                        </button>
                        @endif
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <!-- Required for Responsive -->
                            <table id="tblCategory" class="table table-striped  datatable">
                                <thead>
                                    <tr>
                                        <th class="thCategoryID">Category ID</th>
                                        <th class="thCategory">Category</th>
                                        <th class="thEdit">Edit</th>
                                        <th class="thView">View</th>
                                        <th class="thDelete">Delete</th>
                                        <th class="thStatus">Status</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="categoryAddModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="categoryAddModalTitle">Add New Category</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <form action="POST" id="categoryForm">
                    {{csrf_field()}}
                    <div class="modal-body" id="settingsAddModalBody">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <label>Category</label>
                                        <input type="text" id="txtCategory" name="txtCategory" class="form-control">
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label>Calculate</label>
                                        <select class="form-control" id="selcCalculate" name="selcCalculate">
                                            <option value="1">Hour Basis</option>
                                            <option value="2">Day Basis</option>
                                            <option value="3">Month Basis</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>Payment Type</label>
                                        <select class="form-control" id="selcPayment" name="selcPayment">
                                            <option value="1">Daily</option>
                                            <option value="2">Weekly</option>
                                            <option value="3">Monthly</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label>Work Days Per Month</label>
                                        <input type="text" class="form-control" id="txtWorkMonth" name="txtWorkMonth">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>Work Hour Per Day</label>
                                        <input type="text" class="form-control" id="txtWorkDay" name="txtWorkDay">
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label>Ovetime Rate 1</label>
                                        <input type="text" class="form-control" id="txtOvertime1" name="txtOvertime1">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>Fixed OT Rate1</label>
                                        <input type="text" class="form-control" id="txtFixedOtRate1" name="txtFixedOtRate1">
                                    </div>
                                </div>



                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label>Ovetime Rate 2</label>
                                        <input type="text" class="form-control" id="txtOvertime2" name="txtOvertime2">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>Fixed OT Rate2</label>
                                        <input type="text" class="form-control" id="txtFixedOtRate2" name="txtFixedOtRate2">
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label>Ovetime Rate 3</label>
                                        <input type="text" class="form-control" id="txtOvertime3" name="txtOvertime3">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>Fixed OT Rate3</label>
                                        <input type="text" class="form-control" id="txtFixedOtRate3" name="txtFixedOtRate3">
                                    </div>
                                </div>



                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label>EPF Employee %</label>
                                        <input type="text" class="form-control" id="txtEpfEmployee" name="txtEpfEmployee">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>EPF Employer %</label>
                                        <input type="text" class="form-control" id="txtEpfEmployer" name="txtEpfEmployer">
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label>Budget Allowance 1</label>
                                        <input type="text" class="form-control" id="txtAllowance1" name="txtAllowance1">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>ETF Employee %</label>
                                        <input type="text" class="form-control" id="txtEtfEmployee" name="txtEtfEmployee">
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label>Fine Rate</label>
                                        <input type="text" class="form-control" id="txtFineRate" name="txtFineRate">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label>Budget Allowance 2</label>
                                        <input type="text" class="form-control" id="txtAllowance2" name="txtAllowance2">
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>
                        <button type="button" class="btn btn-primary" id="btnAction" onclick="actionBtn(event)">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ Module::asset('hr:js/category.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection