@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/employee.css') }}" type="text/css">

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Form Page</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <form method="POST" id="recruitmentForm" enctype="multipart/form-data">
                {{ csrf_field() }}
                <div class="card-body">
                    <h6 class="card-title">Recruitment Request</h6>


                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="tbGeneral" role="tabpanel" aria-labelledby="pills-general-tab">
                            <div class="row">
                                <div class="col-md-6">

                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-building text-info" aria-hidden="true"></i>
                                            <label for="selcDepartment">Department</label>
                                            <input type="hidden" id="hidUserID" name="hidUserID" value="">
                                            <select class="form-control" id="selcDepartment" name="selcDepartment"></select>
                                            <div class="valid-feedback">
                                                Looks good!
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-user-o text-info" aria-hidden="true"></i>
                                            <label for="selcDesignation">Designation</label>
                                            <select class="form-control" id="selcDesignation" name="selcDesignation"></select>
                                            <div class="valid-feedback">
                                                Looks good!
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                            <label for="txtJobRole">Job Role</label>
                                            <input type="text" class="form-control" id="txtJobRole" name="txtJobRole" placeholder="job_role" required="">
                                            <div class="valid-feedback">
                                                Looks good!
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="col-md-12 mb-4">
                                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                            <label for="txtVacancies">No Of Vacancies</label>
                                            <input type="text" class="form-control" id="txtVacancies" name="txtVacancies" placeholder="no_of_vacant" required="">
                                            <div class="valid-feedback">
                                                Looks good!
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="col-md-6 mb-4">
                                            <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                            <label for="dtePost">Post Date</label>
                                            <input type="text" class="form-control" id="dtePost" name="dtePost" placeholder="" required="">
                                            <div class="valid-feedback">
                                                Looks good!
                                            </div>
                                        </div>

                                        <div class="col-md-6 mb-4">
                                            <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                            <label for="dteExpire">Expire Date</label>
                                            <input type="text" class="form-control" id="dteExpire" name="dteExpire" placeholder="" required="">
                                            <div class="valid-feedback">
                                                Looks good!
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="col-md-6 mb-4">
                                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                            <label for="txtAgeFrom">Age From</label>
                                            <input type="text" class="form-control" id="txtAgeFrom" name="txtAgeFrom" placeholder="age_from" required="">
                                            <div class="valid-feedback">
                                                Looks good!
                                            </div>
                                        </div>

                                        <div class="col-md-6 mb-4">
                                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                            <label for="txtTo">To</label>
                                            <input type="text" class="form-control" id="txtTo" name="txtTo" placeholder="age_to" required="">
                                            <div class="valid-feedback">
                                                Looks good!
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div class="col-md-6">

                                    <div class="container">

                                        <div class="row">
                                            <div class="col-md-12 mb-5">
                                                <i class="fa fa-graduation-cap text-info" aria-hidden="true"></i>
                                                <label for="txtEducation">Education Qualification</label>
                                                <textarea class="form-control" id="txtEducation" name="txtEducation"></textarea>
                                                <div class="valid-feedback">
                                                    Looks good!
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-12 mb-5">
                                                <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                                <label for="txtExperience">Experience</label>
                                                <textarea class="form-control" id="txtExperience" name="txtExperience"></textarea>
                                                <div class="valid-feedback">
                                                    Looks good!
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-12 mb-4">
                                                <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                                <label for="txtRemarks">Remarks</label>
                                                <textarea class="form-control" id="txtRemarks" name="txtRemarks"></textarea>
                                                <div class="valid-feedback">
                                                    Looks good!
                                                </div>
                                            </div>
                                        </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer RecruitmentSave">
                    <button type="button" class="btn btn-warning" id="btnResetRecruitment">Reset</button>
                    <button type="button" class="btn btn-primary ml-2" id="btnSaveRecruitment">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

<!-- App scripts -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>
<!-- Javascript -->
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ Module::asset('hr:js/recruitment_request.js') }}"></script>
<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
@endsection
