<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class BagMiHeader extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_bags_mi_headers';
    protected $primaryKey = 'internal_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'internal_id',
        'external_id',
        'ref_internal_id',
        'ref_external_id',
        'trans_date',
        'dept_id',
        'machine_id',
        'store_id',
        'supervisor_id',
        'employee_name',
        'mr_internal_id',
        'mr_extenal_id',
        'document_no',
        'mi_type',
        'schedule_customer_order_plan_id',
        'manufacturing_order_number',
        'vehicle_no',
        'to_store',
        'project_code',
        'remarks',
        'status',
        'user_id',
        'ref_mr_id',
        
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_bags_mi_headers";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
    // protected static function newFactory()
    // {
    //     return \Modules\Sc\Database\factories\BagMiHeaderFactory::new();
    // }
}
