<?php

namespace Modules\Sc\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hr\Entities\Employee;
use Modules\Pp\Entities\Machinary;
use Modules\Sc\Entities\Department;
use Modules\Sc\Entities\BagGrnData;
use Modules\Sc\Entities\BagGrnHeader;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Suppliers;
use Modules\St\Entities\Uom;

class GoodsReturnBagsListController extends Controller
{
    public function allGoodsReturn()
    {
        try {
            $grnList = BagGrnHeader::where('document_no', '=', '610')->orderBy('internal_id', 'DESC')->get();
            foreach ($grnList as $grn) {
                $supplier = Suppliers::find($grn->supplier_Id);
                $grn->supplier = $supplier->supplier_name;
            }
            $responseBody = $this->responseBody(true, "GoodsReturnBagsListController", "allGrn", $grnList);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsReturnBagsListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function goodsReturnReport($id)
    {
        try {
            $grn = BagGrnHeader::find($id);

            $header = [
                "referance_no" => "",
                "date" => "",
                "supplier" => "",
                "received_by" => "",
                "store" => "",
                "supplier_ref_no" => "",
                "po_no" => "",
                "transport_by" => "",
                "vehicle_no" => "",
            ];


            if ($grn) {
                $header["referance_no"] = $grn->external_id;
                $header["date"] = $grn->trans_date;
                $header["supplier"] = $this->getSupplier($grn->supplier_Id);
                $header["received_by"] = $this->getReceivedBy($grn->received_by);
                $header["store"] = $this->getStore($grn->store_id);
                $header["supplier_ref_no"] = $grn->supplier_ref_no;
                $header["po_no"] = $grn->purchase_order_no;
                $header["transport_by"] = $grn->transaport_by;
                $header["vehicle_no"] = $grn->vehicle_no;
            }

            $data = BagGrnData::where('internal_id', '=', $id)->get();
            foreach ($data as $dd) {
                $product = Product::find($dd->product_id);
                $dd->product_id = $product->product_id;
                $dd->product = $product->product_name;
                $uom = ProductUnit::find($dd->unit_id);
                if ($uom) {
                    $dd->unit = $uom->name;
                } else {
                    $dd->unit = "";
                }
            }


            $responseBody = $this->responseBody(true, "GoodsReturnBagsListController", "goodsReturnReport", ["header" => $header, "body" => ["data" => $data]]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsReturnBagsListController", "goodsReturnReport", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    private function getSupplier($id)
    {

        $supplier = Suppliers::find($id);
        if ($supplier) {
            return $supplier->supplier_name;
        }
        return "";
    }


    private function getReceivedBy($id)
    {

        $received = Employee::find($id);
        if ($received) {
            return $received->name_withinitial;
        }
        return "";
    }



    private function getDepartment($id)
    {

        $department = Department::find($id);
        if ($department) {
            return $department->department;
        }
        return "";
    }


    private function getStore($id)
    {
        $store = StoreLocation::find($id);
        if ($store) {
            return $store->name;
        }
        return "";
    }



    private function getType($id)
    {
        if ($id == 0) {
            return "General";
        } else if ($id == 1) {
            return "Production";
        } else if ($id == 2) {
            return "Maintenance";
        }
        return "";
    }



    private function getMachine($id)
    {
        $machine = Machinary::find($id);
        if ($machine) {
            return $machine->machinery_no;
        }
        return "";
    }



    public function deleteGoodsReturn($id)
    {

        try {
            /*$mi_header = MiHeader::find($id);
            if ($mi_header) {
                if ($this->delete($mi_header->external_id)) {
                    $this->removeProductHistory($mi_header);
                    $this->removeProductFromSetoff($mi_header);
                    $mi_header->delete();
                }
            }*/
            $responseBody = $this->responseBody(true, "GoodsReturnBagsListController", "deleteMaterialIssue", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsReturnBagsListController", "deleteMaterialIssue", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function change_status(Request $request,$id)
    {

        try {

            $grn_header = BagGrnHeader::where([['internal_id','=',$id],['document_no','=','610']])->first();
            $grn_header->status = $request->get('status');
            $grn_header->update();

            $responseBody = $this->responseBody(true, "GoodsReturnBagsListController", "approve", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsReturnBagsListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
