<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Sc\Entities\BagGoodsTransferData;
use Modules\Sc\Entities\BagGoodsTransferHeader;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;

class GoodsTransferBagsListController extends Controller
{
    public function allGoodsTransfer()
    {
        try {
            $goods_transfers = BagGoodsTransferHeader::select('*')->orderBy('internal_id', 'DESC')->get();
            foreach($goods_transfers as $goods_transfer){
                $store_from = StoreLocation::find($goods_transfer->store_from_id);
                $store_to = StoreLocation::find($goods_transfer->store_to_id);
                $goods_transfer->store_from = $store_from->name;
                $goods_transfer->store_to = $store_to->name;
            }
            $responseBody = $this->responseBody(true, "GoodsTransferBagsListController", "allGoodsTransfer", $goods_transfers);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferBagsListController", "allGoodsTransfer", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    public function goodsTransferReport($id)
    {
        try {
            $gt_header = BagGoodsTransferHeader::find($id);

            $header = [
                "referance_no" => "",
                "date" => "",
                "store_from" => "",
                "store_to" => "",
                // "department" => "",
                // "store" => "",
                // "type" => "",
                // "manufacturing_order" => "",
                // "machine_no" => "",
                // "supervisor" => "",
                "no_of_items" => "0.00",
            ];

            if ($gt_header) {

                $header["supervisor"] = "";

                if ($gt_header->external_id) {
                    $header["referance_no"] = $gt_header->external_id;
                }
                if ($gt_header->trans_date) {
                    $header["date"] = $gt_header->trans_date;
                }
                
                if ($this->getStore($gt_header->store_from_id)) {
                    $header["store_from"] = $this->getStore($gt_header->store_from_id);
                }
                if ($this->getStore($gt_header->store_to_id)) {
                    $header["store_to"] = $this->getStore($gt_header->store_to_id);
                }
                // if ($this->getDepartment($gt_header->dept_id)) {
                //     $header["department"] = $this->getDepartment($gt_header->dept_id);
                // }
                // if ($this->getStore($gt_header->store_id)) {
                //     $header["store"] = $this->getStore($gt_header->store_id);
                // }
                // if ($this->getType($gt_header->mi_type)) {
                //     $header["type"] = $this->getType($gt_header->mi_type);
                // }
                // if ($gt_header->manufacturing_order_number) {
                //     $header["manufacturing_order"] = $gt_header->manufacturing_order_number;
                // }
                // if ($this->getMachine($gt_header->machine_id)) {
                //     $header["machine_no"] = $this->getMachine($gt_header->machine_id);
                // }
                
            }

            $data = BagGoodsTransferData::where('internal_id', '=', $id)->get();
            $no_of_items = 0;
            foreach ($data as $dd) {
                $product = Product::find($dd->product_id);
                $dd->product_id = $product->product_id;
                $dd->product = $product->product_name;
                $uom = ProductUnit::find($dd->unit_id);
                $no_of_items+= $dd->quantity;
                if ($uom) {
                    $dd->unit = $uom->name;
                } else {
                    $dd->unit = "";
                }
            }
            $header["no_of_items"] = $no_of_items;

            $responseBody = $this->responseBody(true, "GoodsTransferBagsListController", "goodsTransferReport", ["header" => $header, "body" => ["data" => $data]]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferBagsListController", "goodsTransferReport", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    private function getStore($id)
    {
        $store = StoreLocation::find($id);
        if ($store) {
            return $store->name;
        }
        return "";
    }

    public function delete($id)
    {
        try {
            BagGoodsTransferData::where('internal_id','=',$id)->delete();
            BagGoodsTransferHeader::find($id)->delete();
            $responseBody = $this->responseBody(true, "GoodsTransferBagsListController", "delete", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsTransferBagsListController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


       /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
