<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Fm\Entities\SupplierInvoiceData;
use Modules\Hr\Entities\Employee;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\BagGrnAttachment;
use Modules\Sc\Entities\BagGrnData;
use Modules\Sc\Entities\BagGrnHeader;
use Modules\Sc\Entities\ProductHistory;
use Modules\Sc\Entities\ProductHistorySetoff;
use Modules\Sc\Entities\PurchaseOrderHeader;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Suppliers;
use Modules\St\Entities\Uom;

class GrnBagsHeaderController extends Controller
{



    public function allEmployees()
    {
        try {
            $employees = Employee::all();
            $result = array();
            foreach ($employees as $emp) {
                array_push($result, [
                    "img" => "",
                    "id" => $emp->employee_id,
                    "value" => $emp->name_withinitial,
                ]);
            }
            $responseBody = $this->responseBody(true, "GrnBagsHeaderController", "allEmployees", $result);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnBagsHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function allSuppliers()
    {
        try {
            $products =  Suppliers::select('supplier_id As id', 'supplier_name As value0')->get();
            return $this->responseBody(true, "GrnBagsHeaderController", "allSuppliers", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "GrnBagsHeaderController", "error", $exception);
        }
    }


    public function allProduct()
    {
        try {
            $products =  Product::select('product_primary_id As id', 'product_id As value0', 'product_name As value1')
                        ->where('product_type_id', '=', 4)
                        ->orWhere('product_type_id', '=', 5)
                        ->get();
            return $this->responseBody(true, "GrnBagsHeaderController", "allProduct", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "GrnBagsHeaderController", "error", $exception);
        }
    }


    public function maxID($store_id, $document_no)
    {
        try {
            $grn = BagGrnHeader::where('document_no', '=', $document_no)->get();
            $id = $grn[count($grn) - 1]['internal_id'] + 1;
            $store = StoreLocation::find($store_id);
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
            }
            $responseBody = $this->responseBody(true, "GrnBagsHeaderController", "allProductUnit", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnBagsHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allStores()
    {
        try {
            $stores =  StoreLocation::all();
            $responseBody = $this->responseBody(true, "GrnBagsHeaderController", "allStores", $stores);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnBagsHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    function allCustomerOrderPlan()
    {
        try {
            $cus_orders_arr = [];
            $query = "  SELECT pp_customer_orders.purchase_order,
                        pp_customer_orders.delivery_date, 
                        pp_customer_order_plans.* 
                        FROM pp_customer_order_plans
                        INNER JOIN pp_customer_orders 
                        ON pp_customer_order_plans.order_id = pp_customer_orders.order_id 
                        WHERE  pp_customer_orders.production_status < 2";
            $customerPlan = DB::select($query);
           
            foreach ($customerPlan as $cus_order) {
     
                $id = $cus_order->customer_order_plan_id;
                $manufacturing_order_number = $cus_order->manufacturing_order_number;
                $purchase_order = $cus_order->purchase_order;
            
                array_push($cus_orders_arr, [
                    "id" => $id,
                    "value" => $manufacturing_order_number . ' - ' . $purchase_order 
                ]);
            }
            $responseBody = $this->responseBody(true, "GrnBagsHeaderController", "allCustomerOrderPlan", $cus_orders_arr);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "GrnBagsHeaderController", "error", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function allProductCustomer()
    {
        try {
            $query = 'SELECT pp_customer_order_plans.customer_order_plan_id,
            pp_customer_orders.factory_po_num,
            st_products.product_name,
            pp_customer_order_plans_data.customer_order_plan_data_id
            FROM pp_customer_order_plans
            LEFT JOIN pp_customer_orders ON pp_customer_order_plans.order_id = pp_customer_orders.order_id
            LEFT JOIN pp_customer_order_plans_data ON pp_customer_order_plans.customer_order_plan_id = pp_customer_order_plans_data.customer_order_plan_id
            LEFT JOIN st_products ON pp_customer_order_plans_data.product_id = st_products.product_primary_id
			ORDER BY pp_customer_order_plans.customer_order_plan_id DESC';
            $orderPlan =  DB::select($query);
            $responseBody = $this->responseBody(true, "MiBagsController", "allProductCustomer", $orderPlan);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "MiBagsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function save(Request $request)
    {
        try {
            $prefix = $this->getPrefix('100');

            $grn = new BagGrnHeader();
            $grn->external_id = $prefix . "" . $request->get('external_id');
            $grn->ref_external_id = $prefix . "" . $request->get('ref_extenal_id');
            $grn->trans_date = $request->get('trans_date');
            $grn->supplier_Id = $request->get('supplier_Id');
            $grn->received_by = 0;
            $grn->employee_name = $request->get('received_by');
            $grn->store_id = $request->get('store_id');
            $grn->supplier_ref_no = $request->get('supplier_ref_no');
            $grn->purchase_order_no = $request->get('purchase_order_no');
            $grn->customer_order_plan_data_id = $request->get('customer_order_plan_data_id');
            $grn->transport_by = $request->get('transport_by');
            $grn->vehicle_no = $request->get('vehicle_no');
            $grn->remarks = "";
            $grn->document_no = 100;
            $grn->user_id = Auth::user()->id;
            $grn->Status = 0;
            if ($grn->save()) {
                $grn = BagGrnHeader::find($grn->internal_id);
                $grn->ref_internal_id = $grn->internal_id;
                $grn->update();
                $grn_arr = $request->get("grn_data");
                for ($i = 0; $i < count($grn_arr); $i++) {
                    $grnData = json_decode($grn_arr[$i]);
                    $grn_data = new BagGrnData();
                    $grn_data->internal_id = $grn->internal_id;
                    $grn_data->external_id = $grn->external_id;
                    $grn_data->product_id =  $grnData->product_id;
                    $grn_data->unit_id =  $grnData->unit_id;
                    $grn_data->quantity =  $grnData->qty;
                    $grn_data->comments =  $grnData->comments;
                    $grn_data->save();
                }


                $attachmnet_token = $request->get("attachment_token");
                $attachments = BagGrnAttachment::where('token', '=', $attachmnet_token)->get();
                foreach ($attachments as $attachmnet) {
                    if ($attachmnet) {
                        $attachmnet->grn_id = $grn->internal_id;
                        $attachmnet->update();
                    }
                }
            }
            $responseBody = $this->responseBody(true, "GrnBagsHeaderController", "saveBagGrnHeaderTemp", $grn_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnBagsHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }








    public function getGrn($id)
    {
        try {
            $grn = BagGrnHeader::find($id);
            if (count(array_filter(explode("-", $grn->external_id))) == 2) {
                $grn->external_id = explode("-", $grn->external_id)[1];
            }
            $supplier = Suppliers::find($grn->supplier_Id);
            //$received = Employee::find($grn->received_by);
            //$grn->received = $received->name_withinitial;
            $grn->supplier = $supplier->supplier_name;
            $grn_data = BagGrnData::where('internal_id', '=', $id)->get();
            foreach ($grn_data as $data) {
                $product = Product::find($data->product_id);
                $data->product = $product->product_name;
                $uom = ProductUnit::find($data->unit_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
                
                $price = 0;
                $value = 0;
                $supplier_invoice_data = SupplierInvoiceData::where([['grn_internal_id','=',$data->internal_id],['product_id','=',$product->product_primary_id]])->first();
                //dd($data->product_id);
                
                if($supplier_invoice_data){
                    $price  =  $supplier_invoice_data->price;
                    $value  =  $supplier_invoice_data->value;
                }
                $data->price = $price;
                $data->value = $value;
            }
            $grn->data = $grn_data;
            $responseBody = $this->responseBody(true, "GrnBagsHeaderController", "getGrn", $grn);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnBagsHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function update(Request $request, $id)
    {

        try {
            $prefix = $this->getPrefix('510');
            if ($this->delete($id)) {
                $grn = BagGrnHeader::find($id);
                $grn->external_id = $prefix . "" . $request->get('external_id');
                $grn->ref_external_id = $prefix . "" . $request->get('ref_extenal_id');
                $grn->trans_date = $request->get('trans_date');
                $grn->supplier_Id = $request->get('supplier_Id');
                //$grn->received_by = $request->get('received_by');
                $grn->employee_name = $request->get('received_by');
                $grn->store_id = $request->get('store_id');
                $grn->supplier_ref_no = $request->get('supplier_ref_no');
                $grn->purchase_order_no = $request->get('purchase_order_no');
                $grn->customer_order_plan_data_id = $request->get('customer_order_plan_data_id');
                $grn->transport_by = $request->get('transport_by');
                $grn->vehicle_no = $request->get('vehicle_no');
                $grn->remarks = "";
                if ($grn->update()) {
                    $grn_arr = $request->get("grn_data");
                    if ($grn_arr) {
                        for ($i = 0; $i < count($grn_arr); $i++) {
                            $grnData = json_decode($grn_arr[$i]);
                            $grn_data = new BagGrnData();
                            $grn_data->internal_id = $grn->internal_id;
                            $grn_data->external_id = $grn->external_id;
                            $grn_data->product_id =  $grnData->product_id;
                            $grn_data->unit_id =  $grnData->unit_id;
                            $grn_data->quantity =  $grnData->qty;
                            $grn_data->comments =  $grnData->comments;
                            $grn_data->save();
                        }
                    }
                }


                $attachmnet_token = $request->get("attachment_token");
                $attachments = BagGrnAttachment::where('token', '=', $attachmnet_token)->get();
                foreach ($attachments as $attachmnet) {
                    if ($attachmnet) {
                        $attachmnet->grn_id = $grn->internal_id;
                        $attachmnet->update();
                    }
                }
            }

            $responseBody = $this->responseBody(true, "GrnBagsHeaderController", "update", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnBagsHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function change_status(Request $request, $id)
    {

        try {
            $grn_header = BagGrnHeader::find($id);
            $grn_header->status = $request->get('status');
            if ($grn_header->update()) {
                $this->addProductToSetoff($id);
            }

            $responseBody = $this->responseBody(true, "GrnBagsHeaderController", "change_status", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnBagsHeaderController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function delete($id)
    {
        try {
            $grn_data = BagGrnData::where('internal_id', '=', $id)->get();
            foreach ($grn_data as $data) {
                $data->delete();
            }
            return true;
        } catch (Exception $exception) {
            return false;
        }
    }



    private function addProductToSetoff($id)
    {
        $query = "SELECT sc_bags_grn_headers.document_no,
                    sc_bags_grn_headers.trans_date,
                    sc_bags_grn_headers.store_id,
                    sc_bags_grn_data.*
                    FROM sc_bags_grn_data 
                    INNER JOIN sc_bags_grn_headers
                    ON sc_bags_grn_data.internal_id = sc_bags_grn_headers.internal_id 
                    WHERE sc_bags_grn_data.internal_id = '" . $id . "' AND sc_bags_grn_headers.document_no = '100'";

        $result = DB::select($query);
        foreach ($result as $data) {

            // Check if already exists in product history
            $existing = ProductHistory::where('external_id', $data->external_id)
                ->where('product_id', $data->product_id)
                ->first();

            if ($existing) {
                continue; // Skip if already added
            }

            $product_history = new ProductHistory();
            $product_history->internal_id = $data->internal_id;
            $product_history->external_id = $data->external_id;
            $product_history->document_no = $data->document_no;
            $product_history->description = "Goods Received Bags";
            $product_history->product_id = $data->product_id;
            $product_history->unit_id = $data->unit_id;
            $product_history->quantity = $data->quantity;
            $product_history->set_off = 0;
            $product_history->cost_price = 0;
            $product_history->store_id = $data->store_id;
            $product_history->user_id = Auth::user()->id;
            $product_history->transaction_date = $data->trans_date;
            $product_history->save();

            // Also check for duplicate setoff
            $setoffExists = ProductHistorySetoff::where('external_id', $product_history->external_id)
                ->where('product_id', $product_history->product_id)
                ->exists();

            if (!$setoffExists) {
                $product_history_setoff = new ProductHistorySetOffController();
                $product_history_setoff->saveGoodsReceived($product_history);
            }
            
        }
    }



    private function removeProductFromSetoff($id)
    {
        $product_histories = ProductHistory::where('internal_id', '=', $id)->get();
        foreach ($product_histories as $data) {
            $data->delete();
        }
    }



    public function isApproved($id)
    {
        try {
            $grn = BagGrnHeader::find($id);
            if ($grn) {
                $responseBody = $this->responseBody(true, "GrnBagsHeaderController", "isApproved", $grn->status);
            }
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GrnBagsHeaderController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function getUom($id)
    {
        try {
            $product =  Product::where('product_primary_id', '=', $id)->first();

            $data = [
                "id" => "0",
                "value" => "",
            ];
            if ($product) {
                $uom =  ProductUnit::find($product->uom_id);
                if ($uom) {
                    $data["id"] = $uom->id;
                    $data["value"] = $uom->name;
                }
            }

            $responseBody = $this->responseBody(true, "PurchaseRequestController", "getUom", $data);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "PurchaseRequestController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function uploadAttachment(Request $request)
    {

        $id = $request->get('grn_id');
        $token = $request->get('attachmnet_token');
        $file = $request->file('file');
        $file_name = $file->getClientOriginalName();
        $filename = uniqid() . '_' . time() . '.' . $file_name;
        $filename = str_replace(' ','',str_replace('\'','',$filename));
        $file->move(public_path('grn'), $filename);

        $grn_attachment = new BagGrnAttachment();
        $grn_attachment->grn_id = 0;
        $grn_attachment->path = $filename;
        $grn_attachment->token = $token;
        return $grn_attachment->save();
    }



    public function allAttachment($id, $token)
    {
        try {

            $attachment = DB::select('SELECT *FROM sc_bags_grn_attachments WHERE  grn_id = "' . $id . '" OR token = "' . $token . '"');
            $responseBody = $this->responseBody(true, "allAttachment", "found", $attachment);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "allAttachment", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getPoFromSupplier($id)
    {
        try {

            $po = PurchaseOrderHeader::where('supplier_id', '=', $id)->get();
            $responseBody = $this->responseBody(true, "getPoFromSupplier", "found", $po);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "getPoFromSupplier", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    private function getPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
