<?php

namespace Modules\Sc\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Pp\Entities\Machinary;
use Modules\Sc\Entities\Department;
use Modules\Sc\Entities\BagMiData;
use Modules\Sc\Entities\BagMiHeader;
use Modules\Sc\Entities\BagMaterialReturnData;
use Modules\Sc\Entities\BagMaterialReturnHeader;
use Modules\Sc\Entities\ProductHistory;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Uom;

class MaterialReturnBagsListController extends Controller
{
    public function allMaterialReturn()
    {
        try {
           

            // $materialReturnList = DB::select("SELECT sc_product_histories.internal_id,
			// 	sc_bags_material_return_headers.external_id,
            //     sc_bags_material_return_headers.ref_external_id AS ref_external_id,
            //     sc_product_histories.external_id AS reference_no,
            //     sc_bags_material_return_headers.trans_date,
            //     sc_bags_material_return_headers.employee_name,
            //     sc_bags_material_return_headers.status
            // FROM sc_product_histories 
            // INNER JOIN sc_bags_mi_headers ON sc_product_histories.internal_id = sc_bags_mi_headers.internal_id
            // INNER JOIN sc_bags_material_return_headers ON sc_product_histories.internal_id = sc_bags_material_return_headers.internal_id
            // WHERE sc_product_histories.document_no = '550' 
            // GROUP BY sc_product_histories.external_id 
            // ORDER BY sc_product_histories.internal_id DESC");

            
            
            $materialReturnList = BagMaterialReturnHeader::select('*')->orderBy('internal_id', 'DESC')->get();   

            $responseBody = $this->responseBody(true, "MaterialReturnBagsListController", "allMaterialReturn", $materialReturnList);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnBagsListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function materialReturnReport($id)
    {
        try {
            $grn = BagMiHeader::find($id);

            $header = [
                "referance_no" => "",
                "date" => "",
                "supervisor" => "",
                "department" => "",
                "store" => "",
                "type" => "",
                "manufacturing_order_no" => "",
                "machine_no" => "",
            ];


            if ($grn) {
                $header["referance_no"] = $grn->external_id;
                $header["date"] = $grn->trans_date;
                $header["supervisor"] = $this->getSupervisor($grn->supervisor_id);
                $header["store"] = $this->getStore($grn->store_id);
                $header["department"] = $this->getDepartment($grn->dept_id);
                $header["type"] = $this->getType($grn->mi_type);
                $header["manufacturing_order_no"] = $grn->manufacturing_order_number;
                $header["machine_no"] = $this->getMachine($grn->machine_id);
            }

            $data = BagMiData::where('internal_id', '=', $id)->get();
            foreach ($data as $dd) {
                $product = Product::find($dd->product_id);
                $dd->product_id = $product->product_id;
                $dd->product = $product->product_name;
                $uom = ProductUnit::find($dd->unit_id);
                if ($uom) {
                    $dd->unit = $uom->name;
                } else {
                    $dd->unit = "";
                }

                $dd->quantity = 0;
                $history = ProductHistory::where([['internal_id', '=', $id], ['document_no', '=', '550'], ['product_id', '=', $product->product_id]])->get();
                foreach ($history as $hh) {

                    //$dd->quantity += $hh->quantity;
                }
            }


            $responseBody = $this->responseBody(true, "MaterialReturnBagsListController", "goodsReturnReport", ["header" => $header, "body" => ["data" => $data]]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MaterialReturnBagsListController", "goodsReturnReport", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    private function getSupervisor($id)
    {

        $employee = Employee::find($id);
        if ($employee) {
            return $employee->name_withinitial;
        }
        return "";
    }




    private function getDepartment($id)
    {

        $department = Department::find($id);
        if ($department) {
            return $department->department;
        }
        return "";
    }


    private function getStore($id)
    {
        $store = StoreLocation::find($id);
        if ($store) {
            return $store->name;
        }
        return "";
    }



    private function getType($id)
    {
        if ($id == 0) {
            return "General";
        } else if ($id == 1) {
            return "Production";
        } else if ($id == 2) {
            return "Maintenance";
        }
        return "";
    }



    private function getMachine($id)
    {
        $machine = Machinary::find($id);
        if ($machine) {
            return $machine->machinery_no;
        }
        return "";
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
