<?php

namespace Modules\Sc\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Pp\Entities\Machinary;
use Modules\Sc\Entities\Department;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Sc\Entities\BagMiData;
use Modules\Sc\Entities\BagMiHeader;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;
use Modules\St\Entities\Uom;

class MiBagsListController extends Controller
{
    public function allMaterialIssue()
    {
        try {
            $query = 'SELECT sc_bags_mi_headers.*,hr_employee_departments.department FROM sc_bags_mi_headers
            INNER JOIN hr_employee_departments ON sc_bags_mi_headers.dept_id = hr_employee_departments.department_id';
            //$miList = MiHeader::select('*')->orderBy('internal_id', 'DESC')->get();
            $miList = DB::select($query);
            $responseBody = $this->responseBody(true, "MiBagsListController", "allGrn", $miList);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MiBagsListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function materialIssueReport($id)
    {
        try {
            $mi_header = BagMiHeader::find($id);

            $header = [
                "referance_no" => "",
                "date" => "",
                "department" => "",
                "store" => "",
                "type" => "",
                "manufacturing_order" => "",
                "machine_no" => "",
                "supervisor" => "",
                "no_of_items" => "0.00",
                "ref_material_request_no" => "",
                "to_store" => "",
                "remarks" => "",
            ];


            if ($mi_header) {
                if ($mi_header->external_id) {
                    $header["referance_no"] = $mi_header->external_id;
                }
                if ($mi_header->trans_date) {
                    $header["date"] = $mi_header->trans_date;
                }
                if ($mi_header->ref_mr_id) {
                    $header["ref_material_request_no"] = $mi_header->ref_mr_id;
                }
                // if ($this->getSupervisor($mi_header->supervisor_id)) {
                //     $header["supervisor"] = $this->getSupervisor($mi_header->supervisor_id);
                // }
                if ($mi_header->employee_name) {
                    $header["supervisor"] = $mi_header->employee_name;
                }
                if ($this->getDepartment($mi_header->dept_id)) {
                    $header["department"] = $this->getDepartment($mi_header->dept_id);
                }
                if ($this->getStore($mi_header->store_id)) {
                    $header["store"] = $this->getStore($mi_header->store_id);
                }
                if ($this->getType($mi_header->mi_type)) {
                    $header["type"] = $this->getType($mi_header->mi_type);
                }
                if ($mi_header->manufacturing_order_number) {
                    $header["manufacturing_order"] = $mi_header->manufacturing_order_number;
                }
                if ($this->getMachine($mi_header->machine_id)) {
                    $header["machine_no"] = $this->getMachine($mi_header->machine_id);
                }
                if ($mi_header->to_store) {
                    $header["to_store"] = $mi_header->to_store;
                }
            }

            $data = BagMiData::where('internal_id', '=', $id)->get();
            $no_of_items = 0;
            foreach ($data as $dd) {
                $product = Product::find($dd->product_id);
                $dd->product_id = $product->product_id;
                $dd->product = $product->product_name;
                $uom = ProductUnit::find($dd->unit_id);
                $no_of_items+= $dd->quantity;
                if ($uom) {
                    $dd->unit = $uom->name;
                } else {
                    $dd->unit = "";
                }
            }
            $header["no_of_items"] = $no_of_items;


            $responseBody = $this->responseBody(true, "MiBagsListController", "materialRequisitionReport", ["header" => $header, "body" => ["data" => $data]]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MiBagsListController", "materialRequisitionReport", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    private function getSupervisor($id)
    {

        $supervisor = Employee::find($id);
        if ($supervisor) {
            return $supervisor->name_withinitial;
        }
        return "";
    }



    private function getDepartment($id)
    {

        // $department = Department::find($id);
        $department = EmployeeDepartment::find($id);
        if ($department) {
            return $department->department;
        }
        return "";
    }


    private function getStore($id)
    {
        $store = StoreLocation::find($id);
        if ($store) {
            return $store->name;
        }
        return "";
    }



    private function getType($id)
    {
        if ($id == 0) {
            return "General";
        } else if ($id == 1) {
            return "Production";
        } else if ($id == 2) {
            return "Project";
        } else if ($id == 3) {
            return "Transport";
        } else if ($id == 4) {
            return "Outside";
        }
        return "";
    }


    private function getMachine($id)
    {
        $machine = Machinary::find($id);
        if ($machine) {
            return $machine->machinery_no;
        }
        return "";
    }

    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
