<?php

namespace Modules\Sc\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\GoodsTransferData;
use Modules\Sc\Entities\ProductHistorySetoff;

class ProductHistorySetOffController extends Controller
{

    public function saveGoodsReceived($product_history)
    {

        //$prefix = $this->getPrefix($product_history->document_no);

        $setoff = new ProductHistorySetoff();
        $setoff->document_no = $product_history->document_no;
        $setoff->internal_id = $product_history->internal_id;
        $setoff->external_id = $product_history->external_id;
        $setoff->ref_internal_id = $product_history->internal_id;
        $setoff->ref_external_id = $product_history->external_id;
        $setoff->ref_document_no = $product_history->document_no;
        $setoff->quantity = $product_history->quantity;
        $setoff->setoff_quantity = 0;
        $setoff->cost_price = 0;
        $setoff->grn_internal_id = $product_history->internal_id;
        $setoff->grn_external_id = $product_history->external_id;
        $setoff->product_id = $product_history->product_id;
        $setoff->store_id = $product_history->store_id;
        $setoff->user_id = $product_history->user_id;
        $setoff->save();
    }




    public function saveGoodsReceivedmr($product_history)
    {

        //$prefix = $this->getPrefix($product_history->document_no);

        $setoff = new ProductHistorySetoff();
        $setoff->document_no = $product_history->document_no;
        $setoff->internal_id = $product_history->internal_id;
        $setoff->external_id = $product_history->external_id;
        $setoff->ref_internal_id = $product_history->internal_id;
        $setoff->ref_external_id = $product_history->external_id;
        $setoff->ref_document_no = $product_history->document_no;
        $setoff->quantity = $product_history->quantity;
        $setoff->setoff_quantity = 0;
        $setoff->cost_price = 0;
        $setoff->grn_internal_id = $product_history->internal_id;
        $setoff->grn_external_id = $product_history->external_id;
        $setoff->product_id = $product_history->product_id;
        $setoff->store_id = $product_history->store_id;
        $setoff->user_id = $product_history->user_id;
        $setoff->save();
    }




    public function saveGoodsTransferFromStore($product_history, $from_store, $to_store)
    {
        $this->setoffGoodsTransferFrom($product_history, $from_store, $to_store);
    }


    public function updateGoodsTransferFromStore($product_history, $from_store, $to_store)
    {
        $this->updateSetoffGoodsTransfer($product_history, $from_store, $to_store);
    }



    public function saveGoodsTransferMR($product_history, $from_store, $to_store)
    {
        $this->setoffGoodsTransferMR($product_history, $from_store, $to_store);
    }


    public function updateGoodsTransferMR($product_history, $from_store, $to_store)
    {
        $this->updateSetoffGoodsTransferMR($product_history, $from_store, $to_store);
    }






    private function setoffGoodsTransferFrom($setoff_from, $from_store, $to_store)
    {
        $query = 'SELECT * from sc_product_history_setoffs  WHERE  quantity-setoff_quantity >0 AND product_id = "' . $setoff_from->product_id . '" AND store_id = "' . $setoff_from->store_id . '" AND quantity-setoff_quantity > 0 ORDER BY transaction_id ASC';
        $product_history_grn_setoff = DB::select($query);
        $request_quantity = 0;
        $remain_quantity = abs($setoff_from->quantity);
        foreach ($product_history_grn_setoff as $grn_setoff) {



            $available_quantity = ($grn_setoff->quantity - $grn_setoff->setoff_quantity);
            if ($remain_quantity < $available_quantity) {
                $this->addNewGoodsTransferSetoff($grn_setoff, $setoff_from->internal_id, $setoff_from->external_id, $from_store, ($remain_quantity * -1));
                $this->addNewGoodsTransferSetoff($grn_setoff, $setoff_from->internal_id, $setoff_from->external_id, $to_store, abs($remain_quantity));
                $this->setoff($grn_setoff->transaction_id, $remain_quantity);
                break;
            } else {
                $remain_quantity = $remain_quantity - $available_quantity;
                $this->addNewGoodsTransferSetoff($grn_setoff, $setoff_from->internal_id, $setoff_from->external_id, $from_store, ($available_quantity * -1));
                $this->addNewGoodsTransferSetoff($grn_setoff, $setoff_from->internal_id, $setoff_from->external_id, $to_store, abs($available_quantity));
                $this->setoff($grn_setoff->transaction_id, $available_quantity);
            }

            if ($remain_quantity == 0) {
                break;
            }
        }
    }






    private function setoffGoodsTransferMR($setoff_from, $from_store, $to_store)
    {
        $query = 'SELECT * from sc_product_history_setoffs  WHERE  quantity-setoff_quantity >0 AND product_id = "' . $setoff_from->product_id . '" AND store_id = "' . $setoff_from->store_id . '" AND quantity-setoff_quantity > 0 ORDER BY transaction_id ASC';
        $product_history_grn_setoff = DB::select($query);
        $request_quantity = 0;
        $remain_quantity = abs($setoff_from->quantity);
        foreach ($product_history_grn_setoff as $grn_setoff) {



            $available_quantity = ($grn_setoff->quantity - $grn_setoff->setoff_quantity);
            if ($remain_quantity < $available_quantity) {
                $this->addNewGoodsTransferMRSetoff($grn_setoff, $setoff_from->internal_id, $setoff_from->external_id, $from_store, ($remain_quantity * -1));
                $this->addNewGoodsTransferMRSetoff($grn_setoff, $setoff_from->internal_id, $setoff_from->external_id, $to_store, abs($remain_quantity));
                $this->setoff($grn_setoff->transaction_id, $remain_quantity);
                break;
            } else {
                $remain_quantity = $remain_quantity - $available_quantity;
                $this->addNewGoodsTransferMRSetoff($grn_setoff, $setoff_from->internal_id, $setoff_from->external_id, $from_store, ($available_quantity * -1));
                $this->addNewGoodsTransferMRSetoff($grn_setoff, $setoff_from->internal_id, $setoff_from->external_id, $to_store, abs($available_quantity));
                $this->setoff($grn_setoff->transaction_id, $available_quantity);
            }

            if ($remain_quantity == 0) {
                break;
            }
        }
    }




    private function updateSetoffGoodsTransfer($setoff_from, $from_store, $to_store)
    {
        $this->setoffGoodsTransferFrom($setoff_from, $from_store, $to_store);
    }



    private function updateSetoffGoodsTransferMR($setoff_from, $from_store, $to_store)
    {
        $this->setoffGoodsTransferMR($setoff_from, $from_store, $to_store);
    }




    public function saveMaterialIssue($product_history)
    {
        $this->setoffMaterialIssue($product_history);
    }


    public function updateMaterialIssue($product_history)
    {
        $this->updateSetoffMaterialIssue($product_history);
    }








    private function setoffMaterialIssue($setoff_mi)
    {
        $query = 'SELECT * from sc_product_history_setoffs  WHERE product_id = "' . $setoff_mi->product_id . '" AND store_id = "' . $setoff_mi->store_id . '" AND quantity-setoff_quantity > 0 ORDER BY transaction_id ASC';
        $product_history_mi_setoff = DB::select($query);
        $remain_quantity = abs($setoff_mi->quantity);
        foreach ($product_history_mi_setoff as $mi_setoff) {



            $available_quantity = ($mi_setoff->quantity - $mi_setoff->setoff_quantity);
            if ($remain_quantity < $available_quantity) {
                $this->addNewMaterialIssueSetoff($mi_setoff, $setoff_mi->internal_id, $setoff_mi->external_id, $setoff_mi->store_id, ($remain_quantity * -1));
                $this->setoff($mi_setoff->transaction_id, $remain_quantity);
                break;
            } else {
                $remain_quantity = $remain_quantity - $available_quantity;
                $this->addNewMaterialIssueSetoff($mi_setoff, $setoff_mi->internal_id, $setoff_mi->external_id, $setoff_mi->store_id, ($available_quantity * -1));
                $this->setoff($mi_setoff->transaction_id, $available_quantity);
            }

            if ($remain_quantity == 0) {
                break;
            }
        }
    }





    public function saveMaterialReturn($product_history)
    {
        $this->setoffMaterialReturn($product_history);
    }


    private function setoffMaterialReturn($setoff_mr)
    {
        $query = 'SELECT * from sc_product_history_setoffs  WHERE product_id = "' . $setoff_mr->product_id . '" AND store_id = "' . $setoff_mr->store_id . '" AND quantity-setoff_quantity > 0 ORDER BY transaction_id ASC';
        $product_history_mi_setoff = DB::select($query);
        $remain_quantity = abs($setoff_mr->quantity);
        foreach ($product_history_mi_setoff as $mi_setoff) {



            $available_quantity = ($mi_setoff->quantity - $mi_setoff->setoff_quantity);
            if ($remain_quantity < $available_quantity) {
                $this->addNewMaterialReturnSetoff($mi_setoff, $setoff_mr->internal_id, $setoff_mr->external_id, $setoff_mr->store_id, ($remain_quantity * -1));
                $this->setoffReturn($mi_setoff->transaction_id, $remain_quantity);
                break;
            } else {
                $remain_quantity = $remain_quantity - $available_quantity;
                $this->addNewMaterialReturnSetoff($mi_setoff, $setoff_mr->internal_id, $setoff_mr->external_id, $setoff_mr->store_id, ($available_quantity * -1));
                $this->setoffReturn($mi_setoff->transaction_id, $available_quantity);
            }

            if ($remain_quantity == 0) {
                break;
            }
        }
    }











    private function updateSetoffMaterialIssue($setoff_from)
    {
        /*$query = 'SELECT * from sc_product_history_setoffs  WHERE  product_id = "' . $setoff_from->product_id . '" AND store_id = "' . $setoff_from->store_id . '"  ORDER BY transaction_id ASC';
        $product_history_mi_setoff = DB::select($query);

        foreach ($product_history_mi_setoff as $mi_setoff) {
            $internal_id = $mi_setoff->ref_internal_id;
            $external_id = $mi_setoff->ref_external_id;
            $document_no = $mi_setoff->ref_document_no;
            $store_id = $mi_setoff->store_id;

            $setoff = ProductHistorySetoff::where([['internal_id', '=', $internal_id], ['external_id', '=', $external_id], ['document_no', '=', $document_no], ['store_id', '=', $store_id]])->first();
            if ($setoff) {
                //$setoff->setoff_quantity = $setoff->setoff_quantity - $mi_setoff->quantity;
                if (($setoff->setoff_quantity - $mi_setoff->quantity) > 0) {
                    $setoff->setoff_quantity = $setoff->setoff_quantity - $mi_setoff->quantity;
                } else {
                    $setoff->setoff_quantity = 0;
                }
                $setoff->update();
            }
        }*/

        $this->setoffMaterialIssue($setoff_from);
    }


    private function setoff($history_setoff_transaction_id, $setoff_quantity)
    {
        $history_setoff = ProductHistorySetoff::find($history_setoff_transaction_id);
        if ($history_setoff) {
            $history_setoff->setoff_quantity += abs($setoff_quantity);
            $history_setoff->update();
        }
    }


    private function setoffReturn($history_setoff_transaction_id, $setoff_quantity)
    {
        $history_setoff = ProductHistorySetoff::find($history_setoff_transaction_id);
        if ($history_setoff) {
            $history_setoff->setoff_quantity -= abs($setoff_quantity);
            $history_setoff->update();
        }
    }


    private function updateSetoff($history_setoff_transaction_id, $setoff_quantity)
    {
        $history_setoff = ProductHistorySetoff::find($history_setoff_transaction_id);
        if ($history_setoff) {
            $history_setoff->setoff_quantity = abs($setoff_quantity);
            $history_setoff->update();
        }
    }








    private function getPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }



    private function addNewGoodsTransferSetoff($product_history, $internal_id, $external_id, $store_id, $qty)
    {
        $setoff_from = new ProductHistorySetoff();
        $setoff_from->document_no = '210';
        $setoff_from->internal_id =  $internal_id;
        $setoff_from->external_id = $external_id;
        $setoff_from->ref_internal_id = $product_history->internal_id;
        $setoff_from->ref_external_id = $product_history->external_id;
        $setoff_from->ref_document_no = $product_history->document_no;
        $setoff_from->quantity = $qty;
        $setoff_from->setoff_quantity = 0;
        $setoff_from->cost_price = 0;
        $setoff_from->grn_internal_id = $product_history->grn_internal_id;
        $setoff_from->grn_external_id = $product_history->grn_external_id;
        $setoff_from->product_id = $product_history->product_id;
        $setoff_from->store_id = $store_id;
        $setoff_from->user_id = $product_history->user_id;
        $setoff_from->save();
    }




    private function addNewGoodsTransferMRSetoff($product_history, $internal_id, $external_id, $store_id, $qty)
    {
        $setoff_from = new ProductHistorySetoff();
        $setoff_from->document_no = '410';
        $setoff_from->internal_id =  $internal_id;
        $setoff_from->external_id = $external_id;
        $setoff_from->ref_internal_id = $product_history->internal_id;
        $setoff_from->ref_external_id = $product_history->external_id;
        $setoff_from->ref_document_no = $product_history->document_no;
        $setoff_from->quantity = $qty;
        $setoff_from->setoff_quantity = 0;
        $setoff_from->cost_price = 0;
        $setoff_from->grn_internal_id = $product_history->grn_internal_id;
        $setoff_from->grn_external_id = $product_history->grn_external_id;
        $setoff_from->product_id = $product_history->product_id;
        $setoff_from->store_id = $store_id;
        $setoff_from->user_id = $product_history->user_id;
        $setoff_from->save();
    }






    private function addNewMaterialIssueSetoff($product_history, $internal_id, $external_id, $store_id, $qty)
    {
        $setoff_from = new ProductHistorySetoff();
        $setoff_from->document_no = '200';
        $setoff_from->internal_id =  $internal_id;
        $setoff_from->external_id = $external_id;
        $setoff_from->ref_internal_id = $product_history->internal_id;
        $setoff_from->ref_external_id = $product_history->external_id;
        $setoff_from->ref_document_no = $product_history->document_no;
        $setoff_from->quantity = $qty;
        $setoff_from->setoff_quantity = 0;
        $setoff_from->cost_price = 0;
        $setoff_from->grn_internal_id = $product_history->grn_internal_id;
        $setoff_from->grn_external_id = $product_history->grn_external_id;
        $setoff_from->product_id = $product_history->product_id;
        $setoff_from->store_id = $store_id;
        $setoff_from->user_id = $product_history->user_id;
        $setoff_from->save();
    }




    private function addNewMaterialReturnSetoff($product_history, $internal_id, $external_id, $store_id, $qty)
    {
        $setoff_from = new ProductHistorySetoff();
        $setoff_from->document_no = '230';
        $setoff_from->internal_id =  $internal_id;
        $setoff_from->external_id = $external_id;
        $setoff_from->ref_internal_id = $product_history->internal_id;
        $setoff_from->ref_external_id = $product_history->external_id;
        $setoff_from->ref_document_no = $product_history->document_no;
        $setoff_from->quantity = abs($qty);
        $setoff_from->setoff_quantity = 0;
        $setoff_from->cost_price = 0;
        $setoff_from->grn_internal_id = $product_history->grn_internal_id;
        $setoff_from->grn_external_id = $product_history->grn_external_id;
        $setoff_from->product_id = $product_history->product_id;
        $setoff_from->store_id = $store_id;
        $setoff_from->user_id = $product_history->user_id;
        $setoff_from->save();
    }
}
