<?php

namespace Modules\Sc\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Sc\Entities\MaterialRequestReason;
use Modules\Sc\Entities\OrderType;
use Modules\Sc\Entities\PayTerm;
use Modules\Sc\Entities\StoreLocation;

class SettingsController extends Controller
{


    public function allStores()
    {
        try {
            $result = SettingsController::allSettings('Stores');
            foreach ($result as $store) {
                $store->site = EmployeeSite::find($store->site_id)->site;
            }
            $responseBody = $this->responseBody(true, "Stores", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Stores", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allSite()
    {
        try {
            $result = SettingsController::allSettings('Site');
            $responseBody = $this->responseBody(true, "Site", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Site", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    public static function allSettings($name)
    {

        if ($name == 'Stores') {
            return StoreLocation::all();
        } else if ($name == 'Site') {
            return EmployeeSite::all();
        }
    }


    public function disableStores(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("store_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Stores", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }

            $value = $request->get('status');

            $object = StoreLocation::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Stores", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Stores", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    private function isAssigned($setting_column, $setting_id)
    {

        $setting = DB::table('sc_grn_headers')->where($setting_column, $setting_id)->first();
        $setting2 = DB::table('sc_mi_headers')->where($setting_column, $setting_id)->first();
        if ($setting || $setting2) {
            return true;
        }
        return false;
    }





    public function disableOrderType(Request $request, $id)
    {
        try {
            $value = $request->get('status');
            $object = OrderType::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "disableOrderType", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "disableOrderType", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function disableMaterialRequestReason(Request $request, $id)
    {
        try {
            $value = $request->get('status');
            $object = MaterialRequestReason::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "disableMaterialRequestReason", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "disableMaterialRequestReason", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function disablePayTerm(Request $request, $id)
    {
        try {
            $value = $request->get('status');
            $object = PayTerm::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "disablePayTerm", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "disablePayTerm", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }







    public function saveStores(Request $request)
    {

        try {
            $object = new StoreLocation();
            $object->name = $request->get('store');
            $object->prefix = $request->get('prefix');
            $object->site_id = $request->get('site');
            $object->store_code = $request->get('code');
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Stores", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Stores", $exception, null);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function updateStores(Request $request, $id)
    {

        try {
            $object = StoreLocation::find($id);
            $object->name = $request->get('store');
            $object->prefix = $request->get('prefix');
            $object->site_id = $request->get('site');
            $object->store_code = $request->get('code');
            $update = $object->update();
            if ($update) {
                $responseBody = $this->responseBody(true, "Stores", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Stores", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function updateMaterialRequestReason(Request $request, $id)
    {

        try {
            $reason = MaterialRequestReason::find($id);
            $reason->reason = $request->get('value');
            $reason->update();
            $responseBody = $this->responseBody(true, "SettingsController", "updateMaterialRequestReason", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function savePayTerm(Request $request)
    {
        try {
            $object = new PayTerm();
            $object->pay_term = $request->get('value');
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "savePayTerm", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "savePayTerm", $exception, null);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function saveOrderType(Request $request)
    {
        try {
            $object = new OrderType();
            $object->order_type = $request->get('value');
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "saveOrderType", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "saveOrderType", $exception, null);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function saveMaterialRequestReason(Request $request)
    {
        try {
            $object = new MaterialRequestReason();
            $object->reason = $request->get('value');
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "saveMaterialRequestReason", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "saveMaterialRequestReason", $exception, null);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function getAllStores()
    {
        try {
            $stores = StoreLocation::all();
            $responseBody = $this->responseBody(true, "SettingsController", "getAllStores", $stores);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getAllPayTerm()
    {
        try {
            $pay_terms = PayTerm::all();
            $responseBody = $this->responseBody(true, "SettingsController", "getAllPayTerm", $pay_terms);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getAllOrderType()
    {
        try {
            $order_types = OrderType::all();
            $responseBody = $this->responseBody(true, "SettingsController", "getAllOrderType", $order_types);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function getAllMaterialRequestReason()
    {
        try {
            $reasons = MaterialRequestReason::all();
            $responseBody = $this->responseBody(true, "SettingsController", "getAllMaterialRequestReason", $reasons);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function getOrderType($id)
    {
        try {
            $order_type = OrderType::find($id);
            $responseBody = $this->responseBody(true, "SettingsController", "getOrderType", $order_type);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getStore($id)
    {
        try {
            $store = StoreLocation::find($id);
            $responseBody = $this->responseBody(true, "SettingsController", "getStore", $store);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getMaterialRequestReason($id)
    {
        try {
            $reason = MaterialRequestReason::find($id);
            $responseBody = $this->responseBody(true, "SettingsController", "getMaterialRequestReason", $reason);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getPayTerm($id)
    {
        try {
            $pay_term = PayTerm::find($id);
            $responseBody = $this->responseBody(true, "SettingsController", "getPayTerm", $pay_term);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function updatePayTerm(Request $request, $id)
    {
        try {
            $pay_term = PayTerm::find($id);
            $pay_term->pay_term = $request->get('value');
            $pay_term->update();
            $responseBody = $this->responseBody(true, "SettingsController", "updatePayTerm", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function updateOrderType(Request $request, $id)
    {
        try {
            $order_type = OrderType::find($id);
            $order_type->order_type = $request->get('value');
            $order_type->update();
            $responseBody = $this->responseBody(true, "SettingsController", "updateOrderType", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SettingsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }







    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
