
var setting_array = {
    "site": null,
    "stores": null,
    "producttype": null,
    "grouplevel1": null,
    "grouplevel2": null,
    "grouplevel3": null,
    "without0": null,
    "productname": null,
    "supplier_type": null,
};

var REPORT_ID = 0;

$(document).ready(function () {
    $('#selcProductName').select2();
    
    allSettings();
    supplierType();
    showDate('hide');
    $('#selcSite').prop("disabled", true);
    $('#selcStores').prop("disabled", true);
    $('#selcProductType').prop("disabled", true);
    $('#selcProductGroupLevel1').prop("disabled", true);
    $('#selcProductGroupLevel2').prop("disabled", true);
    $('#selcProductGroupLevel3').prop("disabled", true);
    $('#selcSupplierType').prop("disabled", true);
    $('#selcWithout0').prop("disabled", true);
    $('#selcProductName').prop("disabled", true);

    $('input[name="startDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    $('input[name="endDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });




    $('#checkSiteSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcSite').prop("disabled", false);
            setting_array.site = $('#selcSite').val();
        } else {
            $('#selcSite').prop("disabled", true);
            setting_array.site = null;
        }
        //switch_settings('checkSiteSearch');
    });


    $('#checkStoresSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcStores').prop("disabled", false);
            setting_array.stores = $('#selcStores').val();
        } else {
            $('#selcStores').prop("disabled", true);
            setting_array.stores = null;
        }
        //switch_settings('checkDepartmentSearch');
    });


    $('#checkProductTypeSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductType').prop("disabled", false);
            var value = $('#selcSection').val();
            setting_array.producttype = $('#selcProductType').val();
            allSubsection(value);
        } else {
            $('#selcProductType').prop("disabled", true);
            setting_array.producttype = null;
        }
        //switch_settings('checkSectionSearch');
    });





    $('#checkProductGroupLevel1Search').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductGroupLevel1').prop("disabled", false);
            setting_array.grouplevel1 = $('#selcProductGroupLevel1').val();
        } else {
            $('#selcProductGroupLevel1').prop("disabled", true);
            setting_array.grouplevel1 = null;
        }
        //switch_settings('checkCompanySearch');
    });


    $('#checkProductGroupLevel2Search').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductGroupLevel2').prop("disabled", false);
            setting_array.grouplevel2 = $('#selcProductGroupLevel2').val();
        } else {
            $('#selcProductGroupLevel2').prop("disabled", true);
            setting_array.grouplevel2 = null;
        }
        //switch_settings('checkTeamSearch');

    });


    $('#checkProductGroupLevel3Search').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductGroupLevel3').prop("disabled", false);
            setting_array.grouplevel3 = $('#selcProductGroupLevel3').val();
        } else {
            $('#selcProductGroupLevel3').prop("disabled", true);
            setting_array.grouplevel3 = null;
        }
        //switch_settings('checkTeamSearch');

    });


    $('#checkSupplierTypeSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcSupplierType').prop("disabled", false);
            setting_array.supplier_type = $('#selcSupplierType').val();
        } else {
            $('#selcSupplierType').prop("disabled", true);
            setting_array.supplier_type = null;
        }
        //switch_settings('checkTeamSearch');

    });


    $('#checkWithout0').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcWithout0').prop("disabled", false);
            setting_array.without0 = $('#selcWithout0').val();
        } else {
            $('#selcWithout0').prop("disabled", true);
            setting_array.without0 = null;
        }
        //switch_settings('checkTeamSearch');

    });


    $('#checkProductName').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductName').prop("disabled", false);
            setting_array.productname = $('#selcProductName').val();
        } else {
            $('#selcProductName').prop("disabled", true);
            setting_array.productname = null;
        }
        //switch_settings('checkTeamSearch');

    });


    $('#selcSite').change(function () {
        setting_array.site = $('#selcSite').val();
    });

    $('#selcStores').change(function () {
        setting_array.stores = $('#selcStores').val();
    });

    $('#selcProductType').change(function () {
        setting_array.producttype = $('#selcProductType').val();
    });

    $('#selcProductGroupLevel1').change(function () {
        setting_array.grouplevel1 = $('#selcProductGroupLevel1').val();
    });

    $('#selcProductGroupLevel2').change(function () {
        setting_array.grouplevel2 = $('#selcProductGroupLevel2').val();
    });

    $('#selcProductGroupLevel3').change(function () {
        setting_array.grouplevel3 = $('#selcProductGroupLevel3').val();
    });

    $('#selcSupplierType').change(function () {
        setting_array.supplier_type = $('#selcSupplierType').val();
    });

    $('#selcWithout0').change(function () {
        setting_array.without0 = $('#selcWithout0').val();
    });

    $('#selcProductName').change(function () {
        setting_array.productname = $('#selcProductName').val();
    });

    $('#cmbReport').change(function () {
        showAllFilters();
        REPORT_ID = $(this).val();
        $('#lblEmployee').text('Employee');
        if (REPORT_ID == 1) {

            $('#divSupplierType').hide();
            showDate('DATE_RANGE');

        } if (REPORT_ID == 2) {

            $('#divSupplierType').hide();
            showDate('DATE_RANGE');

        } else if (REPORT_ID == 3) {

            $('#divSupplierType').hide();
            showDate('SINGLE_DATE');

        } else if (REPORT_ID == 4) {

            $('#divStore').hide();
            $('#divSupplierType').hide();
            $('#divWithout0').hide();
            showDate('DATE_RANGE');

        } else if (REPORT_ID == 5) {

            $('#divStore').hide();
            $('#divSupplierType').hide();
            $('#divWithout0').hide();
            showDate('DATE_RANGE');

        } else if (REPORT_ID == 6) {

            $('#divStore').hide();
            $('#divSupplierType').hide();
            $('#divWithout0').hide();
            showDate('DATE_RANGE');

        } else if (REPORT_ID == 7) {
            $('#divStore').hide();
            $('#divProductType').hide();
            $('#divGroupLevel1').hide();
            $('#divGroupLevel2').hide();
            $('#divGroupLevel3').hide();
            $('#divWithout0').hide();
            $('#divProductName').hide();
            showDate('DATE_HIDE');

        } else if (REPORT_ID == 8) {

            $('#divStore').hide();
            $('#divSupplierType').hide();
            $('#divWithout0').hide();
            showDate('DATE_RANGE');

        }
         else {
            showDate('DATE_RANGE');
        }
    });

    $('#selcProductGroupLevel1').on('change', function () {
        $('#selcProductGroupLevel2').prop("disabled", true);
        $('#selcProductGroupLevel3').prop("disabled", true);
        $('#checkProductGroupLevel2Search').prop('checked', false);
        $('#checkProductGroupLevel3Search').prop('checked', false);
        category_level2($(this).val());
    });

    $('#selcProductGroupLevel2').on('change', function () {
        $('#selcProductGroupLevel3').prop("disabled", true);
        $('#checkProductGroupLevel3Search').prop('checked', false);
        category_level3($(this).val());
    });

});


function allSettings() {

    $.ajax({
        type: "GET",
        url: "/sc/StockValuationBagsReportController/allSettings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var settings = response.data.result.settings;
                appendOption("selcSite", settings.site);
                appendOption("selcStores", settings.stores);
                appendOption("selcProductType", settings.producttype);
                appendOption("selcProductGroupLevel1", settings.grouplevel1);
                $('#selcProductGroupLevel1').trigger('change');
                //appendOption("selcProductGroupLevel2", settings.grouplevel2);
                //appendOption("selcProductGroupLevel3", settings.grouplevel3);
                appendOption("selcProductName", settings.productname);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}


function category_level2(category_level1) {

    $.ajax({
        type: "GET",
        url: "/sc/StockValuationBagsReportController/category_level2/" + category_level1,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            $('#selcProductGroupLevel2').empty();
            $('#selcProductGroupLevel2').append('<option value="disabled" disabled selected>Select here</option>');
            for (var i = 0; i < response.length; i++) {
                $('#selcProductGroupLevel2').append('<option value="' + response[i].group_level_2_id + '">' + response[i].group_level_2 + '</option>')
            }
            $('#selcProductGroupLevel2').trigger('change');
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function category_level3(category_level2) {

    $.ajax({
        type: "GET",
        url: "/sc/StockValuationBagsReportController/category_level3/" + category_level2,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            $('#selcProductGroupLevel3').empty();
            $('#selcProductGroupLevel3').append('<option value="disabled" disabled selected>Select here</option>');
            for (var i = 0; i < response.length; i++) {
                $('#selcProductGroupLevel3').append('<option value="' + response[i].group_level_3_id + '">' + response[i].group_level_3 + '</option>')
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function supplierType() {

    $.ajax({
        type: "GET",
        url: "/sc/StockValuationBagsReportController/supplier_type",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            $('#selcSupplierType').empty();
            $('#selcSupplierType').append('<option value="disabled" disabled selected>Select here</option>');
            for (var i = 0; i < response.length; i++) {
                $('#selcSupplierType').append('<option value="' + response[i].supplier_type_id + '">' + response[i].supplier_type + '</option>')
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function appendOption(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].id + '">' + result[i].value + '</option>');
    }
}








function settings() {

    return "site=" + setting_array.site + "&"
        + "stores=" + setting_array.stores + "&"
        + "producttype=" + setting_array.producttype + "&"
        + "grouplevel1=" + setting_array.grouplevel1 + "&"
        + "grouplevel2=" + setting_array.grouplevel2 + "&"
        + "grouplevel3=" + setting_array.grouplevel3 + "&"
        + "without0=" + setting_array.without0 + "&"
        + "productname=" + setting_array.productname;
}


function createReport(flag) {





    if (REPORT_ID == 0) {
        showWarningMessage("Please select Report title");
        return;
    }



    if (REPORT_ID == 1) {

        if (setting_array.site == null && setting_array.stores == null && setting_array.producttype == null && setting_array.grouplevel1 == null && setting_array.grouplevel2 == null && setting_array.grouplevel3 == null && setting_array.without0 == null && setting_array.productname == null) {
            showWarningMessage("Please select setting");
            return;
        }

        $.ajax({
            type: "GET",
            url: "/sc/StockValuationBagsReportController/stockValuationAverageReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                var result = response.data.result;
                console.log(result);
                stockValuationAverageReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    }
    // else if (REPORT_ID == 2) {

    //     if (setting_array.site == null && setting_array.stores == null && setting_array.producttype == null && setting_array.grouplevel1 == null && setting_array.grouplevel2 == null && setting_array.grouplevel3 == null && setting_array.without0 == null && setting_array.productname == null) {
    //         showWarningMessage("Please select setting");
    //         return;
    //     }

    //     $.ajax({
    //         type: "GET",
    //         url: "/sc/StockValuationBagsReportController/showStockValuationBatchWiseReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
    //         processData: false,
    //         contentType: false,
    //         cache: false,
    //         timeout: 800000,
    //         beforeSend: function () {
    //             $('.btn').prop("disabled", true);
    //             document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
    //         },
    //         success: function (response) {
    //             var result = response.data.result;
    //             console.log(result);
    //             stockValuationBatchWiseReport(result, flag);

    //         },
    //         error: function (error) {
    //             console.log(error);
    //             showErrorMessage();

    //         },
    //         complete: function () {
    //             $('#btnPrint').text('Print');
    //             $('.btn').prop("disabled", false);
    //         }

    //     });

    // } else if (REPORT_ID == 3) {

    //     if (setting_array.site == null && setting_array.stores == null && setting_array.producttype == null && setting_array.grouplevel1 == null && setting_array.grouplevel2 == null && setting_array.grouplevel3 == null && setting_array.without0 == null && setting_array.productname == null) {
    //         showWarningMessage("Please select setting");
    //         return;
    //     }

    //     $.ajax({
    //         type: "GET",
    //         url: "/sc/StockValuationBagsReportController/stockValuationAverageAsAtReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
    //         processData: false,
    //         contentType: false,
    //         cache: false,
    //         timeout: 800000,
    //         beforeSend: function () {
    //             $('.btn').prop("disabled", true);
    //             document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
    //         },
    //         success: function (response) {
    //             var result = response.data.result;
    //             console.log(result);
    //             stockValuationAverageAsAtReport(result, flag);

    //         },
    //         error: function (error) {
    //             console.log(error);
    //             showErrorMessage();

    //         },
    //         complete: function () {
    //             $('#btnPrint').text('Print');
    //             $('.btn').prop("disabled", false);
    //         }

    //     });

    // }
    else if (REPORT_ID == 4) {


        $.ajax({
            type: "GET",
            url: "/sc/StockValuationBagsReportController/grnReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                var result = response.data.result;
                console.log(result);
                grnReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    } else if (REPORT_ID == 5) {

        $.ajax({
            type: "GET",
            url: "/sc/StockValuationBagsReportController/ginReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                var result = response.data.result;
                console.log(result);
                ginReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    } else if (REPORT_ID == 6) {

        $.ajax({
            type: "GET",
            url: "/sc/StockValuationBagsReportController/goodTransferReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                var result = response.data.result;
                console.log(result);
                goodTransferReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    }
    // else if (REPORT_ID == 7) {

    //     $.ajax({
    //         type: "GET",
    //         url: "/sc/StockValuationReportController/supplierListReport/" + JSON.stringify(setting_array),
    //         processData: false,
    //         contentType: false,
    //         cache: false,
    //         timeout: 800000,
    //         beforeSend: function () {
    //             $('.btn').prop("disabled", true);
    //             document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
    //         },
    //         success: function (response) {
    //             var result = response.data.result;
    //             console.log(result);
    //             supplierListReport(result, flag);

    //         },
    //         error: function (error) {
    //             console.log(error);
    //             showErrorMessage();

    //         },
    //         complete: function () {
    //             $('#btnPrint').text('Print');
    //             $('.btn').prop("disabled", false);
    //         }

    //     });

    // } else if (REPORT_ID == 8) {

    //     $.ajax({
    //         type: "GET",
    //         url: "/sc/StockValuationReportController/grnMrReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
    //         processData: false,
    //         contentType: false,
    //         cache: false,
    //         timeout: 800000,
    //         beforeSend: function () {
    //             $('.btn').prop("disabled", true);
    //             document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
    //         },
    //         success: function (response) {
    //             var result = response.data.result;
    //             console.log(result);
    //             grnMrReport(result, flag);

    //         },
    //         error: function (error) {
    //             console.log(error);
    //             showErrorMessage();

    //         },
    //         complete: function () {
    //             $('#btnPrint').text('Print');
    //             $('.btn').prop("disabled", false);
    //         }

    //     });

    // } else if (REPORT_ID == 9) {

    //     $.ajax({
    //         type: "GET",
    //         url: "/sc/StockValuationReportController/mIssueMrReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
    //         processData: false,
    //         contentType: false,
    //         cache: false,
    //         timeout: 800000,
    //         beforeSend: function () {
    //             $('.btn').prop("disabled", true);
    //             document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
    //         },
    //         success: function (response) {
    //             var result = response.data.result;
    //             console.log(result);
    //             mIssueMrReport(result, flag);

    //         },
    //         error: function (error) {
    //             console.log(error);
    //             showErrorMessage();

    //         },
    //         complete: function () {
    //             $('#btnPrint').text('Print');
    //             $('.btn').prop("disabled", false);
    //         }

    //     });

    // }



}



function stockValuationAverageReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Stock Valuation - Average', fontSize: 14, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Filterd by :' + getFilterString(), fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, 100, 100, '*', 50, 50, 50],
                headerRows: 1,
                body: stockValuationAverageReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function stockValuationAverageAsAtReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Stock Valuation - Average As at ' + $('#txtDateTo').val(), fontSize: 14, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Filterd by :' + getFilterString(), fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, 100, 100, '*', 50, 50, 50],
                headerRows: 1,
                body: stockValuationAverageReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function stockValuationAverageReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Product ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group 01', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group 02', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Unit Of Mesurment', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Balance', fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: 'Value', fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    ]);
    for (i = 0; i < result.length; i++) {
        var balance = parseFloat(result[i].balance);
        if (isNaN(balance)) {
            balance = 0;
        }
        var value = parseFloat(result[i].value);
        if (isNaN(value)) {
            value = 0;
        }
        body.push([
            { text: result[i].product_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].product_name, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].group1, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].group2, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].unit_of_mesurment, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: balance.toFixed(2), fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
            { text: value.toFixed(2), fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
        ]);
    }
    return body;
}





function stockValuationBatchWiseReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Stock Valuation - Batch Wise', fontSize: 14, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Filterd by :' + getFilterString(), fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, '*', 60, 60, 50, 50, 50],
                headerRows: 1,
                body: stockValuationBatchWiseReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}

function stockValuationBatchWiseReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Product ID', fontSize: font_size, bold: true, alignment: 'left', border: [true, true, true, true] },
    { text: 'Product Name', fontSize: font_size, bold: true, alignment: 'left', border: [true, true, true, true] },
    { text: 'Group 01', fontSize: font_size, bold: true, alignment: 'left', border: [true, true, true, true] },
    { text: 'Group 02', fontSize: font_size, bold: true, alignment: 'left', border: [true, true, true, true] },
    { text: 'Unit Of Mesurment', fontSize: font_size, bold: true, alignment: 'left', border: [true, true, true, true] },
    { text: 'Balance', fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: 'Value', fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    ]);
    for (i = 0; i < result.length; i++) {
        var balance = parseFloat(result[i].balance);
        if (isNaN(balance)) {
            balance = 0;
        }
        var value = parseFloat(result[i].value);
        if (isNaN(value)) {
            value = 0;
        }
        body.push([
            { text: result[i].product_id, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].product_name, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].group1, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].group2, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].unit_of_mesurment, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: balance.toFixed(2), fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
            { text: value.toFixed(2), fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
        ]);
    }
    return body;
}






function grnReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'GRN Bags Report', fontSize: 12, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'From ' + $('#txtDateFrom').val() + ' to ' + $('#txtDateTo').val(), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Filterd by :' + getFilterString(), fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [45, 20, 50, 60, 40, 80, 55, 55, 20, 70, 45, 40, '*'],
                headerRows: 1,
                body: grnReportBody(result),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}

function grnReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Date', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'PR Number', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'PO Number', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'GRN Number', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group 01', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group 02', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Supplier Code', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Supplier name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'UOM', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Qty', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Value', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    ]);

    var total_qty = 0;
    var total_value = 0;
    for (var i = 0; i < result.length; i++) {
        body.push([{ text: result[i].date, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].pr_no, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].po_number, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].grn_number, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].product_code, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].product_name, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].group1, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].group2, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].supplier_code, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].supplier_name, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].uom, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: parseFloat(result[i].quantity).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: false, alignment: 'right', border: [true, true, true, true] },
        { text: parseFloat(result[i].value).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: false, alignment: 'right', border: [true, true, true, true] },
        ]);

        total_qty += parseFloat(result[i].quantity);
        total_value += parseFloat(result[i].value);
    }

    body.push([{ text: "Total :", fontSize: font_size, bold: true, alignment: 'left', border: [true, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: total_qty.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_value.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    ]);
    return body;
}



function grnMrReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'GRN MR Report', fontSize: 12, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'From ' + $('#txtDateFrom').val() + ' to ' + $('#txtDateTo').val(), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Filterd by :' + getFilterString(), fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [45, 30, 30, 60, 40, 80, 55, 55, 40, 70, 40, 50, '*'],
                headerRows: 1,
                body: grnMrReportBody(result),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}

function grnMrReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Date', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'PR Number', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'PO Number', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'GRN Number', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group 01', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group 02', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Supplier Code', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Supplier name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'UOM', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Weight', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Value', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    ]);

    var total_qty = 0;
    var total_value = 0;
    for (var i = 0; i < result.length; i++) {
        body.push([{ text: result[i].date, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].pr_no, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].po_no, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].grn_number, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].product_code, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].product_name, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].group1, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].group2, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].supplier_code, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].supplier_name, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].uom, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: parseFloat(result[i].net_weight).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: false, alignment: 'right', border: [true, true, true, true] },
        { text: parseFloat(result[i].value).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: false, alignment: 'right', border: [true, true, true, true] },
        ]);

        total_qty += parseFloat(result[i].net_weight);
        total_value += parseFloat(result[i].value);
    }

    body.push([{ text: "Total :", fontSize: font_size, bold: true, alignment: 'left', border: [true, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: total_qty.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: total_value.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    ]);
    return body;
}




function ginReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Material Issue Bags Report', fontSize: 12, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'From ' + $('#txtDateFrom').val() + ' to ' + $('#txtDateTo').val(), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Filterd by :' + getFilterString(), fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, '*', '*', 40, 40, '*', 55, 55, 50, 50],
                headerRows: 1,
                body: ginReportBody(result),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}

function ginReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Date', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Department', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Person', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'GIN Number', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group 01', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group 02', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'UOM', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Qty', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    ]);

    var total_qty = 0;
    for (var i = 0; i < result.length; i++) {
        body.push([{ text: result[i].date, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].department, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].person, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].gin_number, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].product_code, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].product_name, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].group1, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].group2, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].uom, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: parseFloat(result[i].quantity).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: false, alignment: 'right', border: [true, true, true, true] },
        ]);

        total_qty += parseFloat(result[i].quantity);
    }

    body.push([{ text: "Total :", fontSize: font_size, bold: true, alignment: 'left', border: [true, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: total_qty.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    ]);
    return body;
}



function mIssueMrReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];

    var Header = [
        {
            content: [
                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Material Issue MR Report', fontSize: 12, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'From ' + $('#txtDateFrom').val() + ' to ' + $('#txtDateTo').val(), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Filterd by :' + getFilterString(), fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                        ],
                    },
                    margin: [0, 0],
                },
            ]
        }
    ];

    var Body = [
        {
            table: {
                widths: [50, '*', '*', 60, 40, '*', 55, 55, 50, 50],
                headerRows: 1,
                body: mIssueMrReportBody(result),
            },
        },
    ];

    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];

    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}

function mIssueMrReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Date', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Department', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Person', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'GIN MR Number', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group 01', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group 02', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'UOM', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Qty', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    ]);

    var total_qty = 0;
    for (var i = 0; i < result.length; i++) {
        body.push([{ text: result[i].date, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].department, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].person, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].gin_number, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].product_code, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].product_name, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].group1, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].group2, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].uom, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: parseFloat(result[i].quantity).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: false, alignment: 'right', border: [true, true, true, true] },
        ]);

        total_qty += parseFloat(result[i].quantity);
    }

    body.push([{ text: "Total :", fontSize: font_size, bold: true, alignment: 'left', border: [true, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: total_qty.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    ]);
    return body;
}



function goodTransferReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Good Transfer Bags Report', fontSize: 12, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'From ' + $('#txtDateFrom').val() + ' to ' + $('#txtDateTo').val(), fontSize: 10, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Filterd by :' + getFilterString(), fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, '*', 50, 50, '*', 55, 55, 50, 50],
                headerRows: 1,
                body: goodTransferReportBody(result),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}

function goodTransferReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Date', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Location', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    //{ text: 'Person', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Reference Number', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    //{ text: 'PO Number', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group 01', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Group 02', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'UOM', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Qty', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    ]);

    var total_qty = 0;
    for (var i = 0; i < result.length; i++) {
        body.push([{ text: result[i].date, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].location, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        //{ text: result[i].person, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].reference_number, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        //{ text: result[i].po_number, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].product_code, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].product_name, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].group1, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].group2, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].uom, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: parseFloat(result[i].quantity).toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: false, alignment: 'right', border: [true, true, true, true] },
        ]);

        total_qty += parseFloat(result[i].quantity);
    }

    body.push([{ text: "Total :", fontSize: font_size, bold: true, alignment: 'left', border: [true, true, false, true] },
    //{ text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    //{ text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: "", fontSize: font_size, bold: false, alignment: 'left', border: [false, true, false, true] },
    { text: total_qty.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).toString(), fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    ]);
    return body;
}






function supplierListReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Supplier List', fontSize: 12, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: 'Filterd by :' + getFilterString(), fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [150, 100, '*', 80, 80, 80],
                headerRows: 1,
                body: supplierListReportBody(result),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('landscape');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}



function supplierListReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Supplier Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Country', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Address', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'District', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Town', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Type', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    ]);

    for (var i = 0; i < result.length; i++) {
        body.push([{ text: result[i].supplier_name, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].country, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].address, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].district, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].town, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        { text: result[i].type, fontSize: font_size, bold: false, alignment: 'left', border: [true, true, true, true] },
        ]);
    }


    return body;
}


//////////////////////////////////////








function showDate(args) {

    $('#startDate').hide();
    $('#endDate').hide();
    if (args == 'SINGLE_DATE') {
        $('#endDate').show();
    } else if (args == 'DATE_RANGE') {
        $('#startDate').show();
        $('#endDate').show();
    }
}



function _export() {
    createReport('EXPORT');
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


function getFilterString() {
    var filters = "";
    if ($('#checkSiteSearch').is(":checked")) {
        filters += " Site: " + $("#selcSite option:selected").text() + ", ";
    }
    if ($('#checkStoresSearch').is(":checked")) {
        filters += " Stores: " + $("#selcStores option:selected").text() + ", ";
    }
    if ($('#checkProductTypeSearch').is(":checked")) {
        filters += " ProductType: " + $("#selcProductType option:selected").text() + ", ";
    }
    if ($('#checkProductGroupLevel1Search').is(":checked")) {
        filters += " GroupLevel1: " + $("#selcProductGroupLevel1 option:selected").text() + ", ";
    }
    if ($('#checkProductGroupLevel2Search').is(":checked")) {
        filters += " GroupLevel2: " + $("#selcProductGroupLevel2 option:selected").text() + ", ";
    }
    if ($('#checkProductGroupLevel3Search').is(":checked")) {
        filters += " GroupLevel3: " + $("#selcProductGroupLevel3 option:selected").text() + ", ";
    }
    if ($('#checkWithout0').is(":checked")) {
        filters += " Without0: " + $("#selcWithout0 option:selected").text() + ", ";
    }
    if ($('#checkProductName').is(":checked")) {
        filters += " ProductName: " + $("#selcProductName option:selected").text() + ", ";
    }
    return filters;
}


function showAllFilters() {
    $('#divStore').show();
    $('#divProductType').show();
    $('#divGroupLevel1').show();
    $('#divGroupLevel2').show();
    $('#divGroupLevel3').show();
    $('#divSupplierType').show();
    $('#divWithout0').show();
    $('#divProductName').show();
}