
var action = "save";
var tableData = undefined;
var GRN_ID = undefined;
const TOKEN = Math.floor(Math.random() * 212345);
$(document).ready(function () {
    $('.status_btn').hide();
    $('#tblGRNAttachment').DataTable({
        responsive: true,
        "order": [],
        "columns": [
            { "data": "file" },
            { "data": "view" },
            { "data": "download" },
            { "data": "delete" },
        ],
        columnDefs: [
            { width: 80, targets: 1 },
            { width: 80, targets: 2 },
            { width: 80, targets: 3 },
        ],
    });



    $('#btnAttachment').on('click', function () {
        $('#attachmentAddModal').modal('toggle');
        //showWarningMessage('Please save purchase order to before upload attachmnet...!');
    });

    $('#cmbPoNo').on('change', function () {
        var po_no = $(this).val();
        getPurchaseOrderByExternalID(po_no);
    });

    var supplierChooser = $('#supplierChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 300, targets: 1 },
        ],
    });

    var supplier_data = allSuppliers();
    console.log(supplier_data);
    supplierChooser.setDataSource(supplier_data);


    supplierChooser.on('select', function (event, data) {
        $('#txtSupplier').val(data[1]);
        $('#txtSupplier').attr("data-id", data[0]);
        var input = supplierChooser.getInput();
        input.focus();

        getPoFromSupplier(data[0]);
    });




    var productChooser = $('#productChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
            { "data": "value1" },
        ],
        columnDefs: [
            { width: 50, targets: 0 },
            { width: 200, targets: 1 },
            { width: 300, targets: 2 },
        ],
    });

    var product_data = allProduct();
    console.log(product_data);
    productChooser.setDataSource(product_data);

    $('#attachmnet_token').val(TOKEN);


    tableData = $('#tblData').transactionTable({
        thead: ['ProductPrimaryID', 'ProductID', 'Product Name', 'Unit', 'Qty', 'Comments', 'Remove'],
        data_chooser: [{ 'col': 2 }],
        chooser: productChooser,
        column_def: { 1: 100 },
        auto_focus: 2,
        row_type: [
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            { 'type': 'select', 'value': [], 'align': 'left', 'width': '100px'},
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '200px' },
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });




    productChooser.on('select', function (event, data) {
        var selected_row = tableData.getSelectedRow();
        var cells = selected_row.getElementsByTagName('td');
        cells[0].childNodes[0].value = data[0];
        cells[1].childNodes[0].value = data[1];
        cells[2].childNodes[0].value = data[2];
        var input = productChooser.getInput();
        input.focus();

        var product_id = data[0];
        var uom = getProduct_Uom(product_id);
        $('#' + cells[3].childNodes[0].id).empty();
        $('#' + cells[3].childNodes[0].id).append('<option value="' + uom.id + '">' + uom.value + '</option>');
    });




    $('input[name="trans_date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });


    $('input[name="deliverBeforeDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    //allEmployees();
    allStores();
    newReferanceID($('#cmbStores').val());



    $('#btnSave').on('click', function () {
        if ($(this).text() == 'Save') {
            disableSaveButton()
            saveGrn();
        } else {
            if (!isApproved()) {
                updateGrn();
            } else {
                showWarningMessage('This grn has been approved,Cannot be update...!');
            }
        }
    });

    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var id = param[0].split('=')[1].split('&')[0];
        action = param[0].split('=')[2].split('&')[0];
        GRN_ID = id;
        getGrn(id);
        if (action == 'edit') {
            $('#btnSave').text('Update');
            $('.status_btn').hide();
        } else if (action == 'view') {
            $('#btnSave').hide();
            $('.status_btn').show();
        }

    } else {
        tableData.add_empty_row();
        transactionTimeout(60000);//5MINUTES
    }



    $('#txtSupplier').on('input', function () {
        supplierChooser.showChooser($('#txtSupplier'));
    });


    $('#txtDiscountPresentage').on('input', function () {
        overallCalculation();
    });


    $('#cmbStores').on('change', function () {
        newReferanceID($(this).val());
    });

    $('#btnApproveGrn').on('click', function () {
        change_status_confirmation(GRN_ID, 1, "Are you sure want to approve?");
    });
    $('#btnRejectGrn').on('click', function () {
        change_status_confirmation(GRN_ID, 2, "Are you sure want to reject?");
    });


});



Dropzone.options.myDropzone = {
    dictDefaultMessage: 'Drop file here or click to upload!!!!!!!!',
    addRemoveLinks: true,
    init: function () {
        this.on("complete", function (file) {
            allAttachment(1, TOKEN);
        });
    }
};

function getPurchaseOrderByExternalID(id) {
    $.ajax({
        type: "GET",
        url: "/sc/perchaseOrderController/getPurchaseOrderByExternalID/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            tableData.clear();
        },
        success: function (response) {
            var res = response.data.result;
            var request_data = res.request_data;

            if (request_data.length === 0) {
                tableData.add_empty_row();
                return;
            }

            for (var i = 0; i < request_data.length; i++) {
                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].product, 'align': 'left', 'width': '100p%' },
                        { 'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'},
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': '', 'align': 'left', 'width': '200px',},
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }
                    ]
                );
            }
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {}
    });
}



function allEmployees() {
    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/allEmployees",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            //$('#txtReceivedBy').setData(res);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}






function allStores() {
    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/allStores",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbStores').append('<option value="' + res[i].id + '">' + res[i].name + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}






function newReferanceID(storeID) {
    var referanceID = newID("/sc/ReferenceIDController/grnHeaderMaxID", storeID);
    $('#txtExternal_id').val(referanceID);
}






function allProduct() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/allProduct",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}




function allSuppliers() {
    var supplier_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/allSuppliers",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            supplier_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return supplier_data;
}




function saveGrn() {

    newReferanceID($('#cmbStores').val());
    if ($('#txtSupplier').attr("data-id") == '' || $('#txtSupplier').val() == '') {
        showWarningMessage("Please Select Supplier");
        resetSaveButton()
        return;
    }
    if ($('#txtReceivedBy').val() == '') {
        showWarningMessage("Please Enter Received By");
        resetSaveButton()
        return;
    }
    var grn_data = {};
    var grn_data_arr = tableData.dataSource();

    // Check for duplicate products
    var duplicates = findDuplicateProducts(grn_data_arr);
    if (duplicates.length > 0) {
        showWarningMessage('Duplicate products found: ' + duplicates.join(', '));
        resetSaveButton()
        return;
    }

    if (grn_data_arr.length == 0) {
        showWarningMessage("Invalied Grn (Empty list)");
        resetSaveButton()
        return;
    }
    for (var i = 0; i < grn_data_arr.length; i++) {
        if (!grn_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            resetSaveButton()
            return;
        }
        grn_data[i] = JSON.stringify({ "product_id": grn_data_arr[i][0], "product_name": grn_data_arr[i][2], "unit_id": grn_data_arr[i][3], "qty": grn_data_arr[i][4], "comments": grn_data_arr[i][5], });
    }


    $.ajax({
        type: "POST",
        url: '/sc/grnHeaderController/save',
        async: false,
        data: {
            'external_id': $('#txtExternal_id').val(),
            'ref_extenal_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'supplier_Id': $('#txtSupplier').attr("data-id"),
            'received_by': $('#txtReceivedBy').val(),
            'store_id': $('#cmbStores').val(),
            'supplier_ref_no': $('#txtSupplierRefNo').val(),

            //change purchase_order_no input
            // 'purchase_order_no': $('#txtPurchase_order_no').val(),
            'purchase_order_no': $('#cmbPoNo').val(),

            'transport_by': $('#txtTransport_by').val(),
            'vehicle_no': $('#txtVehicle_no').val(),
            'remarks': '',
            'attachment_token': TOKEN,
            'grn_data': grn_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                toastr.success('data saved');
                location.href = '/sc/grn';
            } else {
                showErrorMessage();
            }
            //location.reload();

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
            resetSaveButton()
        },
        complete: function () {
        }

    });
}


// Helper function to find duplicate products
function findDuplicateProducts(data_arr) {
    var products = {};
    var duplicates = [];

    for (var i = 0; i < data_arr.length; i++) {
        var product_id = data_arr[i][0];
        var product_name = data_arr[i][2];

        if (product_id) { // Only check if product_id exists
            var key = product_id + '_' + product_name;
            if (products[key]) {
                if (!duplicates.includes(product_name)) {
                    duplicates.push(product_name);
                }
            } else {
                products[key] = true;
            }
        }
    }

    return duplicates;
}

//disable the save button and show loading icon
function disableSaveButton() {
    $('#btnSave').prop('disabled', true);
    $('#btnSave').html('<i class="fa fa-circle-o-notch fa-spin"></i> Saving...');
}

//reset the save button to default state
function resetSaveButton() {
    $('#btnSave').prop('disabled', false);  
    $('#btnSave').html('Save');
}



function getGrn(id) {
    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/getGrn/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            grn_id = res.internal_id;
            referanceID = res.external_id;
            $("#txtExternal_id").val(res.external_id);
            $("#txtGrnDate").val(res.trans_date);
            $("#txtSupplier").attr("data-id", res.supplier_Id);
            $("#txtSupplier").val(res.supplier);
            //$('#txtReceivedBy').attr("data-id", res.received_by);
            $("#txtReceivedBy").val(res.employee_name);
            setSelectedOption("cmbStores", res.store_id);
            $("#txtSupplierRefNo").val(res.supplier_ref_no);

            //change purchase_order_no input
            // $('#txtPurchase_order_no').val(res.purchase_order_no);
            // $("#cmbPoNo").val(res.purchase_order_no);
            setSelectedOption("cmbPoNo", res.purchase_order_no);

            $("#txtTransport_by").val(res.transport_by);
            $("#txtVehicle_no").val(res.vehicle_no);

            var request_data = res.data;
            for (var i = 0; i < request_data.length; i++) {
                tableData.addRow([
                    {
                        type: "string",
                        val: request_data[i].product_primary_id,
                        align: "left",
                        width: "100px",
                    },
                    {
                        type: "string",
                        val: request_data[i].product_id,
                        align: "left",
                        width: "100px",
                    },
                    {
                        type: "text",
                        val: request_data[i].product,
                        align: "left",
                        width: "100%",
                    },
                    {
                        type: "select",
                        val: request_data[i].uom,
                        align: "left",
                        width: "100px",
                    },
                    {
                        type: "text",
                        val: request_data[i].quantity,
                        align: "right",
                        width: "100px",
                    },
                    {
                        type: "text",
                        val: request_data[i].comments,
                        align: "left",
                        width: "200px",
                    },
                    {
                        type: "remove",
                        val: "X",
                        align: "center",
                        width: "50px",
                    },
                ]);
            }

            allAttachment(id, 0);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {
            progress(false);
        }

    });
}






function updateGrn() {

    if ($('#txtSupplier').attr("data-id") == '' || $('#txtSupplier').val() == '') {
        showWarningMessage("Please Select Supplier");
        return;
    }
    if ($('#txtReceivedBy').val() == '') {
        showWarningMessage("Please Enter Received By");
        return;
    }
    var grn_data = {};
    var grn_data_arr = tableData.dataSource();
    if (grn_data_arr.length == 0) {
        showWarningMessage("Invalied Grn (Empty list)");
        return;
    }
    for (var i = 0; i < grn_data_arr.length; i++) {
        if (!grn_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        grn_data[i] = JSON.stringify({ "product_id": grn_data_arr[i][0], "product_name": grn_data_arr[i][2], "unit_id": grn_data_arr[i][3], "qty": grn_data_arr[i][4], "comments": grn_data_arr[i][5], });
    }

    if (GRN_ID == undefined) {
        showWarningMessage('Grn not selected...!');
        return;
    }


    $.ajax({
        type: "PUT",
        url: '/sc/grnHeaderController/update/' + GRN_ID,
        data: {
            'external_id': $('#txtExternal_id').val(),
            'ref_extenal_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'supplier_Id': $('#txtSupplier').attr("data-id"),
            'received_by': $('#txtReceivedBy').val(),
            'store_id': $('#cmbStores').val(),
            'supplier_ref_no': $('#txtSupplierRefNo').val(),

            //change purchase_order_no input
            // 'purchase_order_no': $('#txtPurchase_order_no').val(),
            'purchase_order_no': $('#cmbPoNo').val(),

            'transport_by': $('#txtTransport_by').val(),
            'vehicle_no': $('#txtVehicle_no').val(),
            'remarks': '',
            'attachment_token': TOKEN,
            'grn_data': grn_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            $('#btnSave').html('<i class="fa fa-circle-o-notch fa-spin"></i>');
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                toastr.success('data updated');
                location.href = '/sc/grnList';
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}





function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


function triggerRowInputs(id, selected_row) {






}




function transactionTableUpdate(table_id) { // override function from transaction_table.js

}



function getProduct_Uom(id) {

    var unit = undefined;
    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/getUom/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            unit = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return unit;
}



function isApproved() {

    var bool = false;
    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/isApproved/" + GRN_ID,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            bool = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return bool;

}



function transactionTimeout(minutes) {

    setInterval(function () {
        if (tableData.getTransactionDelay() > minutes) {
            tableData.reset();
        }
    }, minutes);
}



function allAttachment(purchase_order_id, token) {
    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/allAttachment/" + purchase_order_id + "/" + token,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                var data = [];
                for (var i = 0; i < result.length; i++) {
                    var path = "'" + result[i].path + "'";
                    var id = "'" + result[i].purchase_order_attachment_id + "'";
                    data.push({
                        "file": result[i].path,
                        "view": '<button type= "button" class="btn btn-primary" onclick="viewAttachment(' + path + ');"><i class="fa fa-eye" aria-hidden="true"></i></button> ',
                        "download": '<button type= "button" class="btn btn-success" onclick="downloadAttachment(' + path + ');"><i class="fa fa-download" aria-hidden="true"></i></button> ',
                        "delete": '<button type= "button" class="btn btn-danger" onclick="deleteAttachment(' + id + ');"><i class="fa fa-trash" aria-hidden="true"></i></button> ',
                    });
                }
                var table = $('#tblGRNAttachment').DataTable();
                //table.clear();
                table.rows.add(data).draw();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);

        },

    });
}


function viewAttachment(file) {
    window.open('/grn/' + file);

}


function downloadAttachment(file) {
    var link = document.createElement("a");
    link.download = file;
    link.href = "/grn/" + file;
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    delete link;
}


function getPoFromSupplier(id) {

    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/getPoFromSupplier/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var res = response.data.result;
            for (var i = 0; i < res.length; i++) {
                $('#cmbPoNo').append('<option value="' + res[i].external_id + '">' + res[i].external_id + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function change_status_confirmation(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status(id, status);
            }
        });

}

function change_status(id, status) {

    $.ajax({
        type: "PUT",
        url: '/sc/grnHeaderController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            // document.getElementById('btnApproveGrn').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("GRN approved.");
                } else if (status == 2) {
                    toastr.success("GRN rejected.");
                }

            } else {
                showErrorMessage();
            }
            location.href = '/sc/grnList';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            // document.getElementById('approve'+id).innerHTML = '<i class="fa fa-times" aria-hidden="true"></i>';
        }

    });
}





/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}