$(document).ready(function () {

    var table = $('#myTable').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "reference_no" },
            { "data": "supplier" },
            { "data": "department" },
            { "data": "date" },
            { "data": "approve", className: "approve" },
            { "data": "reject", className: "reject" },
            { "data": "approve_status", className: "approve_status" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 200, targets: 3 },
            { width: 30, targets: 4 },
            { width: 30, targets: 5 },
            { width: 30, targets: 6 }
        ],
    });
    
    allMaterialIssue();

});


function allMaterialIssue() {
    $.ajax({
        type: "GET",
        url: "/sc/MiBagsListController/allMaterialIssue",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['internal_id'];
                    var reference_no = response.data.result[i]['external_id'];
                    var name = response.data.result[i]['employee_name'];
                    var department = response.data.result[i]['department'];
                    var designation = response.data.result[i]['trans_date'];
                    var status = response.data.result[i]['status'];
                    var string_id = "'" + id + "'";

                    var approve_icon = '';
                    var disabled = "";
                    var disabled_reject = "";
                    
                    if (status == 1) {
                        approve_icon = '<i class="fa fa-check-circle-o fa-3x text-success" aria-hidden="true"></i>';
                        disabled = "disabled";
                    } else if (status == 2) {
                        approve_icon = '<i class="fa fa-times-circle-o fa-3x text-danger" aria-hidden="true"></i>';
                        disabled = "disabled";
                        disabled_reject = "disabled";
                    }

                    data.push({
                        "reference_no": reference_no,
                        "supplier": name,
                        "department": department,
                        "date": designation,
                        "approve": `<button class="btn btn-success" onclick="change_status_confirmation_mi('${id}', 1,'Are you sure want to approve?')" ${disabled}> 
                            Approve
                            </button > `,
                        "reject": `<button class="btn btn-danger" onclick="change_status_confirmation_mi('${id}', 2,'Are you sure want to reject?')" ${disabled_reject}>
                            Reject
                            </button>`,
                        "approve_status": approve_icon,
                    });
                }

                var table = $('#myTable').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },

        error: function (error) {
            console.log(error);
        },
        complete: function () {}
    });
}




function change_status_confirmation_mi(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status_mi(id, status);
            }
        });

}

function change_status_mi(id, status) {

    $.ajax({
        type: "PUT",
        url: '/sc/MiBagsController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("Material Issue Bags approved.");
                } else if (status == 2) {
                    toastr.success("Material Issue Bags rejected.");
                }
            } else {
                showErrorMessage();
            }
            location.href = '/sc/material_issues_bags_approval';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {}
    });
}




/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}