
var action = "save";
var tableData = undefined;
var MI_ID = undefined;
var REFFERANCE_ID = undefined;
var EXTERNAL_ID = undefined;
$(document).ready(function () {
    $('.status_btn').hide();

    var miChooser = $('#miChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 300, targets: 1 },
        ],
    });

    var mi_data = allMi();
    miChooser.setDataSource(mi_data);


    var supplierChooser = $('#supplierChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 300, targets: 1 },
        ],
    });

    var supplier_data = allSuppliers();
    supplierChooser.setDataSource(supplier_data);

    var productChooser = $('#productChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
            { "data": "value1" },
        ],
        columnDefs: [
            { width: 50, targets: 0 },
            { width: 200, targets: 1 },
            { width: 300, targets: 2 },
        ],
    });

    var product_data = allProduct();
    console.log(product_data);
    productChooser.setDataSource(product_data);

    tableData = $('#tblData').transactionTable({
        thead: ['ProductPrimaryID', 'ProductID', 'Product Name', 'Unit', 'Qty', 'Comment', 'Remove'],
        data_chooser: [{ 'col': 2 }],
        chooser: productChooser,
        column_def: { 1: 100 },
        auto_focus: 2,
        row_type: [
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            {
                'type': 'select', 'value': [], 'align': 'left', 'width': '100px'
            },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '200px' },
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });


    productChooser.on('select', function (event, data) {
        var selected_row = tableData.getSelectedRow();
        var cells = selected_row.getElementsByTagName('td');
        cells[0].childNodes[0].value = data[0];
        cells[1].childNodes[0].value = data[1];
        cells[2].childNodes[0].value = data[2];
        var input = productChooser.getInput();
        input.focus();

        var product_id = data[0];
        var uom = getProduct_Uom(product_id);
        $('#' + cells[3].childNodes[0].id).empty();
        $('#' + cells[3].childNodes[0].id).append('<option value="' + uom.id + '">' + uom.value + '</option>');
    });


    $('input[name="trans_date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }
    });

    //allEmployees();
    allDepartment();
    allStores();
    allMachine();
    newReferanceID($('#cmbStores').val());
    checkDisableType(0);

    $('#cmbMiType').on('change', function () {
        checkDisableType($(this).val());
    });


    $('#btnSave').on('click', function () {
        if ($(this).text() == 'Save') {
            disableSaveButton();
            saveGoodsReturn();
        } else {
            //updateGoodsReturn();
        }
    });

    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var id = param[0].split('=')[1].split('&')[0];
        action = param[0].split('=')[2].split('&')[0];
        MI_ID = id;
        getMaterialReturn(id);
        if (action == 'edit') {
            $('#btnSave').text('Update');
            $('.status_btn').hide();
        } else if (action == 'view') {
            $('#btnSave').hide();
            $('.status_btn').hide();
        }
    } else {
        tableData.add_empty_row();
    }

    $('#txtmi_id').on('input', function () {
        miChooser.showChooser($(this));
    });


    $('#txtSupplier').on('input', function () {
        supplierChooser.showChooser($(this));
    });

    supplierChooser.on('select', function (event, data) {
        $('#txtSupplier').val(data[1]);
        $('#txtSupplier').attr("data-id", data[0]);
        var input = supplierChooser.getInput();
        input.focus();
    });


    miChooser.on('select', function (event, data) {
        getMaterialIssue(data[0]);
        $('#txtmi_id').val(data[0]);
        $('#txtmi_id').attr("data-id", data[0]);
        var input = miChooser.getInput();
        input.focus();
    });

    $('#cmbStores').on('change', function () {
        newReferanceID($(this).val());
    });

    $('#cmbMiType').on('change', function () {
        if ($(this).val() == '3') {
            $('#txtVehicleNo').prop('disabled', false);
        } else {
            $('#txtVehicleNo').prop('disabled', true);
            $('#txtVehicleNo').val('');
        }
    });

    $('#btnApprove').on('click', function () {
        change_status_confirmation_mi(MI_ID, 1, "Are you sure want to approve?");
    });
    $('#btnReject').on('click', function () {
        change_status_confirmation_mi(MI_ID, 2, "Are you sure want to reject?");
    });


});



function checkDisableType(id) {
    if (id == 1) {
        $('#cmbManufacturingOrder').prop("disabled", false);
        $('#cmbProjectCode').prop("disabled", true);
        $('#cmbProjectCode').empty();
        allManufacturingOrder();
    } else if (id == 2) {
        $('#cmbProjectCode').prop("disabled", false);
        $('#cmbManufacturingOrder').prop("disabled", true);
        $('#cmbManufacturingOrder').empty();
        allProjects();
    } else {
        $('#cmbManufacturingOrder').prop("disabled", true);
        $('#cmbManufacturingOrder').empty();
        $('#cmbProjectCode').prop("disabled", true);
        $('#cmbProjectCode').empty();
    }
}

function allEmployees() {
    $.ajax({
        type: "GET",
        url: "/sc/MaterialReturnBagsController/allEmployees",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var res = response.data.result;
            //console.log(res);
           // $('#txtSupervisor').setData(res);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function allProjects() {
    $.ajax({
        type: "GET",
        url: "/sc/MaterialReturnBagsController/allProjects",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                var code = res[i].code + " - " + res[i].name;
                $('#cmbProjectCode').append('<option value="' + res[i].project_id + '">' + code + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function allDepartment() {
    $.ajax({
        type: "GET",
        url: "/sc/MaterialReturnBagsController/allDepartment",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbDepartment').append('<option value="' + res[i].id + '">' + res[i].department + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function allStores() {
    $.ajax({
        type: "GET",
        url: "/sc/MaterialReturnBagsController/allStores",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbStores').append('<option value="' + res[i].id + '">' + res[i].name + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function allMachine() {
    $.ajax({
        type: "GET",
        url: "/sc/MaterialReturnBagsController/allMachine",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbMachine').append('<option value="' + res[i].machinery_id + '">' + res[i].machinery_no + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function allProduct() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/MaterialReturnBagsController/allProduct",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {}
    });
    return product_data;
}

function allMi() {
    var grn_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/MaterialReturnBagsController/allMi",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            grn_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return grn_data;
}

function allSuppliers() {
    var supplier_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/MaterialReturnBagsController/allSuppliers",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            supplier_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return supplier_data;
}



function newReferanceID(storeID) {
    var referanceID = newID("/sc/ReferenceIDController/materialReturnBagsHeaderMaxID", storeID);
    EXTERNAL_ID = referanceID;
    $('#txtExternal_id').val(referanceID);
}


function saveGoodsReturn() {


    newReferanceID($('#cmbStores').val());
    var return_data = {};
    var return_data_arr = tableData.dataSource();

    // Check for duplicate products
    var duplicates = findDuplicateProducts(return_data_arr);
    if (duplicates.length > 0) {
        showWarningMessage('Duplicate products found: ' + duplicates.join(', '));
        resetSaveButton()
        return;
    }

    for (var i = 0; i < return_data_arr.length; i++) {
        return_data[i] = JSON.stringify({ "product_id": return_data_arr[i][0], "product_name": return_data_arr[i][2], "unit_id": return_data_arr[i][3], "qty": return_data_arr[i][4], "comments": return_data_arr[i][5], });
    }

    if (MI_ID == undefined || REFFERANCE_ID == undefined) {
        showWarningMessage('Material Return not selected...!');
        resetSaveButton();
        return;
    }


    $.ajax({
        type: "POST",
        url: '/sc/MaterialReturnBagsController/save',
        data: {
            'internal_id': MI_ID,
            'return_data': return_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            console.log(response);
            toastr.success('Data saved');
            location.href = '/sc/material_return_bags';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
            resetSaveButton();
        },
        complete: function () {}
    });
}

// Helper function to find duplicate products
function findDuplicateProducts(data_arr) {
    var products = {};
    var duplicates = [];
    for (var i = 0; i < data_arr.length; i++) {
        var product_id = data_arr[i][0];
        var product_name = data_arr[i][2];

        if (product_id) { // Only check if product_id exists
            var key = product_id + '_' + product_name;
            if (products[key]) {
                if (!duplicates.includes(product_name)) {
                    duplicates.push(product_name);
                }
            } else {
                products[key] = true;
            }
        }
    }
    return duplicates;
}

//disable the save button and show loading icon
function disableSaveButton() {
    $('#btnSave').prop('disabled', true);
    $('#btnSave').html('<i class="fa fa-circle-o-notch fa-spin"></i> Saving...');
}

//reset the save button to default state
function resetSaveButton() {
    $('#btnSave').prop('disabled', false);  
    $('#btnSave').html('Save');
}

function updateGoodsReturn() {

    var grn_data = {};
    var grn_data_arr = tableData.dataSource();
    for (var i = 0; i < grn_data_arr.length; i++) {
        grn_data[i] = JSON.stringify({ "product_id": grn_data_arr[i][0], "product_name": grn_data_arr[i][1], "unit_id": grn_data_arr[i][2], "qty": grn_data_arr[i][3], "comments": grn_data_arr[i][4], });
    }


    if (GRN_ID == undefined || REFFERANCE_ID == undefined) {
        showWarningMessage('Goods Return not selected...!');
        return;
    }

    $.ajax({
        type: "PUT",
        url: '/sc/grnReturnController/update/' + GRN_ID,
        data: {
            'internal_id': GRN_ID,
            'external_id': EXTERNAL_ID,
            'ref_external_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'supplier_Id': $('#txtSupplier').attr("data-id"),
            'received_by': $('#txtReceivedBy').optionID(),
            'store_id': $('#cmbStores').val(),
            'supplier_ref_no': $('#txtSupplierRefNo').val(),
            'purchase_order_no': $('#txtPurchase_order_no').val(),
            'transport_by': $('#txtTransport_by').val(),
            'vehicle_no': $('#txtVehicle_no').val(),
            'vehicle_no':$('#txtVehicleNo').val(),
            'remarks': '',
            'grn_data': grn_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            toastr.success('data updated');
            location.href = '/sc/goodsReturnList';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}





function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}





function getProduct_Uom(id) {
    var unit = undefined;
    $.ajax({
        type: "GET",
        url: "/sc/MaterialReturnBagsController/getUom/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            unit = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return unit;
}


function triggerRowInputs(id, selected_row) {

    if (id == "tblData") {
        var cells = selected_row.getElementsByTagName('td');
        var product = $('#' + cells[0].childNodes[0].id);
        var quantity = $('#' + cells[3].childNodes[0].id);
        quantity.on('input', function () {
            var av_qty = getAvailableQty(product.val(), $('#cmbStores').val());
            var qty = parseFloat(quantity.val());
            if (qty > av_qty) {
                showAlert("Available quantity is " + av_qty);
                quantity.val(av_qty);
            }
        });
    }

}




function getAvailableQty(product_id, store_id) {
    var qty = 0;
    $.ajax({
        type: "GET",
        url: "/sc/MaterialReturnBagsController/getQty/" + product_id + "/" + store_id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            qty = response.data.result;
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {

        }

    });
    return qty;
}



function showAlert(message) {
    swal({
        title: message,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    });

    $('.swal-button').on('click', function () {

    });

}










function getMaterialIssue(id) {


    $.ajax({
        type: "GET",
        url: "/sc/MaterialReturnBagsController/getMaterialIssue/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            MI_ID = res.internal_id
            REFFERANCE_ID = res.external_id;

            $('#txtExternal_id').val(res.external_id);
            $('#txtGrnDate').val(res.trans_date);
            setSelectedOption('cmbDepartment', res.dept_id);
            setSelectedOption('cmbMachine', res.machine_id);
            $('#txtSupervisor').val(res.employee_name);
            $('#txtRemarks').val(res.remarks);
            $('#txtVehicleNo').val(res.vehicle_no);
            var mr_internal_id = res.mr_internal_id;
            var mr_extenal_id = res.mr_extenal_id;
            setSelectedOption('cmbStores', res.store_id);
            setSelectedOption('cmbMiType', res.mi_type);
            if (res.mi_type == 1) {
                allManufacturingOrder();
                setSelectedOption('cmbManufacturingOrder', res.manufacturing_order_number);
            } else if (res.mi_type == 2) {
                allProjects();
                setSelectedOption('cmbProjectCode', res.manufacturing_order_number);
            }
            checkDisableType(res.mi_type);

            var request_data = res.data;
            tableData.clear();
            for (var i = 0; i < request_data.length; i++) {
                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].product, 'align': 'left', 'width': '100%' },
                        { 'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'},
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].comments, 'align': 'left', 'width': '200px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}





function getMaterialReturn(id) {
    $.ajax({
        type: "GET",
        url: "/sc/MaterialReturnBagsController/getMaterialReturn/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            //progress(true);
        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            MI_ID = res.internal_id
            REFFERANCE_ID = res.external_id;

            $('#txtExternal_id').val(res.external_id);
            $('#txtGrnDate').val(res.trans_date);
            setSelectedOption('cmbDepartment', res.dept_id);
            setSelectedOption('cmbMachine', res.machine_id);
            $('#txtSupervisor').val(res.employee_name);
            $('#txtRemarks').val(res.remarks);
            $('#txtVehicleNo').val(res.vehicle_no);
            var mr_internal_id = res.mr_internal_id;
            var mr_extenal_id = res.mr_extenal_id;
            setSelectedOption('cmbStores', res.store_id);
            setSelectedOption('cmbMiType', res.mi_type);
            if (res.mi_type == 1) {
                allManufacturingOrder();
                setSelectedOption('cmbManufacturingOrder', res.manufacturing_order_number);
            }


            var request_data = res.data;
            for (var i = 0; i < request_data.length; i++) {
                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].product, 'align': 'left', 'width': '100%' },
                        {
                            'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'
                        },
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].comments, 'align': 'left', 'width': '200px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {
            //progress(false);
        }

    });
}



function allManufacturingOrder() {
    $.ajax({
        type: "GET",
        url: "/sc/MaterialReturnBagsController/allProductCustomer",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbManufacturingOrder').append('<option value="' + res[i].customer_order_plan_id + '">' + res[i].manufacturing_order_number + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}


function change_status_confirmation_mi(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status_mi(id, status);
            }
        });

}

function change_status_mi(id, status) {

    $.ajax({
        type: "PUT",
        url: '/sc/MaterialReturnBagsController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            // document.getElementById('btnApproveGrn').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("Material Issue Bag approved.");
                } else if (status == 2) {
                    toastr.success("Material Issue Bag rejected.");
                }

            } else {
                showErrorMessage();
            }
            location.href = '/sc/material_return_bags_list';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            // document.getElementById('approve'+id).innerHTML = '<i class="fa fa-times" aria-hidden="true"></i>';
        }

    });
}



/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}