
var action = "save";
var tableData = undefined;
var MI_ID = undefined;
$(document).ready(function () {
    $('.status_btn').hide();

    var productChooser = $('#productChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
            { "data": "value1" },
        ],
        columnDefs: [
            { width: 50, targets: 0 },
            { width: 200, targets: 1 },
            { width: 300, targets: 2 },
        ],
    });

    var product_data = allProduct();
    console.log(product_data);
    productChooser.setDataSource(product_data);




    tableData = $('#tblData').transactionTable({
        thead: ['ProductPrimaryID', 'ProductID', 'Product Name', 'Unit', 'Available Qty', 'Qty', 'HiddenQty', 'Comment', 'Remove'],
        data_chooser: [{ 'col': 2 }],
        chooser: productChooser,
        column_def: { 1: 100 },
        auto_focus: 2,
        row_type: [
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            {
                'type': 'select', 'value': [], 'align': 'left', 'width': '100px'
            },
            { 'type': 'string', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'hidden', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '200px' },
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });
    tableData.setDataChooserHideStatus(true);




    productChooser.on('select', function (event, data) {
        var selected_row = tableData.getSelectedRow();
        var cells = selected_row.getElementsByTagName('td');
        cells[0].childNodes[0].value = data[0];
        cells[1].childNodes[0].value = data[1];
        cells[2].childNodes[0].value = data[2];
        cells[4].childNodes[0].value = getAvailableQty(data[0], $('#cmbStores').val());
        var input = productChooser.getInput();
        input.focus();


        var product_id = data[0];
        var uom = getProduct_Uom(product_id);
        $('#' + cells[3].childNodes[0].id).empty();
        $('#' + cells[3].childNodes[0].id).append('<option value="' + uom.id + '">' + uom.value + '</option>');
    });






    $('input[name="trans_date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    //allEmployees();
    allDepartment();
    allStores();
    allMachine();
    newReferanceID($('#cmbStores').val());
    checkDisableType(0);




    $('#cmbMiType').on('change', function () {
        checkDisableType($(this).val());
    });

    $('#cmbStores').on('change', function () {
        tableData.reset();
        newReferanceID($(this).val());

        if($(this).val() == 13){
            tableData.setDataChooserHideStatus(false);
            $('#btnRetrieveMR').hide();
        }else{
            tableData.setDataChooserHideStatus(true);
            $('#btnRetrieveMR').show();
        }
    });



    $('#btnSave').on('click', function () {

        if ($(this).text() == 'Save') {
            disableSaveButton();
            saveMaterialIssue();
        } else {
            if (!isApproved()) {
                updateMaterialIssue();
            } else {
                showWarningMessage('This Material Issue Cannot be update...!');
            }

        }
    });




    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var id = param[0].split('=')[1].split('&')[0];
        action = param[0].split('=')[2].split('&')[0];
        MI_ID = id;
        getMaterialIssue(id);
        if (action == 'edit') {
            $('#btnSave').text('Update');
            $('.status_btn').hide();
        } else if (action == 'view') {
            $('#btnSave').hide();
            $('.status_btn').hide();
        }

    } else {
        tableData.add_empty_row();
    }



    $('#cmbMiType').on('change', function () {

        if ($(this).val() == '3') {
            $('#txtVehicleNo').prop('disabled', false);
            $('#txtToStore').prop('disabled', true);
        } else if($(this).val() == '4'){ 
            $('#txtToStore').prop('disabled', false);
            $('#txtVehicleNo').prop('disabled', true);
        } 
        else {
            $('#txtVehicleNo').prop('disabled', true);
            $('#txtToStore').prop('disabled', true);
            $('#txtVehicleNo').val('');
        }
    });



    $('#btnApprove').on('click', function () {
        change_status_confirmation_mi(MI_ID, 1, "Are you sure want to approve?");
    });
    $('#btnReject').on('click', function () {
        change_status_confirmation_mi(MI_ID, 2, "Are you sure want to reject?");
    });


});



function checkDisableType(id) {
    if (id == 1) {
        $('#cmbManufacturingOrder').prop("disabled", false);
        $('#cmbProjectCode').prop("disabled", true);
        $('#cmbProjectCode').empty();
        allManufacturingOrder();
    } else if (id == 2) {
        $('#cmbProjectCode').prop("disabled", false);
        $('#cmbManufacturingOrder').prop("disabled", true);
        $('#cmbManufacturingOrder').empty();
        allProjects();
    } else {
        $('#cmbManufacturingOrder').prop("disabled", true);
        $('#cmbManufacturingOrder').empty();
        $('#cmbProjectCode').prop("disabled", true);
        $('#cmbProjectCode').empty();
    }
}



function allEmployees() {
    $.ajax({
        type: "GET",
        url: "/sc/miHeaderController/allEmployees",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            //$('#txtSupervisor').setData(res);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function allProjects() {
    $.ajax({
        type: "GET",
        url: "/sc/miHeaderController/allProjects",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                var code = res[i].code + " - " + res[i].name;
                $('#cmbProjectCode').append('<option value="' + res[i].project_id + '">' + code + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function allDepartment() {
    $.ajax({
        type: "GET",
        url: "/sc/miHeaderController/allDepartment",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbDepartment').append('<option value="' + res[i].department_id + '">' + res[i].department + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function allStores() {
    $.ajax({
        type: "GET",
        url: "/sc/miHeaderController/allStores",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbStores').append('<option value="' + res[i].id + '">' + res[i].name + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function newReferanceID(storeID) {
    var referanceID = newID("/sc/ReferenceIDController/materialIssueMaxID", storeID);
    $('#txtExternal_id').val(referanceID);
   
}





function allManufacturingOrder() {
    $.ajax({
        type: "GET",
        url: "/sc/miHeaderController/allProductCustomer",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            $('#cmbManufacturingOrder').empty();
            for (var i = 0; i < res.length; i++) {
                var manufacturing_num = res[i].factory_po_num + '-' + res[i].product_name;
                $('#cmbManufacturingOrder').append('<option value="' + res[i].customer_order_plan_data_id + '">' + manufacturing_num + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}





function allMachine() {
    $.ajax({
        type: "GET",
        url: "/sc/miHeaderController/allMachine",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbMachine').append('<option value="' + res[i].machinery_id + '">' + res[i].machinery_no + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function allProduct() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/miHeaderController/allProduct",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}


function saveMaterialIssue() {

    newReferanceID($('#cmbStores').val());
    if ($('#txtSupervisor').val() == '') {
        showWarningMessage("Please Enter Supervisor");
        resetSaveButton();
        return;
    }

    var mi_data = {};
    var mi_data_arr = tableData.dataSource();

    // Check for duplicate products
    var duplicates = findDuplicateProducts(mi_data_arr);
    if (duplicates.length > 0) {
        showWarningMessage('Duplicate products found: ' + duplicates.join(', '));
        resetSaveButton()
        return;
    }

    if (mi_data_arr.length == 0) {
        showWarningMessage("Invalied Material Issue (Empty list)");
        resetSaveButton();
        return;
    }
    for (var i = 0; i < mi_data_arr.length; i++) {
        if (!mi_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            resetSaveButton();
            return;
        }
        if (!mi_data_arr[i][3]) {
            showWarningMessage(mi_data_arr[i][1] + " Invalied Quantity");
            resetSaveButton();
            return;
        }

        // const tr = $('#tblData > tbody > tr').eq(i);   
        // const commentInput = tr.find('td :input').eq(7);  

        const row = $(`#tblData tbody tr:eq(${i})`);
        const commentInput = row.find('td:eq(7) input');

        // Add comment validation
        if (parseFloat(mi_data_arr[i][5]) > 0 && mi_data_arr[i][5] < mi_data_arr[i][6] && !mi_data_arr[i][7]) {
            showWarningMessage("Please add comment for row " + (i + 1));
            
            setTimeout(() => {
                commentInput
                    .css({
                        'backgroundColor': '#fff3cd',
                        'border': '2px solid #ffc107',
                        'boxShadow': '0 0 3px #ffc107'
                    })
                    .focus();
            }, 100);

            resetSaveButton();
            return;
        }
       

        mi_data[i] = JSON.stringify({
            "product_id": mi_data_arr[i][0],
            "product_name": mi_data_arr[i][2],
            "unit_id": mi_data_arr[i][3],
            "qty": mi_data_arr[i][5],
            "comments": mi_data_arr[i][7],
        });

    }

    var quantity_invalied = false;
    var row_count = $('#tblData >tr').length;
    for (var i = 1; i < row_count; i++) {
        var product_id = $('#tblData >tr').eq(i).find("td :input").eq(0).val();
        var store_id = $('#cmbStores').val();
        var available_qty = parseFloat(getAvailableQuantitySaveBefore(product_id, store_id));
        $('#tblData >tr').eq(i).find("td :input").eq(4).val(available_qty);
        if (isNaN(available_qty)) {
            available_qty = 0;
        }

        var qty = parseFloat($('#tblData >tr').eq(i).find("td :input").eq(5).val());
        if (isNaN(qty)) {
            qty = 0;
            $('#tblData >tr').eq(i).find("td :input").eq(5).val(0);
        }

        if (available_qty < qty) {
            // quantity_invalied = true;
            // $('#tblData >tr').eq(i).find("td :input").eq(5).css("background-color", "red");
            // showWarningMessage('Stock balance  is insufficient');
        } else {
            $('#tblData >tr').eq(i).find("td :input").eq(5).css("background-color", "white");
        }

    }

    if (quantity_invalied) {
        resetSaveButton();
        return;
    }
    

    $.ajax({
        type: "POST",
        url: '/sc/miHeaderController/save',
        async:false,
        data: {
            'external_id': $('#txtExternal_id').val(),
            'ref_external_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'dept_id': $('#cmbDepartment').val(),
            'machine_id': '',
            'store_id': $('#cmbStores').val(),
            'employee_name': $('#txtSupervisor').val(),
            'mr_internal_id': MR_ID,
            'mr_extenal_id': MR_EXTERNAL_ID,
            'mi_type': $('#cmbMiType').val(),
            'manufacturing_order_number': '',
            'customer_order_plan_data_id': $('#cmbManufacturingOrder').val(),
            'project_code': $('#cmbProjectCode').val(),
            'vehicle_no': $('#txtVehicleNo').val(),
            'to_store': $('#txtToStore').val(),
            'remarks': $('#txtRemarks').val(),
            'ref_mr_no': $('#ref_mr_no').val(),
            'mi_data': mi_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            console.log(response);
            toastr.success('data saved');
            location.href = '/sc/materialIssue';
            //location.reload();
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
            resetSaveButton();
        },
        complete: function () {}
    });
}

// Helper function to find duplicate products
function findDuplicateProducts(data_arr) {
    var products = {};
    var duplicates = [];
    for (var i = 0; i < data_arr.length; i++) {
        var product_id = data_arr[i][0];
        var product_name = data_arr[i][2];

        if (product_id) { // Only check if product_id exists
            var key = product_id + '_' + product_name;
            if (products[key]) {
                if (!duplicates.includes(product_name)) {
                    duplicates.push(product_name);
                }
            } else {
                products[key] = true;
            }
        }
    }
    return duplicates;
}

//disable the save button and show loading icon
function disableSaveButton() {
    $('#btnSave').prop('disabled', true);
    $('#btnSave').html('<i class="fa fa-circle-o-notch fa-spin"></i> Saving...');
}

//reset the save button to default state
function resetSaveButton() {
    $('#btnSave').prop('disabled', false);  
    $('#btnSave').html('Save');
}


function getMaterialIssue(id) {
    $.ajax({
        type: "GET",
        url: "/sc/miHeaderController/getMaterialIssue/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            grn_id = res.internal_id
            referanceID = res.external_id;

            $('#txtExternal_id').val(res.external_id);
            $('#txtGrnDate').val(res.trans_date);
            setSelectedOption('cmbDepartment', res.dept_id);
            //setSelectedOption('cmbMachine', res.machine_id);
            $('#txtSupervisor').val(res.employee_name);
            $('#txtRemarks').val(res.remarks);
            $('#txtVehicleNo').val(res.vehicle_no);
            var mr_internal_id = res.mr_internal_id;
            var mr_extenal_id = res.mr_extenal_id;
            setSelectedOption('cmbStores', res.store_id);
            if($('#cmbStores').val() == 13){
                $('#btnRetrieveMR').hide();
            }
            setSelectedOption('cmbMiType', res.mi_type);
            if (res.mi_type == 3) {
                $('#txtVehicleNo').prop('disabled', false);
            }
            if (res.mi_type == 1) {
                allManufacturingOrder();
                setSelectedOption('cmbManufacturingOrder', res.schedule_customer_order_plan_id);
            } else if (res.mi_type == 1) {
                allProjects();
                setSelectedOption('cmbProjectCode', res.project_code);
            }
            checkDisableType(res.mi_type);
            $('#cmbMiType').change();
           
            var request_data = res.data;
            for (var i = 0; i < request_data.length; i++) {
                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].product, 'align': 'left', 'width': '100%' },
                        {
                            'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'
                        },
                        { 'type': 'string', 'val': parseFloat(getAvailableQty(request_data[i].product_primary_id, $('#cmbStores').val()))+parseFloat(request_data[i].quantity), 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'hidden', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].comments, 'align': 'left', 'width': '200px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

}





function updateMaterialIssue() {

    if ($('#txtSupervisor').val() == '') {
        showWarningMessage("Please Enter Supervisor");
        return;
    }

    var mi_data = {};
    var mi_data_arr = tableData.dataSource();
    if (mi_data_arr.length == 0) {
        showWarningMessage("Invalied Material Issue (Empty list)");
        return;
    }
    for (var i = 0; i < mi_data_arr.length; i++) {
        if (!mi_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        if (!mi_data_arr[i][3]) {
            showWarningMessage(mi_data_arr[i][1] + " Invalied Quantity");
            return;
        }
        mi_data[i] = JSON.stringify({ "product_id": mi_data_arr[i][0], "product_name": mi_data_arr[i][2], "unit_id": mi_data_arr[i][3], "qty": mi_data_arr[i][5], "comments": mi_data_arr[i][7], });
    }


    if (MI_ID == undefined) {
        showWarningMessage('Material Issue not selected...!');
        return;
    }

    $.ajax({
        type: "PUT",
        url: '/sc/miHeaderController/update/' + MI_ID,
        data: {
            'external_id': $('#txtExternal_id').val(),
            'ref_external_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'dept_id': $('#cmbDepartment').val(),
            'machine_id': '',
            'store_id': $('#cmbStores').val(),
            'employee_name': $('#txtSupervisor').val(),
            'mr_internal_id': '0',
            'mr_extenal_id': '0',
            'mi_type': $('#cmbMiType').val(),
            'manufacturing_order_number': '',
            'schedule_customer_order_plan_id': $('#cmbManufacturingOrder').val(),
            'project_code': $('#cmbProjectCode').val(),
            'remarks': $('#txtRemarks').val(),
            'vehicle_no': $('#txtVehicleNo').val(),
            'to_store': $('#txtToStore').val(),
            'mi_data': mi_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            toastr.success('data updated');
            location.href = '/sc/materialIssueList';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}





function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}





function getProduct_Uom(id) {
    var unit = undefined;
    $.ajax({
        type: "GET",
        url: "/sc/miHeaderController/getUom/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            unit = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return unit;
}


function triggerRowInputs(id, selected_row) {

    if (id == "tblData") {
        var cells = selected_row.getElementsByTagName('td');
        var product = $('#' + cells[0].childNodes[0].id);
        var quantity = $('#' + cells[3].childNodes[0].id);
        quantity.on('input', function () {
            var av_qty = getAvailableQty(product.val(), $('#cmbStores').val());
            var qty = parseFloat(quantity.val());
            if (qty > av_qty) {
                showAlert("Available quantity is " + av_qty);
                // quantity.val(av_qty);
            }
        });
    }

}




function getAvailableQty(product_id, store_id) {
    var qty = 0;
    $.ajax({
        type: "GET",
        url: "/sc/miHeaderController/getQty/" + product_id + "/" + store_id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            qty = response.data.result;
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {

        }

    });
    return qty;
}



function showAlert(message) {
    swal({
        title: message,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    });

    $('.swal-button').on('click', function () {

    });

}



function textKeyTyped(event) {

    var qty = parseFloat($('#' + event.target.id).val());
    var id = event.target.id.replace("col_5_text", "col_6_hidden");
    var hidden_qty = parseFloat($('#' + id).val());

    if (isNaN(qty) && isNaN(hidden_qty)) {
        return;
    }
    if (qty > hidden_qty && $('#cmbStores').val() != 13) {
        showWarningMessage('Quantity is exeded');
        // $('#' + event.target.id).val(hidden_qty);
    }
}




function isApproved() {

    var bool = false;
    $.ajax({
        type: "GET",
        url: "/sc/miHeaderController/isApproved/" + MI_ID,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            bool = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return bool;

}




function change_status_confirmation_mi(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status_mi(id, status);
            }
        });

}

function change_status_mi(id, status) {

    $.ajax({
        type: "PUT",
        url: '/sc/miHeaderController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            // document.getElementById('btnApproveGrn').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("Material Issue approved.");
                } else if (status == 2) {
                    toastr.success("Material Issue rejected.");
                }

            } else {
                showErrorMessage();
            }
            location.href = '/sc/materialIssueList';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            // document.getElementById('approve'+id).innerHTML = '<i class="fa fa-times" aria-hidden="true"></i>';
        }

    });
}



/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}