
var setting_array = {
    "site": null,
    "stores": null,
    "producttype": null,
    "grouplevel1": null,
    "grouplevel2": null,
    "grouplevel3": null,
    "without0": null,
    "productname": null,
};

var REPORT_ID = 0;

$(document).ready(function () {
    allSettings();
    $('#selcStores').prop("disabled", true);


    $('input[name="startDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    $('input[name="startDate"]').on('apply.daterangepicker', function (ev, picker) {
        setDateRangeToDatePickerLast('endDate', picker.startDate.format('YYYY MM D'));
        

    });

    $('input[name="endDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    setDateRangeToDatePickerLast('endDate', $('input[name="startDate"]').val());




    $('#checkStoresSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcStores').prop("disabled", false);
            setting_array.stores = $('#selcStores').val();
        } else {
            $('#selcStores').prop("disabled", true);
            setting_array.stores = null;
        }
        //switch_settings('checkDepartmentSearch');
    });




    $('#selcStores').change(function () {
        setting_array.stores = $('#selcStores').val();
    });


    $('#txtProductName').change(function () {
        setting_array.productname = $('#txtProductName').optionID();
    });

    $('#cmbReport').change(function () {
        REPORT_ID = $(this).val();
        $('#lblEmployee').text('Employee');
        if (REPORT_ID == 1) {
            showDate('DATE_RANGE');
        } else {
            showDate('DATE_RANGE');
        }
    });

});





function allSettings() {

    $.ajax({
        type: "GET",
        url: "/sc/producrtHistoryReport/allSettings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var settings = response.data.result.settings;
                appendOptionCombo("selcStores", settings.stores);
                $('#txtProductName').setData(settings.productname);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}





function appendOptionCombo(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].id + '">' + result[i].value + '</option>');
    }
}








function settings() {

    return "site=" + setting_array.site + "&"
        + "stores=" + setting_array.stores + "&"
        + "producttype=" + setting_array.producttype + "&"
        + "grouplevel1=" + setting_array.grouplevel1 + "&"
        + "grouplevel2=" + setting_array.grouplevel2 + "&"
        + "grouplevel3=" + setting_array.grouplevel3 + "&"
        + "without0=" + setting_array.without0 + "&"
        + "productname=" + setting_array.productname;
}


function createReport(flag) {

    if (setting_array.productname == null) {
        showWarningMessage("Please select Product");
        return;
    }



    if (REPORT_ID == 0) {
        showWarningMessage("Please select Report title");
        return;
    }


    if ($('#txtProductName').val() == "") {
        showWarningMessage("Please select Product.");
        return;
    }



    if (REPORT_ID == 1) {

        $.ajax({
            type: "GET",
            url: "/sc/producrtHistoryReport/productHistoryReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                productHistoryReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    }



}




function productHistoryReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Product History Report', fontSize: 14, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: result['report_date'] + '  -  Opening Balance : ' + result['opening_balance'], fontSize: 8, bold: true, alignment: 'right', border: [false, false, false, false] }],
                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, '*', '*', '*', '*'],
                headerRows: 1,
                body: productHistoryReportBody(result.body),
                //body:[{text:""},{text:""},{text:""},{text:""}],

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function productHistoryReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Date', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Transaction No', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Description', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Quantity', fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: 'Balance', fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].date, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].external_id, fontSize: font_size, alignment: 'center', border: [false, false, false, true] },
            { text: result[i].description, fontSize: font_size, alignment: 'center', border: [false, false, false, true] },
            { text: result[i].quantity, fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
            { text: result[i].balance, fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
        ]);
    }
    return body;
}






function showDate(args) {

    if (args == 'SINGLE_DATE') {
        $('#endDate').hide();
    } else {
        $('#endDate').show();
    }
}



function _export() {
    createReport('EXPORT');
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
