/**
 * java script -settings
 *
 * @author  Sampath Perera
 * @since   2020-11-04
 */


/**
 * Constant
 * DO not change constant
 * 
 * Maped server side and client side
 * Maped html and javascript
 * Maped url pattern with  save , update and search
 * 
 */
const SAVE = "save";
const UPDATE = "update";

const STORES = "Stores";


const TITLE_MAP = {
    'saveStores': 'Add new Stores',


    'updateStores': 'Update Stores',
};


const URL_MAP = {
    'Stores': '/sc/settings/stores',
};

const URL_MAP_SEARCH = {
    'Stores': '/sc/settings/allStores',
};




/**
* showModal
* This function is used to open modal.
* @param event This is the paramter to identify save/update
* @param name This is the paramter to identify settings name
*/
function showModal(event, name) {

    if (name == STORES) {
        $('#settingsAddModalBody').empty();
        var content = '<div class="form-row">';
        content += '<div class="col-md-12 mb-3" id="divStore">';
        content += '<label for="txtName" id="lblDesignation">Stores</label>';
        content += '<input type="text" class="form-control" id="txtSettingName" name="Stores" placeholder="Stores">';
        content += '</div>';
        content += '<div class="col-md-12 mb-3" id="divPrefix">';
        content += '<label for="txtName" id="lblDesignation">Prefix</label>';
        content += '<input type="text" class="form-control" id="txtPrefixName" name="Prefix" placeholder="Prefix">';
        content += '</div>';
        content += '<div class="col-md-12 mb-3">';
        content += '<label for="txtName">Site</label>';
        content += '<select class="form-control" id="txtSite" name="site" ></select>';
        content += '</div>';
        content += '<div class="col-md-12 mb-3" id="divCode">';
        content += '<label for="txtName" id="lblDesignation">Store Code</label>';
        content += '<input type="text" class="form-control" id="txtStoreCode" name="code" placeholder="Code">';
        content += '</div>';
        content += '</div>';
        $('#settingsAddModalBody').append(content);
        allSite();
    }

    var title = TITLE_MAP[event + name];


    $('#txtSettingName').attr('name', name);
    $('#settingsAddModalTitle').text(title);


    if (event == SAVE) {
        $('#btnSetting').attr('name', 'save');
        $('#btnSetting').text('Save');
        $('#txtSettingName').val('');
    }
    if (event == UPDATE) {
        $('#btnSetting').attr('name', 'update');
        $('#btnSetting').text('Update');
        var evt = $('.table tbody').on('click', '.btn', function (event) {
            if (name == STORES) {

                var currow = $(this).closest('tr');
                var id = currow.find('td:eq(0)').attr('id');
                var value = currow.find('td:eq(1)').text();
                var prefix = currow.find('td:eq(2)').text();
                var site = currow.find('td:eq(3)').text();
                var code = currow.find('td:eq(4)').text();
                $('#settingID').val(id);
                $('#txtSettingName').val(value);
                $('#txtPrefixName').val(prefix);
                setSelectedOption('txtSite', site);
                $('#txtStoreCode').val(code);

            }  /*else {
 
                 var currow = $(this).closest('tr');
                 var id = currow.find('td:eq(0)').attr('id');
                 var value = currow.find('td:eq(1)').text();
                 $('#settingID').val(id);
                 $('#txtSettingName').val(value);

             }*/
        });

    }



    $("#settingsAddModal").modal('toggle');
    $('#btnDiv').empty();
    $('#btnDiv').append('<button type="button" class="btn btn-primary" id="btnSetting">Save</button');
}




function showModalOrderType() {


    $('#settingsAddModalBody').empty();
    var content = '<div class="form-row">';
    content += '<div class="col-md-12 mb-3" id="divOrderType">';
    content += '<label for="txtName">Order Type</label>';
    content += '<input type="text" class="form-control" id="txtOrderType" name="orderType" placeholder="Order Type">';
    content += '</div>';
    content += '</div>';
    $('#settingsAddModalBody').append(content);
    $('#settingsAddModalTitle').text('Order Type');
    $('#btnDiv').empty();
    $('#btnDiv').append('<button type="button" class="btn btn-primary" id="btnOrderType" onclick="saveOrderType()">Save</button');
    $("#settingsAddModal").modal('toggle');

}



function showModalPayTerm() {


    $('#settingsAddModalBody').empty();
    var content = '<div class="form-row">';
    content += '<div class="col-md-12 mb-3" id="divPayTerm">';
    content += '<label for="txtName">Pay Term</label>';
    content += '<input type="text" class="form-control" id="txtPayTerm" name="localOrdero" placeholder="Pay Term">';
    content += '</div>';
    content += '</div>';
    $('#settingsAddModalBody').append(content);
    $('#settingsAddModalTitle').text('Pay Term');
    $('#btnDiv').empty();
    $('#btnDiv').append('<button type="button" class="btn btn-primary" id="btnPayTerm" onclick="savePayTerm()">Save</button');
    $("#settingsAddModal").modal('toggle');


}



/**
* JQuery
* This is used to call save function and update function
* Used url pattern
*/
$(document).ready(function () {

    //Toast library for message
    toastr.options = {
        timeOut: 3000,
        progressBar: true,
        showMethod: "slideDown",
        hideMethod: "slideUp",
        showDuration: 200,
        hideDuration: 200
    };
    ////////////

    $('#btnSetting').click(function (event) {
        event.preventDefault();

        var key = $('#txtSettingName').attr('name');
        var url = URL_MAP[key];
        var _token = $("input[name='_token']").val();

        var evt = event.target.name;

        if (evt == SAVE) {

            var form = new FormData();
            form.append("_token", _token);

            if (key == 'Stores') {
                form.append("store", $('#txtSettingName').val());
                form.append("prefix", $('#txtPrefixName').val());
                form.append("site", $('#txtSite').val());
                form.append("code", $('#txtStoreCode').val());
            } else {
                form.append("value", $('#txtSettingName').val());
            }

            save(url, form);

        } else if (evt == UPDATE) {

            var id = $('#settingID').val();

            update(url, id);

        }

    });






});


/**
* save
* This function is used to save settings.
* @param url This is the paramter to ajax request url 
* @param form This is the paramter to ajax data
*/
function save(url, form) {

    $.ajax({
        type: "POST",
        url: url,
        data: form,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Settings has been saved successfully...");
                getSettings(response.data.name);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}


/**
* update
* This function is used to update settings.
* @param url This is the paramter to ajax request url 
* @param id This is the paramter to ajax data
*/
function update(url, id) {

    $.ajax({
        type: 'PUT',
        url: url + '/' + id,
        data: $('#myForm').serialize(),
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                showSuccessMessage("Settings has been updated successfully...");
                getSettings(response.data.name);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



/**
* delete
* This function is used to update settings.
* @param url This is the paramter to ajax request url 
* @param id This is the paramter to ajax data
*/
function _delete(url, id, status) {

    var bool = 0;
    if (status) bool = 1;

    $.ajax({
        type: 'DELETE',
        url: url + '/' + id,
        data: {
            _token: $('input[name=_token]').val(),
            "status": bool
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                if (status) showSuccessMessage("Data has been enabled successfully...");
                if (!status) showSuccessMessage("Data has been disabled successfully...");

                getSettings(response.data.name);

            } else {
                var msg = response.data.message;
                var id = response.data.result;

                if (msg == "assigned") {//assigned settings cannot be disabled
                    showWarningMessage("Settings has been assigned...!");
                    getSettings(response.data.name);
                } else if (msg == "error") {
                    showErrorMessage();
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



/**
* save
* This function is used to disable settings.
* @param event This is the paramter to identifi desable/enable 
*/
function disable(event, name) {

    var url = URL_MAP[name];
    var id = event.target.id;
    var status = event.target.checked;
    _delete(url, id, status);
}



/**
* save
* This function is used to search settings.
* @param key This is the paramter to identifi ajax request url 
*/
function getSettings(key) {

    var url = URL_MAP_SEARCH[key];
    $.ajax({
        type: "GET",
        url: url,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var name = response.data.name;
                var result = response.data.result;
                loadTable(name, result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
            $('.ti-settings').show();
            $('.spinner-border').hide();
        }

    });
}


function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}

/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {

    toastr.success(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


/**
* showWarrningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {

    toastr.warning(message);
}


/**
* loadTable
* This function is used to data set on the tables.
* @param name This is the paramter to identifi table name
* @param name This is the paramter to require table content
*/
function loadTable(name, result) {

    var disable = { 0: "", 1: "checked" }
    var tbody = "";
    var tableName = "#tbl" + name;

    for (i = 0; i < result.length; i++) {

        var row = "<tr>";

        if (name == STORES) {

            row += '<td class="id" id="' + result[i].id + '">' + generateID(result[i].id) + '</td>';
            row += '<td>' + result[i].name + '</td>';
            row += '<td>' + result[i].prefix + '</td>';
            row += '<td hidden>' + result[i].site_id + '</td>';
            row += '<td hidden>' + result[i].store_code + '</td>';
            row += '<td class="edit edit_town">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].id + '" onclick="showModal(' + "'update'" + ',' + "'Stores'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_town">';
            row += '<label class="switch">';
            row += '<input type="checkbox"  id="' + result[i].site_id + '" onchange="disable(event,' + "'Stores'" + ')" ' + disable[result[i].status] + '>';

        }

        row += '<span class="slider round"></span>';
        row += '</label>';
        row += '</td>';
        row += '</tr>';
        tbody += row;
    }
    $(tableName).empty();
    $(tableName).append(tbody);




}



function savePayTerm() {
    $.ajax({
        type: "POST",
        url: '/sc/settingController/savePayTerm',
        data: { 'value': $('#txtPayTerm').val() },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Pay Terms has been saved successfully...");
                getSettings(response.data.name);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



function saveOrderType() {
    $.ajax({
        type: "POST",
        url: '/sc/settingController/saveOrderType',
        data: { 'value': $('#txtOrderType').val() },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("OrderType has been saved successfully...");
                //getSettings(response.data.name);
                allOrderType();

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}





function allSite() {

    $.ajax({
        type: "GET",
        url: "/sc/settings/allSite",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var site = response.data.result;
                appendSiteOption("txtSite", site);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function appendSiteOption(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].site_id + '">' + result[i].site + '</option>');
    }
}




function allOrderType() {

    var disable = { 0: "", 1: "checked" }
    var tbody = "";

    for (i = 0; i < result.length; i++) {

        var row = "<tr>";



        row += '<td class="id" id="' + result[i].order_type_id + '">' + generateID(result[i].result[i].order_type_id) + '</td>';
        row += '<td>' + result[i].order_type + '</td>';
        row += '<td class="edit edit_order">';
        row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].order_type_id + '" onclick="showModal(' + "'update'" + ',' + "'Stores'" + ')">';
        row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

        row += '</td>';
        row += '<td class="disable disable_town">';
        row += '<label class="switch">';
        row += '<input type="checkbox"  id="' + result[i].order_type_id + '" onchange="disable(event,' + "'Stores'" + ')" ' + disable[result[i].status] + '>';



        row += '<span class="slider round"></span>';
        row += '</label>';
        row += '</td>';
        row += '</tr>';
        tbody += row;
    }
    $('#tblOrderType').empty();
    $('#tblOrderType').append(tbody);




}





/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}






