
var setting_array = {
    "site": null,
    "stores": null,
    "producttype": null,
    "grouplevel1": null,
    "grouplevel2": null,
    "grouplevel3": null,
    "without0": null,
    "productname": null,
};

var REPORT_ID = 0;

$(document).ready(function () {
    allSettings();
    showDate('hide');
    $('#selcSite').prop("disabled", true);
    $('#selcStores').prop("disabled", true);
    $('#selcProductType').prop("disabled", true);
    $('#selcProductGroupLevel1').prop("disabled", true);
    $('#selcProductGroupLevel2').prop("disabled", true);
    $('#selcProductGroupLevel3').prop("disabled", true);
    $('#selcWithout0').prop("disabled", true);
    $('#selcProductName').prop("disabled", true);

    $('input[name="startDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    $('input[name="endDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });




    $('#checkSiteSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcSite').prop("disabled", false);
            setting_array.site = $('#selcSite').val();
        } else {
            $('#selcSite').prop("disabled", true);
            setting_array.site = null;
        }
        //switch_settings('checkSiteSearch');
    });


    $('#checkStoresSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcStores').prop("disabled", false);
            setting_array.stores = $('#selcStores').val();
        } else {
            $('#selcStores').prop("disabled", true);
            setting_array.stores = null;
        }
        //switch_settings('checkDepartmentSearch');
    });


    $('#checkProductTypeSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductType').prop("disabled", false);
            var value = $('#selcSection').val();
            setting_array.producttype = $('#selcProductType').val();
            allSubsection(value);
        } else {
            $('#selcProductType').prop("disabled", true);
            setting_array.producttype = null;
        }
        //switch_settings('checkSectionSearch');
    });





    $('#checkProductGroupLevel1Search').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductGroupLevel1').prop("disabled", false);
            setting_array.grouplevel1 = $('#selcProductGroupLevel1').val();
        } else {
            $('#selcProductGroupLevel1').prop("disabled", true);
            setting_array.grouplevel1 = null;
        }
        //switch_settings('checkCompanySearch');
    });


    $('#checkProductGroupLevel2Search').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductGroupLevel2').prop("disabled", false);
            setting_array.grouplevel2 = $('#selcProductGroupLevel2').val();
        } else {
            $('#selcProductGroupLevel2').prop("disabled", true);
            setting_array.grouplevel2 = null;
        }
        //switch_settings('checkTeamSearch');

    });


    $('#checkProductGroupLevel3Search').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductGroupLevel3').prop("disabled", false);
            setting_array.grouplevel3 = $('#selcProductGroupLevel3').val();
        } else {
            $('#selcProductGroupLevel3').prop("disabled", true);
            setting_array.grouplevel3 = null;
        }
        //switch_settings('checkTeamSearch');

    });


    $('#checkWithout0').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcWithout0').prop("disabled", false);
            setting_array.without0 = $('#selcWithout0').val();
        } else {
            $('#selcWithout0').prop("disabled", true);
            setting_array.without0 = null;
        }
        //switch_settings('checkTeamSearch');

    });


    $('#checkProductName').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductName').prop("disabled", false);
            setting_array.productname = $('#selcProductName').val();
        } else {
            $('#selcProductName').prop("disabled", true);
            setting_array.productname = null;
        }
        //switch_settings('checkTeamSearch');

    });


    $('#selcSite').change(function () {
        setting_array.site = $('#selcSite').val();
    });

    $('#selcStores').change(function () {
        setting_array.stores = $('#selcStores').val();
    });

    $('#selcProductType').change(function () {
        setting_array.producttype = $('#selcProductType').val();
    });

    $('#selcProductGroupLevel1').change(function () {
        setting_array.grouplevel1 = $('#selcProductGroupLevel1').val();
    });

    $('#selcProductGroupLevel2').change(function () {
        setting_array.grouplevel2 = $('#selcProductGroupLevel2').val();
    });

    $('#selcProductGroupLevel3').change(function () {
        setting_array.grouplevel3 = $('#selcProductGroupLevel3').val();
    });

    $('#selcWithout0').change(function () {
        setting_array.without0 = $('#selcWithout0').val();
    });

    $('#selcProductName').change(function () {
        setting_array.productname = $('#selcProductName').val();
    });

    $('#cmbReport').change(function () {
        REPORT_ID = $(this).val();
        $('#lblEmployee').text('Employee');
        if (REPORT_ID == 1) {
            showDate('DATE_RANGE');
        } else if (REPORT_ID == 2) {
            showDate('SINGLE_DATE');
        } else {
            showDate('DATE_RANGE');
        }
    });

});





function allSettings() {

    $.ajax({
        type: "GET",
        url: "/sc/stockReport/allSettings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var settings = response.data.result.settings;
                appendOption("selcSite", settings.site);
                appendOption("selcStores", settings.stores);
                appendOption("selcProductType", settings.producttype);
                appendOption("selcProductGroupLevel1", settings.grouplevel1);
                appendOption("selcProductGroupLevel2", settings.grouplevel2);
                appendOption("selcProductGroupLevel3", settings.grouplevel3);
                appendOption("selcProductName", settings.productname);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}





function appendOption(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].id + '">' + result[i].value + '</option>');
    }
}








function settings() {

    return "site=" + setting_array.site + "&"
        + "stores=" + setting_array.stores + "&"
        + "producttype=" + setting_array.producttype + "&"
        + "grouplevel1=" + setting_array.grouplevel1 + "&"
        + "grouplevel2=" + setting_array.grouplevel2 + "&"
        + "grouplevel3=" + setting_array.grouplevel3 + "&"
        + "without0=" + setting_array.without0 + "&"
        + "productname=" + setting_array.productname;
}


function createReport(flag) {

    if (setting_array.site == null && setting_array.stores == null && setting_array.producttype == null && setting_array.grouplevel1 == null && setting_array.grouplevel2 == null && setting_array.grouplevel3 == null && setting_array.without0 == null && setting_array.productname == null) {
        showWarningMessage("Please select setting");
        return;
    }



    if (REPORT_ID == 0) {
        showWarningMessage("Please select Report title");
        return;
    }



    if (REPORT_ID == 1) {

        $.ajax({
            type: "GET",
            url: "/sc/stockReport/stockBalanceReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                stockBalanceReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    } else if (REPORT_ID == 2) {

        $.ajax({
            type: "GET",
            url: "/sc/stockReport/stockBalanceAsAtReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                stockBalanceAsAtReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    }/*else  if (REPORT_ID == 3) {

        $.ajax({
            type: "GET",
            url: "/sc/stockReport/purchaseOrderReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val()+ "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                purchaseOrderReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    }*/



}









function stockBalanceReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Stock Balance Report', fontSize: 14, bold: true, alignment: 'center', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, '*', 100, 100],
                headerRows: 1,
                body: stockBalanceReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}

function stockBalanceAsAtReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Stock Balance As at ' + $('#txtDateTo').val(), fontSize: 14, bold: true, alignment: 'center', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, '*', 100, 100],
                headerRows: 1,
                body: stockBalanceReportBody(result.body),

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function stockBalanceReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Product ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Quantity', fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: 'Unit Of Mesurment', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] }]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].product_id, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].product_name, fontSize: font_size, alignment: 'center', border: [false, false, false, true] },
            { text: result[i].quantity, fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
            { text: result[i].unit_of_mesurment, fontSize: font_size, alignment: 'center', border: [false, false, false, true] },
        ]);
    }
    return body;
}









function productHistoryReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Product History Report', fontSize: 14, bold: true, alignment: 'center', border: [false, false, false, false] }],

                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, '*', '*', '*', '*'],
                headerRows: 1,
                body: productHistoryReportBody(result.body),
                //body:[{text:""},{text:""},{text:""},{text:""}],

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function productHistoryReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Date', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Transaction No', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Description', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Quantity', fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: 'Balance', fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] }]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].date, fontSize: font_size, border: [false, false, false, true] },
            { text: result[i].external_id, fontSize: font_size, alignment: 'center', border: [false, false, false, true] },
            { text: result[i].description, fontSize: font_size, alignment: 'center', border: [false, false, false, true] },
            { text: result[i].quantity, fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
            { text: result[i].balance, fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
        ]);
    }
    return body;
}

//////////////////////////////////////








function showDate(args) {

    $('#startDate').hide();
    $('#endDate').hide();
    if (args == 'SINGLE_DATE') {
        $('#endDate').show();
    }
}



function _export() {
    createReport('EXPORT');
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
