@extends('sc::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/selects/select2.min.css') }}" type="text/css">

<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('sc:js/autocomplete/css/autocomplete.min.css') }}" type="text/css">
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/dropzone/dropzone.css') }}" type="text/css">


<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Goods Received Bags</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">

                <div class="row">
                    <div class="col-md-11 border">
                        <div class="row border-bottom bg-light" style="padding: 10px;">
                            <h6>Goods Received Bags</h6>
                        </div>
                        <div class="row">
                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Reference No.</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtExternal_id" name="external_id" disabled>
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">Date</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtGrnDate" name="trans_date">
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Supplier</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" autocomplete="off" id="txtSupplier" name="supplier_Id">
                                </div>
                            </div>

                        </div>



                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2" style="padding: 0px;">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Received By</div>
                                    </div>
                                    <!--<input type="text" class="form-control form-control-sm auto-complete" autocomplete="off" id="txtReceivedBy" name="received_by" style="min-width: 100%;">!-->
                                    <input type="text" id="txtReceivedBy" name="received_by" class="form-control form-control-sm">
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">Store</div>
                                    </div>
                                    <select id="cmbStores" name="store_id" class="form-control form-control-sm">
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Supplier's Ref.No</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtSupplierRefNo" name="supplier_ref_no">
                                </div>
                            </div>

                        </div>


                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Po No</div>
                                    </div>
                                    <!--<input type="text" class="form-control form-control-sm" id="txtPurchase_order_no" name="purchase_order_no">!-->
                                    <select class="form-control form-control-sm" id="cmbPoNo" name="poNo"></select>
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2 flex-nowrap">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm select2" style="width: 100px;">Manufacturing Order</div>
                                    </div>
                                    <select class="form-control form-control-sm" id="cmbManufacturingOrder" name="cmbManufacturingOrder"></select>
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Transaport By</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtTransport_by" name="transport_by">
                                </div>
                            </div>
                           

                        </div>

                        <div class="row">

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Vehicle No.</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtVehicle_no" name="vehicle_no">
                                </div>
                            </div>

                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped" id="tblData"></table>
                                </div>
                            </div>
                        </div>


                        <hr>


                        <div class="row">
                            <div class="col-md-12 mt-2">
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <button type="button" id="btnAttachment" class="btn btn-primary">Attachment</button>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <div class="table-responsive">
                                            <!-- Required for Responsive -->
                                            <table id="tblGRNAttachment" class="table table-striped  datatable">
                                                <thead>
                                                    <tr>
                                                        <th class="thTitle">Title</th>
                                                        <th class="thView">View</th>
                                                        <th class="thDownload">Down</th>
                                                        <th class="thDelete">Delete</th>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row border">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12 mt-2 mb-2" style="text-align: right;">
                                        <button id="btnSave" class="btn btn-light form-control-sm">Save</button>
                                    </div>
                                </div>
                                <div class="row status_btn" >
                                    <div class="col-md-12 mb-3" style="text-align: left;">
                                        <button type="button" class="btn btn-success text-success form-control-sm" id="btnApproveGrn">Approve</i></button>
                                        <button type="button" class="btn btn-danger text-danger form-control-sm" id="btnRejectGrn" hidden>Reject</i></button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

        </div>
    </div>


    <div id="productChooser"></div>
    <div id="supplierChooser"></div>


    <!--Attachment-->
    <div class="modal fade" id="attachmentAddModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="attachmentAddModalTitle">Add attachment here</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <div class="modal-body" id="attachmentAddModalBody">
                    <div class="row">
                        <div class="col-md-12">
                            <form action="{{route('/grnBagsHeaderController/uploadAttachment')}}" class="dropzone" method="POST" id="myDropzone" name="myDropzone">
                                @csrf
                                <input type="hidden" id="order_id" name="order_id" value="">
                                <input type="hidden" id="attachmnet_token" name="attachmnet_token" value="">
                                <div class="fallback">
                                    <input name="file" type="file" multiple />
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JQuery !-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @endsection

    @section('script')
    <!-- Datepicker -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- AutoComplete -->
    <script src="{{ Module::asset('sc:js/autocomplete/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
    <!-- Datachooser -->
    <script src="{{ url('vendors/dropzone/dropzone.js') }}"></script>
    <script src="{{ url('vendors/selects/select2.min.js') }}"></script>

    <script src="{{ Module::asset('sc:js/progress_widget.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ Module::asset('sc:js/data_chooser.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/transaction_table.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/id_gen.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/goods_received_bags.js') }}?random=<?php echo uniqid(); ?>"></script>





    @endsection