@extends('sc::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">


<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('sc:js/autocomplete/css/autocomplete.min.css') }}" type="text/css">
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/dropzone/dropzone.css') }}" type="text/css">

<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Purchase Order</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">

                <div class="row">
                    <div class="col-md-12 border">
                        <div class="row border-bottom bg-light" style="padding: 10px;">
                            <div class="col-md-10">
                            <h6>Purchase Order</h6>
                            </div>
                            {{-- <div class="col-md-2" style="text-align: right;">
                                <button type="button" class="btn btn-primary" id="btnRetrievePR">Retrieve PR</button>
                            </div> --}}
                        </div>

                        <div class="row">
                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Purchase Request</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" autocomplete="off" id="txt_pr_id" name="pr_id">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Reference No.</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtExternal_id" name="external_id" disabled>
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">Date</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtGrnDate" name="trans_date">
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Supplier</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" autocomplete="off" id="txtSupplier" name="supplier_Id">
                                </div>
                            </div>

                        </div>



                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2" style="padding: 0px;">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Order By</div>
                                    </div>
                                    <!--<input type="text" class="form-control form-control-sm auto-complete" autocomplete="off" id="txtRequestBy" name="request_by" style="min-width: 100%;">!-->
                                    <input type="text" class="form-control form-control-sm" id="txtOrderBy" name="order_by">
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">Store</div>
                                    </div>
                                    <select id="cmbStores" name="store_id" class="form-control form-control-sm">
                                    </select>
                                </div>
                            </div>



                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">Pay Term</div>
                                    </div>
                                    <select id="cmbPayTerm" name="payTerm" class="form-control form-control-sm">
                                    </select>
                                </div>
                            </div>

                        </div>


                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Deliver Before</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtDeliverBeforeDate" name="deliverBeforeDate">
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Order Type</div>
                                    </div>
                                    <select id="cmbOrderType" name="orderType" class="form-control form-control-sm">
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Currency</div>
                                    </div>
                                    <select id="cmbCurrency" name="currency" class="form-control form-control-sm"></select>
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 110px;">Excahnge Rate</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtExchangeRate" name="exchangeRate" style="text-align: right;">
                                    </select>
                                </div>
                            </div>
                        </div>



                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <ul class="nav nav-pills mb-3" role="tablist" id="navMenuItem">
                                    <li class="nav-item">
                                        <a class="nav-link active" id="pills-order-tab" data-toggle="pill" href="#tbOrder" role="tab" aria-controls="pills-order" aria-selected="true">Product</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="pills-product-tab" data-toggle="pill" href="#tbProduct" role="tab" aria-controls="pills-product" aria-selected="false">Other</a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div class="tab-pane fade show active" id="tbOrder" role="tabpanel" aria-labelledby="pills-order-tab">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="table-responsive">
                                                    <table class="table table-sm table-striped" id="tblData"></table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="tab-pane fade" id="tbProduct" role="tabpanel" aria-labelledby="pills-product-tab">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="table-responsive">
                                                    <table class="table table-sm table-striped" id="tblOther"></table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row border">
                            <div class="col-md-9 mt-2">
                                <div class="row">
                                    <div class="col-md-12 mt-1">
                                        <div class="input-group mb-2 mr-sm-2" style="padding: 0px;">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text form-control form-control-sm" style="width: 100px;">Discount(%) :</div>
                                            </div>
                                            <input type="text" class="form-control form-control-sm auto-complete" autocomplete="off" id="txtDiscountPresentage" name="discountPrecentage" style="width: 160px;">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3 mt-2">
                                <div class="row">
                                    <div class="col-md-12 mt-1">
                                        <div class="input-group mb-2 mr-sm-2" style="padding: 0px;">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text form-control form-control-sm" style="width: 100px;">Gross value :</div>
                                            </div>
                                            <input type="text" class="form-control form-control-sm auto-complete" autocomplete="off" id="txtGrossValue" name="grossValue" style="width: 160px;text-align:right;" readonly>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 mt-1">
                                        <div class="input-group mb-2 mr-sm-2" style="padding: 0px;">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text form-control form-control-sm" style="width: 100px;">Discount :</div>
                                            </div>
                                            <input type="text" class="form-control form-control-sm auto-complete" autocomplete="off" id="txtDiscount" name="discount" style="width: 160px;text-align:right;" readonly>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12 mt-1">
                                        <div class="input-group mb-2 mr-sm-2" style="padding: 0px;">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text form-control form-control-sm" style="width: 100px;">Net Value :</div>
                                            </div>
                                            <input type="text" class="form-control form-control-sm auto-complete" autocomplete="off" id="txtNetValue" name="netValue" style="width: 160px;text-align:right;" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row border">
                            <div class="col-md-12 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;height:100%;">Remarks</div>
                                    </div>
                                    <textarea class="form-control form-control-sm" id="txtRemarks" name="remarks"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mt-2">
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <button type="button" id="btnAttachment" class="btn btn-primary">Attachment</button>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <div class="table-responsive">
                                            <!-- Required for Responsive -->
                                            <table id="tblPOAttachment" class="table table-striped  datatable">
                                                <thead>
                                                    <tr>
                                                        <th class="thTitle">Title</th>
                                                        <th class="thView">View</th>
                                                        <th class="thDownload">Down</th>
                                                        <th class="thDelete">Delete</th>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row border">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12 mt-2 mb-2" style="text-align: right;">
                                        <button id="btnSave" class="btn btn-light form-control-sm">Save</button>
                                    </div>
                                </div>
                                <div class="row status_btn">
                                    <div class="col-md-12 mb-3" style="text-align: left;">
                                        <button type="button" class="btn btn-success text-success form-control-sm" id="btnApprove">Approve</i></button>
                                        <button type="button" class="btn btn-danger text-danger form-control-sm" id="btnReject">Reject</i></button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

        </div>
    </div>

    <div id="mrChooser"></div>
    <div id="productChooser"></div>
    <div id="supplierChooser"></div>


    <!--Attachment-->
    <div class="modal fade" id="attachmentAddModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="attachmentAddModalTitle">Add attachment here</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <div class="modal-body" id="attachmentAddModalBody">
                    <div class="row">
                        <div class="col-md-12">
                            <form action="{{route('/perchaseOrderController/uploadAttachment')}}" class="dropzone" method="POST" id="myDropzone" name="myDropzone">
                                @csrf
                                <input type="hidden" id="order_id" name="order_id" value="">
                                <input type="hidden" id="attachmnet_token" name="attachmnet_token" value="">
                                <div class="fallback">
                                    <input name="file" type="file" multiple />
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JQuery !-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @endsection

    @section('script')
    <!-- Datepicker -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- AutoComplete -->
    <script src="{{ Module::asset('sc:js/autocomplete/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ url('vendors/dropzone/dropzone.js') }}"></script>

    <!-- Datachooser -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ Module::asset('sc:js/data_chooser.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/transaction_table.js') }}?random=<?php echo uniqid(); ?>"></script>

    <script src="{{ Module::asset('sc:js/id_gen.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/purchase_order.js') }}?random=<?php echo uniqid(); ?>"></script>





    @endsection