@extends('sc::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.70/pdfmake.js" integrity="sha512-rn5JpU98RtYVMtZeQJfzmJ67rl4/dqDpGZ393z5f9WMYHXEU4+8Stm/PQAma2gbsLbpClmUHJzT0DaG32OmEyQ==" crossorigin="anonymous"></script>
<link rel="stylesheet" href="{{ Module::asset('sc:css/report.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('sc:js/autocomplete/css/autocomplete.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}">

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Stock Valuation Report</h6>
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-6">
                        <i class="fa fa-list-alt text-info" aria-hidden="true"></i>
                        <label>Report</label>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <select class="form-control" id="cmbReport" name="selcReport">
                            <option selected="true" disabled="disabled">-- Select Report --</option>
                            <option value="1">Stock Valuation - Average</option>
                            <option value="3">Stock Valuation - Average As at</option>
                            <option value="2">Stock Valuation - Batch wise</option>
                        </select>
                    </div>
                </div>


                <div class="row">


                    <div class="col-md-6">




                        <!--<div class="row">
                            <div class="col-md-12 mb-3">
                                <div class="row">
                                    <div class="col-md-12">
                                        <table style="width:100%">
                                            <tr>
                                                <td>
                                                    <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                    <label>Site</label>
                                                </td>
                                                <td style="text-align: right">
                                                    <label class="switch"><input type="checkbox" id="checkSiteSearch"><span class="slider round"></span></label>
                                                </td>
                                            </tr>

                                        </table>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-0">
                                        <select class="form-control" id="selcSite" name="selcSite"></select>
                                    </div>
                                </div>
                            </div>
                        </div>!-->


                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <div class="row">
                                    <div class="col-md-12">
                                        <table style="width:100%">
                                            <tr>
                                                <td>
                                                    <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                    <label>Store</label>
                                                </td>
                                                <td style="text-align: right">
                                                    <label class="switch"><input type="checkbox" id="checkStoresSearch"><span class="slider round"></span></label>
                                                </td>
                                            </tr>

                                        </table>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-0">
                                        <select class="form-control" id="selcStores" name="selcStorse"></select>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <div class="row">
                                    <div class="col-md-12">
                                        <table style="width:100%">
                                            <tr>
                                                <td>
                                                    <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                    <label>ProductType</label>
                                                </td>
                                                <td style="text-align: right">
                                                    <label class="switch"><input type="checkbox" id="checkProductTypeSearch"><span class="slider round"></span></label>
                                                </td>
                                            </tr>

                                        </table>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-0">
                                        <select class="form-control" id="selcProductType" name="selcProductType"></select>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <div class="row">
                                    <div class="col-md-12">
                                        <table style="width:100%">
                                            <tr>
                                                <td>
                                                    <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                    <label>Product Group Level1</label>
                                                </td>
                                                <td style="text-align: right">
                                                    <label class="switch"><input type="checkbox" id="checkProductGroupLevel1Search"><span class="slider round"></span></label>
                                                </td>
                                            </tr>

                                        </table>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-0">
                                        <select class="form-control" id="selcProductGroupLevel1" name="selcProductGroupLevel1"></select>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <div class="row">
                                    <div class="col-md-12">
                                        <table style="width:100%">
                                            <tr>
                                                <td>
                                                    <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                    <label>Product Group Level2</label>
                                                </td>
                                                <td style="text-align: right">
                                                    <label class="switch"><input type="checkbox" id="checkProductGroupLevel2Search"><span class="slider round"></span></label>
                                                </td>
                                            </tr>

                                        </table>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-0">
                                        <select class="form-control" id="selcProductGroupLevel2" name="selcProductGroupLevel2"></select>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <div class="row">
                                    <div class="col-md-12">
                                        <table style="width:100%">
                                            <tr>
                                                <td>
                                                    <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                    <label>Product Group Level3</label>
                                                </td>
                                                <td style="text-align: right">
                                                    <label class="switch"><input type="checkbox" id="checkProductGroupLevel3Search"><span class="slider round"></span></label>
                                                </td>
                                            </tr>

                                        </table>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-0">
                                        <select class="form-control" id="selcProductGroupLevel3" name="selcProductGroupLevel3"></select>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <div class="row">
                                    <div class="col-md-12">
                                        <table style="width:100%">
                                            <tr>
                                                <td>
                                                    <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                    <label></label>
                                                </td>
                                                <td style="text-align: right">
                                                    <label class="switch"><input type="checkbox" id="checkWithout0"><span class="slider round"></span></label>
                                                </td>
                                            </tr>

                                        </table>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-0">
                                        <select class="form-control" id="selcWithout0" name="selcWithout0">
                                            <option value="1">Without zeero</option>
                                            <option value="2">With zeero</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <div class="row">
                                    <div class="col-md-12">
                                        <table style="width:100%">
                                            <tr>
                                                <td>
                                                    <i class="fa fa-users text-info" aria-hidden="true"></i>
                                                    <label>Product Name</label>
                                                </td>
                                                <td style="text-align: right">
                                                    <label class="switch"><input type="checkbox" id="checkProductName"><span class="slider round"></span></label>
                                                </td>
                                            </tr>

                                        </table>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-0">
                                        <select class="form-control" id="selcProductName" name="selcProductName"></select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>
                        <div class="row">
                            <div class="col-md-6 mb-3" id="startDate">
                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                <label>Date From</label>
                                <input type="text" class="form-control" id="txtDateFrom" name="startDate">
                            </div>
                            <div class="col-md-6 mb-3" id="endDate">
                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                <label>Date To</label>
                                <input type="text" class="form-control" id="txtDateTo" name="endDate">
                            </div>
                        </div>


                        <hr>

                        <div class="row">
                            <div class="col-md-8 mb-3">
                            </div>
                            <div class="col-md-2 mb-3">
                                <button type="button" class="btn btn-primary" onclick="_export()" id="btnExport">Export</button>
                            </div>
                            <div class="col-md-2 mb-3">
                                <button type="submit" id="btnPrint" class="btn btn-primary" onclick="createReport('PRINT')">Print</button>
                            </div>
                        </div>

                    </div>

                </div>

            </div>
        </div>
    </div>
</div>
@endsection
<!-- JQuery -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

@section('script')
<!-- AutoComplete -->
<script src="{{ Module::asset('sc:js/autocomplete/js/autocomplete.min.js') }}"></script>
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.70/vfs_fonts.js" integrity="sha512-vv3EN6dNaQeEWDcxrKPFYSFba/kgm//IUnvLPMPadaUf5+ylZyx4cKxuc4HdBf0PPAlM7560DV63ZcolRJFPqA==" crossorigin="anonymous"></script>
<script type="application/octet-stream" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.70/fonts/Roboto/Roboto-Medium.ttf"></script>
<script src="{{ Module::asset('sc:js/pdf/Page.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('sc:js/pdf/PDFViewer.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('sc:js/svr.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('sc:js/stock_valuation_report.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection