<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductHistorySetoffsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sc_product_history_setoffs', function (Blueprint $table) {
            $table->id('transaction_id');
            $table->integer('document_no');
            $table->integer('internal_id');
            $table->string('external_id', 100);
            $table->integer('ref_internal_id');
            $table->string('ref_external_id', 100);
            $table->integer('ref_document_no');
            $table->double('quantity');
            $table->double('setoff_quantity');
            $table->double('cost_price');
            $table->integer('grn_internal_id');
            $table->string('grn_external_id',100);
            $table->string('product_id', 100);
            $table->integer('store_id');
            $table->integer('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_history_setoffs');
    }
}
