<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePurchaseOrderHeadersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sc_purchase_order_headers', function (Blueprint $table) {
            $table->id('internal_id');
            $table->string('external_id', 100);
            $table->string('ref_internal_id', 100);
            $table->string('ref_external_id', 100);
            $table->date('trans_date');
            $table->string('supplier_id', 100);
            $table->integer('store_id');
            $table->string('order_by', 100);
            $table->string('employee_name', 100);
            $table->date('deliver_before');
            $table->string('pay_term_id', 100);
            $table->string('order_type_id', 100);
            $table->string('mr_internal_id', 30);
            $table->integer('mr_extenal_id');
            $table->double('discount_overall');
            $table->double('gross_value');
            $table->double('discount');
            $table->double('net_value');
            $table->integer('currency_id');
            $table->double('exchange_rate');
            $table->string('project_code', 100)->nullable();
            $table->integer('status');
            $table->integer('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchase_order_headers');
    }
}
