<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class GoodsTransferAttachment extends Model
{
    use HasFactory,LogsActivity;

    protected $fillable = [];
    protected $table = 'sc_goods_transfer_attachments';
    protected $primaryKey = 'goods_transfer_attachment_id';
    protected static $logAttributes = [
        'goods_transfer_attachment_id',
        'goods_transfer_id',
        'path',
        'token',

    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_goods_transfer_attachments";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
