<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class GrnHeader extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_grn_headers';
    protected $primaryKey = 'internal_id';
    protected static $logAttributes = [
        'internal_id',
        'external_id',
        'ref_internal_id',
        'ref_external_id',
        'trans_date',
        'supplier_Id',
        'received_by',
        'employee_name',
        'store_id',
        'supplier_ref_no',
        'purchase_order_no',
        'transport_by',
        'vehicle_no',
        'remarks',
        'status',
        'document_no',
        'user_id'
    ];
    protected static $logOnlyDirty = true;
    protected $fillable = [];

    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_grn_headers";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }

    /*protected static function newFactory()
    {
        return \Modules\Sc\Database\factories\GrnHeaderFactory::new();
    }*/
}
