<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class MaterialRequestReason extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_material_request_reasons';
    protected $primaryKey = 'material_request_reason_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'material_request_reason_id',
        'reason',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_material_request_reasons";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
