<?php

namespace Modules\Sc\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class PurchaseOrderHeader extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'sc_purchase_order_headers';
    protected $primaryKey = 'internal_id';
    protected $fillable = [];
    protected static $logAttributes = [
        'internal_id',
        'external_id',
        'ref_internal_id',
        'ref_external_id',
        'trans_date',
        'supplier_id',
        'store_id',
        'order_by',
        'employee_name',
        'deliver_before',
        'pay_term_id',
        'order_type_id',
        'mr_internal_id',
        'mr_extenal_id',
        'discount_overall',
        'gross_value',
        'discount',
        'net_value',
        'currency_id',
        'exchange_rate',
        'project_code',
        'status',
        'user_id',
        'ref_pr_id',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "sc_purchase_order_headers";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    /*protected static function newFactory()
    {
        return \Modules\Sc\Database\factories\PurchaseOrderHeaderFactory::new();
    }*/
}
