<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\GoodsReceivedMr;
use Modules\Sc\Entities\ProductHistory;
use Modules\Sc\Entities\StoreLocation;
use Modules\St\Entities\Product;
use Modules\St\Entities\Suppliers;

class GoodsReceivedMrController extends Controller
{
    public function allStores()
    {
        try {
            $stores =  StoreLocation::all();
            $responseBody = $this->responseBody(true, "GoodsReceivedMrController", "allStores", $stores);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsReceivedMrController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    function sites()
    {
        try {
            $Site = EmployeeSite::all();

            $responseBody = $this->responseBody(true, "GoodsReceivedMrController", "sites", $Site);
        } catch (\Exception $ex) {
            $responseBody = $this->responseBody(false, "GoodsReceivedMrController", "sites", $ex);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allSuppliers()
    {
        try {
            $products =  Suppliers::select('supplier_id As id', 'supplier_name As value0')->where('supplier_type_id', '=', 1)->get();
            return $this->responseBody(true, "GoodsReceivedMrController", "allSuppliers", $products);
        } catch (\Exception $exception) {
            return $this->responseBody(false, "GoodsReceivedMrController", "error", $exception);
        }
    }



    public function allProduct()
    {
        try {
            $products =  Product::select('product_primary_id As id', 'product_name As value0')->where('product_type_id', '=', 1)->get();
            return $this->responseBody(true, "GoodsReceivedMrController", "allProduct", $products);
        } catch (Exception $exception) {
            return $this->responseBody(false, "GoodsReceivedMrController", "error", $exception);
        }
    }


    public function getSelectedGoodsReceivedMR($id)
    {
        try {
            $gr_mr =  DB::select('SELECT sc_goods_received_mrs.*,
            st_suppliers.supplier_id,
            st_suppliers.supplier_name,
            hr_employee_sites.site_id,
            sc_store_locations.id AS store_id,
            sc_goods_received_mrs.trans_date,
            st_products.product_primary_id,
            st_products.product_name,
            sc_goods_received_mrs.wastage
            FROM sc_goods_received_mrs INNER JOIN st_suppliers ON sc_goods_received_mrs.supplier_id = st_suppliers.supplier_id
            INNER JOIN st_products ON sc_goods_received_mrs.product_primary_id = st_products.product_primary_id
            INNER JOIN hr_employee_sites ON sc_goods_received_mrs.site_id = hr_employee_sites.site_id
            INNER JOIN sc_store_locations ON sc_goods_received_mrs.store_id =  sc_store_locations.id WHERE sc_goods_received_mrs.internal_id = "' . $id . '"')[0];
            $responseBody =  $this->responseBody(true, "GoodsReceivedMrController", "getSelectedGoodsReceivedMR", $gr_mr);
        } catch (Exception $exception) {
            $responseBody =  $this->responseBody(false, "GoodsReceivedMrController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function save(Request $request)
    {
        try {
            $prefix = $this->getPrefix('400');
            $refferance_no = $prefix . "" . $request->get('refferance_no');
            $trans_date = $request->get('trans_date');
            $supplier_id = $request->get('supplier_id');
            $received_by = $request->get('received_by');
            $site_id = $request->get('site_id');
            $store_id = $request->get('store_id');
            $supplier_reff_no = $request->get('supplier_reff_no');
            $po_no = $request->get('po_no');
            $vehicle_no = $request->get('vehicle_no');
            $driver_name = $request->get('driver_name');
            $weigh_bill_no = $request->get('weigh_bill_no');
            $product_primary_id = $request->get('product_primary_id');
            $first_weight = $request->get('first_weight');
            $first_weight_time = $request->get('first_weight_time');
            $second_weight = $request->get('second_weight');
            $second_weight_time = $request->get('second_weight_time');
            $net_weight = $request->get('net_weight');
            $comment = $request->get('comment');
            $wastage = $request->get('wastage');
            $moisture = $request->get('moisture');
            $sand = $request->get('sand');
            $ec_level = $request->get('ec_level');

            $goodsReceivedMr = new GoodsReceivedMr();
            $goodsReceivedMr->refferance_no = $refferance_no;
            $goodsReceivedMr->trans_date = $trans_date;
            $goodsReceivedMr->supplier_id = $supplier_id;
            $goodsReceivedMr->received_by = $received_by;
            $goodsReceivedMr->site_id = $site_id;
            $goodsReceivedMr->store_id = $store_id;
            $goodsReceivedMr->supplier_reff_no = $supplier_reff_no;
            $goodsReceivedMr->po_no = $po_no;
            $goodsReceivedMr->vehicle_no = $vehicle_no;
            $goodsReceivedMr->driver_name = $driver_name;
            $goodsReceivedMr->weigh_bill_no = $weigh_bill_no;
            $goodsReceivedMr->product_primary_id = $product_primary_id;
            $goodsReceivedMr->first_weight = $first_weight;
            $goodsReceivedMr->first_weight_time = $first_weight_time;
            $goodsReceivedMr->second_weight = $second_weight;
            $goodsReceivedMr->second_weight_time = $second_weight_time;
            $goodsReceivedMr->net_weight = $net_weight;
            $goodsReceivedMr->comment = $comment;
            $goodsReceivedMr->wastage = $wastage;
            $goodsReceivedMr->moisture = $moisture;
            $goodsReceivedMr->sand = $sand;
            $goodsReceivedMr->ec_level = $ec_level;
            $goodsReceivedMr->document_no = 400;
            //$goodsReceivedMr->status = '0';
            if($goodsReceivedMr->save()){
               // $this->addProductToSetoff($goodsReceivedMr->internal_id);
            }

            $responseBody =  $this->responseBody(true, "GoodsReceivedMrController", "save", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsReceivedMrController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function update(Request $request, $id)
    {
        try {
            $goodsReceivedMr = GoodsReceivedMr::find($id);
            if ($goodsReceivedMr) {
                $refferance_no = $request->get('refferance_no');
                $trans_date = $request->get('trans_date');
                $supplier_id = $request->get('supplier_id');
                $received_by = $request->get('received_by');
                $site_id = $request->get('site_id');
                $store_id = $request->get('store_id');
                $supplier_reff_no = $request->get('supplier_reff_no');
                $po_no = $request->get('po_no');
                $vehicle_no = $request->get('vehicle_no');
                $driver_name = $request->get('driver_name');
                $weigh_bill_no = $request->get('weigh_bill_no');
                $product_primary_id = $request->get('product_primary_id');
                $first_weight = $request->get('first_weight');
                $first_weight_time = $request->get('first_weight_time');
                $second_weight = $request->get('second_weight');
                $second_weight_time = $request->get('second_weight_time');
                $net_weight = $request->get('net_weight');
                $comment = $request->get('comment');
                $wastage = $request->get('wastage');
                $moisture = $request->get('moisture');
                $sand = $request->get('sand');
                $ec_level = $request->get('ec_level');

                $goodsReceivedMr->refferance_no = $refferance_no;
                $goodsReceivedMr->trans_date = $trans_date;
                $goodsReceivedMr->supplier_id = $supplier_id;
                $goodsReceivedMr->received_by = $received_by;
                $goodsReceivedMr->site_id = $site_id;
                $goodsReceivedMr->store_id = $store_id;
                $goodsReceivedMr->supplier_reff_no = $supplier_reff_no;
                $goodsReceivedMr->po_no = $po_no;
                $goodsReceivedMr->vehicle_no = $vehicle_no;
                $goodsReceivedMr->driver_name = $driver_name;
                $goodsReceivedMr->weigh_bill_no = $weigh_bill_no;
                $goodsReceivedMr->product_primary_id = $product_primary_id;
                $goodsReceivedMr->first_weight = $first_weight;
                $goodsReceivedMr->first_weight_time = $first_weight_time;
                $goodsReceivedMr->second_weight = $second_weight;
                $goodsReceivedMr->second_weight_time = $second_weight_time;
                $goodsReceivedMr->net_weight = $net_weight;
                $goodsReceivedMr->comment = $comment;
                $goodsReceivedMr->wastage = $wastage;
                $goodsReceivedMr->moisture = $moisture;
                $goodsReceivedMr->sand = $sand;
                $goodsReceivedMr->ec_level = $ec_level;
                $goodsReceivedMr->update();
            }

            $responseBody =  $this->responseBody(true, "GoodsReceivedMrController", "save", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsReceivedMrController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    private function addProductToSetoff($id)
    {
        $query = "SELECT sc_goods_received_mrs.*,st_products.uom_id AS unit_id FROM sc_goods_received_mrs
        INNER JOIN st_products ON sc_goods_received_mrs.product_primary_id = st_products.product_primary_id
        WHERE sc_goods_received_mrs.internal_id = '" . $id . "'";

        $result = DB::select($query);
        foreach ($result as $data) {
            $product_history = new ProductHistory();
            $product_history->internal_id = $data->internal_id;
            $product_history->external_id = $data->refferance_no;
            $product_history->document_no = $data->document_no;
            $product_history->description = "Goods Received MR";
            $product_history->product_id = $data->product_primary_id;
            $product_history->unit_id = $data->unit_id;
            $product_history->quantity = $data->net_weight;
            $product_history->set_off = 0;
            $product_history->cost_price = 0;
            $product_history->store_id = $data->store_id;
            $product_history->user_id = Auth::user()->id;
            $product_history->transaction_date = $data->trans_date;
            $product_history->save();



            $product_history_setoff = new ProductHistorySetOffController();
            $product_history_setoff->saveGoodsReceivedMR($product_history);
        }
    }




    private function getPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }





    public function change_status(Request $request, $id)
    {

        try {

            $grm_header = GoodsReceivedMr::find($id);
            $grm_header->status = $request->get('status');
            if($grm_header->update()){
                $this->addProductToSetoff($id);
            }

            $responseBody = $this->responseBody(true, "GoodsReceivedMrListController", "change_status", true);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GoodsReceivedMrListController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
